<?php
 namespace App; use App\AppSetting; use App\Libs\Utils; use App\Libs\ClusterHelper as CH; use Illuminate\Database\Eloquent\Model; class AppPath extends Model { protected $table = 'app_paths'; protected $fillable = [ 'id', 'app_id', 'path' ]; public static function getAppPathsByAppId($app_id) { return AppPath::where('app_id', '=', $app_id)->pluck('path'); } public static function addPath($add_paths, $app_id) { $path_array = Utils::split_by_comma($add_paths); foreach($path_array as $path) { $primary_ret = parent::updateOrCreate( ['path' => $path, 'app_id' => $app_id], ['path' => $path, 'app_id' => $app_id] ); if(CH::isCluster()) { if(CH::isSlaveActive()) { $secondary_apppath = new AppPath; $secondary_apppath->setConnection('slave_database'); $secondary_ret = $secondary_apppath->updateOrCreate( ['path' => $path, 'app_id' => $app_id], ['path' => $path, 'app_id' => $app_id] ); } CH::updateClusters(!empty($primary_ret->id), !empty($secondary_ret->id)); } } } public static function deletePath($delete_paths, $app_id) { $path_array = Utils::split_by_comma($delete_paths); foreach($path_array as $path) { $primary_count = parent::where('path', $path)->delete(); if(CH::isCluster()) { if(CH::isSlaveActive()) { $secondary_count = self::on('slave_database')->where('path', $path)->delete(); } CH::updateClusters($primary_count > 0, $secondary_count > 0); } } } public static function getAppPathsByAppnames($available_apps) { $app_paths = []; foreach($available_apps as $app) { $app_id = AppSetting::where('appname', '=', $app)->pluck('id'); $path_data = parent::where('app_id', '=', $app_id)->pluck('path')->toArray(); $app_obj = array($app => $path_data); array_push($app_paths, $app_obj); } return $app_paths; } } 