<?php
 namespace App; use Illuminate\Database\Eloquent\Model; use Illuminate\Support\Facades\DB; use App\Libs\ClusterHelper as CH; use App\Models\ChromeSetting; use App\Models\EdgeSetting; use App\VpnSetting; class BrSetting extends Model { protected $fillable = ['name', 'proxy_setting_id', 'chrome_setting_id', 'edge_setting_id', 'available_browser', 'shareprofile_id']; public function chromeSetting() { return $this->belongsTo('App\Models\ChromeSetting'); } public function edgeSetting() { return $this->belongsTo('App\Models\EdgeSetting'); } public function proxySetting() { return $this->belongsTo('App\Models\ProxySetting'); } public function vpnSettings() { return $this->belongsToMany(VpnSetting::class) ->withPivot('order') ->orderBy('pivot_order'); } public function shareprofile() { return $this->belongsTo('App\Shareprofile'); } private static function createOnTarget($attributes, $target) { $setting = null; DB::connection($target)->beginTransaction(); try { $setting = self::on($target)->create($attributes); if (isset($attributes['vpn_settings'])) { $setting->vpnSettings()->attach($attributes['vpn_settings']); } DB::connection($target)->Commit(); } catch (\Exception $e) { logger($e); DB::connection($target)->rollBack(); } return $setting; } public static function create(array $attributes = []) { $setting = self::createOnTarget($attributes, 'master_database'); if (CH::isCluster()) { $slave_setting = null; if (CH::isSlaveActive()) { $slave_setting = self::createOnTarget($attributes, 'slave_database'); } CH::updateClusters($setting != null, $slave_setting != null); } return $setting; } private static function updateOnTarget($attributes, $id, $target) { $setting = null; DB::connection($target)->beginTransaction(); try { $setting = self::on($target)->find($id); $setting->fill($attributes)->save(); if (isset($attributes['vpn_settings'])) { $setting->vpnSettings()->sync($attributes['vpn_settings']); } else { $setting->vpnSettings()->detach(); } DB::connection($target)->Commit(); } catch (\Exception $e) { logger($e); DB::connection($target)->rollBack(); } return $setting; } public static function updateSetting($params, $id) { $ret = self::updateOnTarget($params, $id, 'master_database'); if (CH::isCluster()) { $s_ret = false; if (CH::isSlaveActive()) { $s_ret = self::updateOnTarget($params, $id, 'slave_database'); } CH::updateClusters($ret, $s_ret); } return $ret; } private static function destroyOnTarget($ids, $target) { $count = null; DB::connection($target)->beginTransaction(); try { $setting = self::on($target)->find($ids); $setting->vpnSettings()->detach(); $count = $setting->delete(); DB::connection($target)->Commit(); } catch (\Exception $e) { logger($e); DB::connection($target)->rollBack(); } return $count; } public static function destroy($ids) { $count = self::destroyOnTarget($ids, 'master_database'); if (CH::isCluster()) { $slave_count = 0; if (CH::isSlaveActive()) { $slave_count = self::destroyOnTarget($ids, 'slave_database'); } CH::updateClusters($count > 0, $slave_count > 0); } return $count; } public static function getSelectBoxArray() { $settings = parent::all()->pluck('name', 'id'); $settings->prepend('設定しない', 0); return $settings; } private function formatPauthParam($setting) { $data = []; $data['enable'] = $setting->enable_pauth; $data['user_id'] = $setting->pauth_user; $data['password'] = $setting->pauth_pass_cipher; return $data; } public function formatForApi($ret) { $vpn_settings = $this->vpnSettings; $vpn_settings = $vpn_settings->map(function ($item, $key) { return $item->only([ 'name', 'global_address', 'local_address', 'interface_name', 'dns_servers', 'allowed_hosts' ]); })->toArray(); $proxy_setting = $this->proxySetting; if ($proxy_setting) { $proxy_setting = $this->proxySetting->only([ 'name', 'proxy_type', 'proxy_host', 'proxy_port', 'proxy_exceptions', 'proxy_script_url' ]); $proxy_setting['proxy_type'] = $this->proxySetting->ProxyTypeApiString; } $chrome_setting = $this->chromeSetting; if ($chrome_setting) { $chrome_setting = $this->chromeSetting->makeHidden([ 'id', 'bookmark_toplevel', 'created_at', 'updated_at', 'enable_pauth', 'pauth_account', 'pauth_user', 'pauth_pass' ]); $chrome_setting->bookmarks = self::formatManagedBookmarksForApi($chrome_setting); $chrome_setting->proxy_authorization = $this->formatPauthParam($chrome_setting); } $edge_setting = $this->edgeSetting; if ($edge_setting) { $edge_setting = $this->edgeSetting->makeHidden([ 'id', 'bookmark_toplevel', 'created_at', 'updated_at', 'enable_pauth', 'pauth_account', 'pauth_user', 'pauth_pass' ]); $edge_setting->bookmarks = self::formatManagedBookmarksForApi($edge_setting); $edge_setting->proxy_authorization = $this->formatPauthParam($edge_setting); } $shareprofile = $this->shareprofile; if($shareprofile){ $shareprofile = $this->shareprofile->makeHidden([ 'id', 'organization_id', 'created_at', 'updated_at', 'scvtimemill' ]); } $ret->available_browser = explode(',', $this->available_browser); $ret->vpn_settings = $vpn_settings; $ret->proxy_settings = $proxy_setting; $ret->chrome_settings = $chrome_setting; $ret->edge_settings = $edge_setting; $ret->shareprofile = $shareprofile; return $ret; } public static function formatManagedBookmarksForApi($setting): array { $toplevelName = $setting->bookmark_toplevel; $managedBookmarks = $setting->managed_bookmarks() ->withPivot('order') ->orderBy('order') ->get(); $folders = []; foreach ($managedBookmarks as $managedBookmark) { $bookmarks = json_decode($managedBookmark->bookmarks); foreach ($bookmarks as $bookmark) { $folderName = $bookmark->Folder; if (!array_key_exists($folderName, $folders)) { $folders[$folderName] = []; } $folders[$folderName][] = [ 'url' => $bookmark->URL, 'name' => $bookmark->Title, ]; } } $data = []; if (strlen($toplevelName) > 0) { $data[] = [ 'toplevel_name' => $toplevelName, ]; } foreach ($folders as $folderName => $bookmarks) { if (empty($folderName)) { foreach ($bookmarks as $bookmark) { $data[] = $bookmark; } } else { $children = []; foreach ($bookmarks as $bookmark) { $children[] = $bookmark; } $data[] = [ 'name' => $folderName, 'children' => $children, ]; } } return $data; } } 