<?php
 namespace App\Console\Commands; use Illuminate\Console\Command; use App\EmergencyMode; use App\Libs\ClusterHelper as CH; class EmodeControl extends Command { protected $signature = 'scv:emode_ctrl
                            {--check}
                            {--enable}
                            {--disable}
                            {--clear}'; protected $description = 'Emergency mode control'; public function __construct() { parent::__construct(); } public function handle() { if(CH::isCluster() && !CH::isMaster() && !CH::isSlave()) { $this->error("このコマンドは現在のサーバロールでは実行できません。"); return; } else if(CH::isCluster() && !CH::isMaster() && CH::isMasterAlive()) { $this->error("このコマンドはマスタがダウンしている場合のみ使用できます。"); return ; } if($this->option('check')) { $this->mode_check(); } else if($this->option('enable')) { $this->mode_change(true); } else if($this->option('disable')) { $this->mode_change(false); } else if($this->option('clear')) { $this->mode_reset(); } else { $this->error("オプションが間違っています"); return; } } private function mode_check() { $emode_status = EmergencyMode::getLatestStatus(); if(empty($emode_status) || !$emode_status->status) { logger("Emergency mode disable"); $this->info("Emergency mode disable"); return; } $today = date("Y-m-d"); $past_date = (strtotime($today) - strtotime($emode_status->created_at->format("Y-m-d"))) / (60*60*24); if($past_date > 14) { $emode_status->status = false; $emode_status->save(); logger("Emergency mode auto disabled"); $slave_dbret = ''; if(CH::isCluster()) { if(CH::isMasterActive() && $dbret) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slave_emergency_mode_model = new EmergencyMode; $slave_emergency_mode_model->setConnection('slave_database'); $slave_emode = $slave_emergency_mode_model->find($emode_status->id); $slave_emode->status = false; $slave_dbret = $slave_emode->save(); logger("Slave emergency mode auto disabled"); } } CH::updateClusters($dbret, $slave_dbret); } } else { logger("Emergency mode enable"); $this->info("Emergency mode enable"); } return; } private function mode_change($flag) { $sem = sem_get(config('scv.csv_sem_key')); if(!$sem){ logger('Failed to get semaphore - sem_get()'); $this->error("排他制御に失敗しました"); return; } if(!sem_acquire($sem, true)){ $this->error("CSV処理中のため実行できません"); return; } if(CH::isCluster() && CH::isSlaveAlive() && !CH::isSlaveActive()) { $this->error('サーバ同期中のため災害時モードの切り替えができません、同期終了までしばらくお待ち下さい。'); return; } $emode_status = EmergencyMode::getLatestStatus(); if(empty($emode_status) && !$flag || !empty($emode_status) && !$emode_status->status && !$flag) { logger("Emergency mode already disabled"); $this->error('既に災害時モードが無効になっています。'); return; } if(!empty($emode_status) && $emode_status->status && $flag) { logger("Emergency mode already enabled"); $this->error('既に災害時モードが有効になっています。'); return; } if(empty($emode_status) && $flag || !$emode_status->status && $flag) { if(!EmergencyMode::isExecutableEmode()) { $this->error("有効なライセンスが存在していないため、災害時モードを利用できません。"); return; } $available_count = 4; $activated_data = EmergencyMode::getActivatedData(); $available_count -= $activated_data; if($available_count <= 0) { $this->error('災害時モードの年内使用回数上限に達しているため、災害時用モードを有効化できません。'); return; } logger("Enable emergency mode "); if($this->confirm("災害時モードを有効化します、よろしいでしょうか")) { $emode_status = new EmergencyMode; $emode_status->status = true; $emode_status->updated_at = "0000-00-00 00:00:00"; $dbret = $emode_status->save(); $slave_dbret = ''; if(CH::isCluster()) { if(CH::isMasterActive() && $dbret) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slave_emode = new EmergencyMode; $slave_emode->setConnection("slave_database"); $slave_emode->status = true; $slave_emode->updated_at = "0000-00-00 00:00:00"; $slave_dbret = $slave_emode->save(); logger("Slave emergency mode enabled"); } } CH::updateClusters($dbret, $slave_dbret); } logger("Emergency mode enabled"); $this->info('災害時モードが有効になりました。 有効化可能回数は残り'.--$available_count.'回です。'); } else { logger("Enable emergency mode canceled"); $this->info("キャンセルしました"); } return; } if($emode_status->status && !$flag) { logger("Disable emergency mode "); if($this->confirm("災害時モードを無効化します、よろしいでしょうか")) { $emode_status->status = false; $dbret = $emode_status->save(); $slave_dbret = ''; if(CH::isCluster()) { if(CH::isMasterActive() && $dbret) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slave_emergency_mode_model = new EmergencyMode; $slave_emergency_mode_model->setConnection('slave_database'); $slave_emode = $slave_emergency_mode_model->find($emode_status->id); $slave_emode->status = false; $slave_dbret = $slave_emode->save(); logger("Slave emergency mode disabled"); } } CH::updateClusters($dbret, $slave_dbret); } logger("Emergency mode disabled"); $this->info('災害時モードが無効になりました。'); }else { logger("Disable emergency mode canceled"); $this->info('キャンセルしました。'); } return; } } private function mode_reset() { if(env('APP_DEBUG')) { $this->info("このコマンドはデバッグ用です。"); if($this->confirm('emergency_modeテーブルのデータをすべて削除しますか？')) { $emode = new EmergencyMode; $dbret = $emode->where('id', '>', 0)->delete(); if($dbret > 0) { $dbret = 1; } $slave_dbret = ''; if(CH::isCluster()) { if(CH::isMasterActive() && $dbret) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slave_emode = new EmergencyMode; $slave_emode->setConnection("slave_database"); $slave_dbret = $slave_emode->where('id', '>', 0)->delete(); } if($slave_dbret > 0) { $slave_dbret = 1; } CH::updateClusters($dbret, $slave_dbret); } } logger("Emergency mode data all deleted"); $this->info('emergency_modeテーブルのデータをすべて削除しました'); return; } $this->info('キャンセルしました。'); return; } else { $this->error('このオプションはデバッグ用です。'); return; } } } 