<?php
 namespace App\Console\Commands; use Illuminate\Console\Command; use App\Models\LdapSetting; use App\Exceptions\LdapException; use App\Libs\ClusterHelper; use App\Libs\ADHelper as ADH; use App\Libs\LdapImportHelper; use Carbon\Carbon; class MigrateFromLdap extends Command { protected $signature = 'scv:migrate-from-ldap
                                {ldapconf}
                                {--f|force}'; protected $description = 'scvuser migrate from LDAP to SCVX'; public function __construct() { parent::__construct(); } public function handle() { $this->can_operate(); $confname = $this->argument('ldapconf'); $ldap = LdapSetting::findByName($confname); if (!$ldap) { $this->info("存在しないLDAP設定です。"); return 1; } $this->line('Host     : ' . $ldap->host); $this->line('Port     : ' . $ldap->port); $this->line('BaseDN   : ' . $ldap->dn); $this->line('Filter   : ' . $ldap->filter); $this->line('組織     : ' . $ldap->organization->name); $this->line('グループ : ' . $ldap->group->name); $this->line(''); $forceFlag = $this->option('force'); if (!$forceFlag) { $this->line('LDAPサーバのユーザと同期します。'); $res = $this->confirm('実行してよろしいですか。'); if (!$res) { $this->info('中止しました。'); return 0; } } $sem = sem_get(config('scv.csv_sem_key')); if (!$sem) { logger('Failed to get semaphore - sem_get()'); $this->error("排他制御に失敗しました"); return; } if (!sem_acquire($sem, true)) { $this->error("CSV処理中のため実行できません"); return; } try { list($adduser, $deluser) = LdapImportHelper::matchLdapScvuser($ldap); } catch (LdapException $e) { $message = $e->getMessage(); $this->error($message); return 1; } if (count($adduser) == 0 && count($deluser) == 0) { $this->info("更新はありません。"); return 0; } list($logFilePath, $logerr) = LdapImportHelper::getLogFilePath(); LdapImportHelper::synchronizeLdapScvusers($ldap, $adduser, $deluser, Carbon::now(), $logFilePath, $this); return 0; } private function can_operate() { if (ClusterHelper::isCluster() && ClusterHelper::isSlave() && ClusterHelper::isMasterActive()) { throw new \Exception('masterサーバがアクティブのため、slaveからの操作をキャンセルしました'); } if (ClusterHelper::isCluster() && !ClusterHelper::isMaster() && !ClusterHelper::isSlave()) { throw new \Exception('memberサーバからLDAP同期を行うことはできません。'); } if (!ADH::canLdapSettings()) { throw new \Exception('認証方式がscvxkerberosかscvxldapの場合のみLDAP同期を実行可能です。'); } } } 