<?php
 namespace App\Console\Commands; use Illuminate\Console\Command; use App\Scvgroup; use App\Libs\ConfHelper; use App\Libs\ClusterHelper; class MigrateScvFlowSettings extends Command { protected $signature = 'scv:migrate-scvflow-settings {--migrate} {--force} {--P|previous-version=}'; protected $description = 'Migrate scvflow settings from scvconf to scvgroups'; public function __construct() { parent::__construct(); } private function trimVersion($v) { $pattern = '/(\d+\.)(\d+\.)(\d+)/'; preg_match($pattern, $v, $result); return $result[0]; } public function handle() { $force = $this->option('force'); $migrate = $this->option('migrate'); $previousVersion = $this->option('previous-version'); if(!$migrate){ return; } if(!$force){ if(!$previousVersion){ return; } $previousVersion = $this->trimVersion($previousVersion); if(version_compare($previousVersion, '4.0.170', '>')){ $this->line('No scvflow migration required'); return; } if (ClusterHelper::isCluster() && ClusterHelper::getRole() == 'member') { $this->line('Please run on the Master or Slave server'); return; } } $currentScvFlowValue = ConfHelper::scvconf('SCV_FLOW') ?: 0; Scvgroup::where('name', '!=', 'DEFAULT') ->Where('name', '!=', 'ADMIN') ->Where('name', '!=', 'SCVTEMPLATE') ->where('flow_exclude', '!=', 1) ->update(['scv_flow' => $currentScvFlowValue]); Scvgroup::query()->update(['flow_exclude' => 0]); $this->line('scvflow migration is complete'); } } 