<?php
 namespace App\Console\Commands; use App\Organization; use App\Scvgroup; use App\Scvuser; use App\Libs\ClusterHelper as CH; use App\Libs\ConfHelper; use App\Jobs\ScvuserJob; use Illuminate\Console\Command; class MigrateScvgroups extends Command { protected $signature = 'scv:migrate_scvgroups {--migrate}'; protected $description = 'Create scvtemplate group and user'; public function __construct() { parent::__construct(); } public function handle() { $migrate = $this->option('migrate'); $role = CH::getRole(); if (CH::isCluster()) { if($role == "slave" || $role == "member"){ $this->error("Please execute on the master or slave server."); return; } } $organizations = Organization::all(); if($organizations->count() === 1) { $this->info("No migrate required."); return; } if ($migrate) { $this->info("scvtemplate migration start."); foreach ($organizations as $organization) { if(empty(Scvgroup::with_org($organization->name, 'SCVTEMPLATE'))) { $scvgroup = new Scvgroup; $data = [ 'name' => 'SCVTEMPLATE', 'organization_id' => $organization->id, 'hour' => '00:00-24:00', 'enable' => 1, 'applist' => 'firefox', 'runmode' => 'SINGLE', 'image' => 'DEFAULT', 'dayofweek' => 'SUN,MON,TUE,WED,THU,FRI,SAT', 'copypaste' => 1, 'firefoxsave' => 1, 'comment' => 'プロファイル作成用グループ', 'scvpriority' => 'NORMAL' ]; $dbret = $scvgroup->fill($data)->save(); if(CH::isCluster()) { $slave_dbret = false; if(CH::isSlaveActive()) { $slave_dbret = Scvgroup::on('slave_database')->create($data); } CH::updateClusters($dbret, $slave_dbret); } } if(empty(Scvuser::with_org($organization->name, 'SCVTEMPLATE'))) { $template_group = Scvgroup::with_org($organization->name, 'SCVTEMPLATE'); $scvuser = new Scvuser; $data = [ 'name' => 'scvtemplate', 'password' => 'scvtemplate', 'password_confirmation' => 'scvtemplate', 'group' => $template_group->name, 'organization' => $organization->name ]; dispatch_now(new ScvuserJob("store", $data)); } } $this->info("Scvgroups migration finished."); return; } $this->error("Invalied options."); return; } } 