<?php
 namespace App\Console\Commands; use App\Scvgroup; use App\Libs\ClusterHelper as CH; use Illuminate\Console\Command; class MigrateShareprofiles extends Command { protected $signature = 'scv:migrate_shareprof {--migrate} {--previous-version=}'; protected $description = 'Migrate shareprofiles'; public function __construct() { parent::__construct(); } private function trimVersion($v) { $pattern = '/(\d+\.)(\d+\.)(\d+)/'; preg_match($pattern, $v, $result); return $result[0]; } private $admin_organization = 1; public function handle() { $migrate = $this->option('migrate'); $version = $this->option('previous-version'); if (!$migrate) { $this->error("Argument error."); return; } $role = CH::getRole(); if (Ch::isCluster() && $role != "master") { $this->error("Please execute on the master server."); return; } if (!$version) { $this->error("Missing version information"); return ; } $version = $this->trimVersion($version); if(version_compare($version, '4.0.170', '>')){ $this->line('No shareprofiles migration required'); return; } if(!$migrate){ $this->error("Invalied options."); return; } $scvgroups = Scvgroup::getScvgroupRegisteredShareprofile(); if ($scvgroups->count() > 0) { $this->info("scvgroup shareprofile setting migration start"); foreach ($scvgroups as $scvgroup) { if($scvgroup->organization_id !== $this->admin_organization) { $scvgroup->shareprofile_id = 0; $dbret = $scvgroup->save(); if (CH::isCluster()) { $slave_ret = false; if (CH::isSlaveActive()) { $slave_scvgroup = Scvgroup::on('slave_database')->find($scvgroup->id); $slave_scvgroup->shareprofile_id = $scvgroup->shareprofile_id; $slave_ret = $slave_scvgroup->save(); } CH::updateClusters($dbret, $slave_ret); } } } $this->info("scvgroup shareprofile setting migration finished."); return; } $this->info("No migration required."); return; } } 