<?php
 namespace App\Console\Commands; use Illuminate\Console\Command; use App\Mail\PpuReport; use App\PpuAddress; class PpuReportMail extends Command { protected $signature = 'scv:ppu_report {file1=null} {file2=null} {--test} {--dev}'; protected $description = 'Send ppu report mail'; protected $js_addresses = ['scvx-info@jscom.co.jp', 'gyoumu@jscom.co.jp']; public function __construct() { parent::__construct(); } private function getValue($file_path, $key, $delimiter) { $file = fopen($file_path, 'r'); while($line = fgets($file)){ if(strpos($line, $key) === 0){ $exp = explode($delimiter, $line); if(!array_key_exists(1, $exp)) return null; return trim(str_replace('"', '', $exp[1])); } } return null; } private function getMailSettings($data) { $env_path = "/var/www/html/scv/.env"; $data['from_address'] = $this->getValue($env_path, 'PPU_MAIL_FROM_ADDRESS', '='); $data['from_name'] = $this->getValue($env_path, 'PPU_MAIL_FROM_NAME', '='); return $data; } private function getReportContents($data) { $data['title'] = ''; $data['start'] = ''; $data['end'] = ''; $file = fopen($data['file2'], 'r'); while($line = fgets($file)){ $exp = explode('：', $line); if(!array_key_exists(1, $exp)) continue; if(strpos($line, 'タイトル') !== false){ $data['title'] = trim(str_replace('"', '', $exp[1])); } if(strpos($line, 'ライセンスユーザ名') !== false){ $data['organization'] = trim(str_replace('"', '', $exp[1])); } if(strpos($line, '前月集計範囲(開始)') !== false){ $data['start_date'] = trim(str_replace('"', '', $exp[1])); } if(strpos($line, '前月集計範囲(終了)') !== false){ $data['end_date'] = trim(str_replace('"', '', $exp[1])); } if(strpos($line, '集計日') !== false){ $data['aggregate_date'] = trim(str_replace('"', '', $exp[1])); } } return $data; } public function handle() { $data = [ 'test' => $this->option('test'), 'dev' => $this->option('dev'), 'file1' => $this->argument('file1'), 'file2' => $this->argument('file2'), 'js_addresses' => [] ]; $data = $this->getMailSettings($data); if($data['from_address'] == null){ $this->error('PPU_MAIL_FROM_ADDRESS is not set.'); return 1; } if(!$data['test']){ if($data['file1'] == 'null' || $data['file2'] == 'null'){ $this->error('Not enough arguments (missing: "file1, file2").'); return 1; } if(!file_exists($data['file1'])){ $this->error($data['file1']." does not exist."); return 1; } if(!file_exists($data['file2'])){ $this->error($data['file2']." does not exist."); return 1; } $data = $this->getReportContents($data); $setting = PpuAddress::where('organization', $data['organization'])->first(); $data['to_addresses'] = array_map('trim', explode(',', $setting->addresses)); } if(!$data['dev']){ $data['js_addresses'] = $this->js_addresses; } if($data['test']){ $org = $this->ask('Please enter company name'); $setting = PpuAddress::where('organization', $org)->first(); if(!$setting){ $this->error("The specified company does not exist"); return 1; } $data['to_addresses'] = array_map('trim', explode(',', $setting->addresses)); } try { \Mail::send(new PpuReport($data)); }catch(\Exception $e){ logger($e->getMessage()); $this->error($e->getMessage()); return 1; } } }