<?php
 namespace App\Console\Commands; use Illuminate\Console\Command; use App\Firefoxprofile; use App\ScvxChromeSetting; use App\Libs\ClusterHelper; class RecreateProf extends Command { protected $signature = 'scv:recreate_profiles {--recreate}'; protected $description = 'firefox and scvxchrome settings file recreate'; public function __construct() { parent::__construct(); } public function handle() { $recreate = $this->option('recreate'); $role = ClusterHelper::getRole(); if(ClusterHelper::isCluster()) { if($role == "slave" || $role == "member"){ $this->error("Please execute on the master or slave server."); return; } } if($recreate){ $profiles = Firefoxprofile::getFirefoxprofileWithOrg(); foreach ($profiles as $prof) { Firefoxprofile::createProfile($prof, $prof->org_name); $before_cert_path = "/var/www/html/scv/scvtemplates/".$prof->name."/cert"; $certs_csv_path = "/var/www/html/scv/scvtemplates/".$prof->name."/certs.csv"; $after_cert_path = "/var/www/html/scv/scvtemplates/".$prof->org_name."/".$prof->name."/cert"; $after_certs_csv_path = "/var/www/html/scv/scvtemplates/".$prof->org_name."/".$prof->name."/certs.csv"; if(file_exists($before_cert_path)) { exec("mv '$before_cert_path' '$after_cert_path'"); chown($after_cert_path, "www-data"); chgrp($after_cert_path, "docker"); } if(file_exists($certs_csv_path)) { exec("mv '$certs_csv_path' '$after_certs_csv_path'"); chown($after_certs_csv_path, "www-data"); chgrp($after_certs_csv_path, "docker"); } } $profiles = ScvxChromeSetting::getChromeSettingsWithOrg(); foreach ($profiles as $prof) { ScvxChromeSetting::createProfile($prof, $prof->organization_name); $before_cert_path = "/var/www/html/scv/scvtemplates/".$prof->name."/cert"; $certs_csv_path = "/var/www/html/scv/scvtemplates/".$prof->name."/certs.csv"; $after_cert_path = "/var/www/html/scv/scvtemplates/".$prof->org_name."/".$prof->name."/cert"; $after_certs_csv_path = "/var/www/html/scv/scvtemplates/".$prof->org_name."/".$prof->name."/certs.csv"; if(file_exists($before_cert_path)) { exec("mv '$before_cert_path' '$after_cert_path'"); chown($after_cert_path, "www-data"); chgrp($after_cert_path, "docker"); } if(file_exists($certs_csv_path)) { exec("mv '$certs_csv_path' '$after_certs_csv_path'"); chown($after_certs_csv_path, "www-data"); chgrp($after_certs_csv_path, "docker"); } } } $this->info("All Profiles was recreated."); } } 