<?php
 namespace App\Console\Commands; use Illuminate\Console\Command; use App\User; use App\Libs\ClusterHelper as CH; class ResetAdminPassword extends Command { protected $signature = 'scv:reset_admin_pwd'; protected $description = 'Reset Admin Password'; public function __construct() { parent::__construct(); } public function handle() { if (CH::isCluster() && !CH::isMaster() ) { $this->error('パスワードリセットコマンドはMasterサーバでのみ実行できます。'); return; } $sem = sem_get(config('scv.csv_sem_key')); if(!$sem){ logger('Failed to get semaphore - sem_get()'); $this->error("排他制御に失敗しました"); return; } if(!sem_acquire($sem, true)){ $this->error("CSV処理中のため実行できません"); return; } if ($this->confirm('※注意 このコマンドは指定された管理者ユーザのパスワードをリセットします。 よろしいですか？')) { $username = $this->ask('パスワードをリセットしたい管理者ユーザ名を入力してください'); $user = User::getUserByName($username); if ($user == null) { $this->error('存在しないユーザです。'); return; } $password = substr(str_shuffle(str_repeat('0123456789abcdefghijklmnopqrstuvwxyz', 9)), 0, 9); $user->password = bcrypt($password); $user->pwd_generations = $user->password; $reset_date = date('Y-m-d H:i:s'); $user->pwd_reset_at = $reset_date; $user->reset = true; $user->tmp_pwd = $user->password; $user->deny_cnt = 0; $dbret = $user->save(); $slave_dbret = ''; if(CH::isCluster()) { if(CH::isMasterActive() && $dbret) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slavemodel = new User; $slavemodel->setConnection('slave_database'); $slaveuser = $slavemodel->where('username', $username)->first(); $slaveuser->password = $user->password; $slaveuser->pwd_generations = $user->pwd_generations; $slaveuser->pwd_reset_at = $reset_date; $slaveuser->reset = true; $slaveuser->tmp_pwd = $slaveuser->password; $slaveuser->deny_cnt = 0; $slave_dbret = $slaveuser->save(); } } CH::updateClusters($dbret, $slave_dbret); } $this->info($username.'のパスワードがリセットされました、新しいパスワードは '.$password.' です。'); $this->info("このパスワードはリセット後の初回ログインでのみ利用可能です、ログイン後は必ずパスワードを変更してください。"); } else { $this->info('キャンセルしました。'); } } } 