<?php
 namespace App\Console\Commands; use Illuminate\Console\Command; use App\Scvflow; use App\ScvflowLog; use App\Scvgroup; use App\Jobs\ScvuserJob; use App\Libs\ClusterHelper; use App\Libs\ConfHelper; class ScvFlowCommand extends Command { protected $signature = 'scvflow {--delete-expired-requests : 期限切れの原本ファイルを削除} {--create-test-scvusers= : テスト用のユーザを作成。値に通知用のメールアドレスを指定} {--set-last-request-expired}'; protected $description = 'SCV Flowの様々な処理を行います'; public function __construct() { parent::__construct(); } private function is_debug() { $env = dirname(__FILE__) . '/../../../.env'; $content = file_get_contents($env); return preg_match('/^\s*APP_DEBUG\s*=\s*(?:1|true)\s*$/m', $content); } public function handle() { if ($this->option('delete-expired-requests')) $this->delete_expired_requests(); else if ($this->option('create-test-scvusers')) $this->create_test_scvusers(); else if ($this->option('set-last-request-expired')) $this->set_last_request_expired(); else $this->error('有効なオプションを指定してください'); } private function delete_expired_requests() { $keepdays = ConfHelper::scvconf('SCV_FLOW_KEEPDAYS'); if ($keepdays === null) { $this->error('SCV_FLOW_KEEPDAYSが存在しません'); return; } if ($keepdays <= 0) { $this->info('SCV_FLOW_KEEPDAYSが無制限設定のため、期限切れ処理は行われませんでした'); return; } $cnt = Scvflow::delete_expired_requests(); if ($cnt > 0) $this->info("期限切れによる{$cnt}件の申請を削除しました"); else $this->info('期限切れの申請は見つかりませんでした'); } private function set_last_request_expired() { if (!$this->is_debug()) { $this->error('このコマンドはデバッグ時のみ有効です'); return; } $request = Scvflow::orderBy('requested_at', 'desc')->limit(1)->first(); if ($request === null) { $this->info("申請が存在しません"); return; } Scvflow::where('id', $request->id)->update(['requested_at' => '2000-01-01 00:00:00']); ScvflowLog::where('id', $request->id)->update(['requested_at' => '2000-01-01 00:00:00']); $this->info('最新の申請："' . $request->filename . '" の申請時間を2000年にしました'); } private function create_test_group() { exec('docker images --format "{{.Repository}}:{{.Tag}}" | grep ^scv', $scvimages, $ret); if (count($scvimages) === 0) { $this->info('FLOWグループを作成しようとしましたが、イメージが見つかりませんでした'); return; } $image = $scvimages[0]; $param = [ 'name' => 'FLOW', 'organization_id' => '1', 'enable' => '1', 'sort' => 'FLOW', 'comment' => 'テスト用', 'dayofweek' => 'SUN,MON,TUE,WED,THU,FRI,SAT', 'hour' => '00:00-24:00', 'applist' => 'firefox', 'runmode' => 'SINGLE', 'image' => $image, 'scvroleid' => '0', 'ena_timeout' => '0', 'ena_dayofweek' => '0', 'ena_hour' => '0', 'firefoxsave' => '0', 'copypaste' => '1', 'speaker' => '0', 'microphone' => '0', 'print' => '0', 'sanitize' => '0', 'transfer' => '0', 'upload' => '1', 'download' => '0', 'scvcdebug' => '0', 'maxlimit' => '-1', 'scvpriority' => 'NORMAL', 'scvencode' => '', 'scvquality' => '', 'scvspeed' => '', 'idle_timeout' => '0', 'idle_msg_wait' => '0', 'force_timeout' => '0', 'force_msg_wait' => '0', 'firefoxprofile_id' => '0', 'shareprofile_id' => '0', 'custom' => '', 'scvtimemill' => null ]; Scvgroup::create($param); } private function create_test_scvusers() { if (!$this->is_debug()) return; $email = $this->option('create-test-scvusers'); if (!preg_match('/^[^@]+@([^@]+\.)+[^@]+$/', $email)) { $this->error('オプション値にはメールアドレスを指定してください'); return; } $scvgroup = Scvgroup::with_org('ADMIN', 'FLOW'); if ($scvgroup === null) { $this->create_test_group(); $scvgroup = Scvgroup::with_org('ADMIN', 'FLOW'); if ($scvgroup) { $this->info('FLOWグループを作成しました'); } else { $this->error('FLOWグループを作成できませんでした'); return; } } $param = [ 'groupid' => $scvgroup->id, 'password' => 'scvadmin', 'password_confirmation' => 'scvadmin', 'email' => $email ]; $no = 1; $param['name'] = 'sinsei'; $param['jpname'] = '申請太郎'; $param['department'] = 'プロダクト開発部'; $param['post'] = ''; $param['employee_id'] = 'abc0000' . $no++; $param['comment'] = 'テスト用'; $param['privilege'] = 0; dispatch_now(new ScvuserJob('store', $param)); $param['name'] = 'syonin'; $param['jpname'] = '承認太郎'; $param['department'] = 'プロダクト開発部'; $param['post'] = ''; $param['employee_id'] = 'abc0000' . $no++; $param['comment'] = 'テスト用'; $param['privilege'] = 1; dispatch_now(new ScvuserJob('store', $param)); $param['name'] = 'yamada'; $param['jpname'] = '山田太郎'; $param['department'] = 'プロダクト開発部'; $param['post'] = '部長'; $param['employee_id'] = 'abc0000' . $no++; $param['comment'] = 'テスト用'; $param['privilege'] = 1; dispatch_now(new ScvuserJob('store', $param)); $param['name'] = 'tanaka'; $param['jpname'] = '田中花子'; $param['department'] = '技術本部'; $param['post'] = '本部長'; $param['employee_id'] = 'abc0000' . $no++; $param['comment'] = 'テスト用'; $param['privilege'] = 1; dispatch_now(new ScvuserJob('store', $param)); $param['name'] = 'user1'; $param['jpname'] = 'ユーザ1'; $param['department'] = '営業部'; $param['post'] = '主任'; $param['employee_id'] = 'abc0000' . $no++; $param['comment'] = 'テスト用'; $param['privilege'] = 1; dispatch_now(new ScvuserJob('store', $param)); $param['name'] = 'user2'; $param['jpname'] = 'ユーザ2'; $param['department'] = '営業部'; $param['post'] = '係長'; $param['employee_id'] = 'abc0000' . $no++; $param['comment'] = 'テスト用'; $param['privilege'] = 1; dispatch_now(new ScvuserJob('store', $param)); $param['name'] = 'user3'; $param['jpname'] = 'ユーザ3'; $param['department'] = '営業部'; $param['post'] = '課長'; $param['employee_id'] = 'abc0000' . $no++; $param['comment'] = 'テスト用'; $param['privilege'] = 1; dispatch_now(new ScvuserJob('store', $param)); $param['name'] = 'user4'; $param['jpname'] = 'ユーザ4'; $param['department'] = '営業部'; $param['post'] = '部長'; $param['employee_id'] = 'abc0000' . $no++; $param['comment'] = 'テスト用'; $param['privilege'] = 1; dispatch_now(new ScvuserJob('store', $param)); $param['name'] = 'test'; $param['jpname'] = 'テスト'; $param['department'] = 'テスト部'; $param['post'] = '社長'; $param['employee_id'] = 'abc0000' . $no++; $param['comment'] = 'テスト用'; $param['privilege'] = 1; dispatch_now(new ScvuserJob('store', $param)); $this->info('テスト用のユーザを作成しました。'); } } 