<?php
 namespace App\Console\Commands; use Illuminate\Console\Command; use App\User; use App\Scvgroup; use App\Organization; use App\Libs\ClusterHelper as CH; use App\Libs\ConfHelper; use App\Libs\ADHelper as ADH; use App\Libs\UserHelper as UH; use App\Jobs\ScvgroupJob; use Illuminate\Validation\ValidationException; use App\Http\Controllers\ScvgroupsController; class ScvgroupCmd extends Command { protected $signature = 'scv:scvgroup
                            {--export-csv}
                            {--import-csv}'; protected $description = 'create and delete groups'; public function __construct() { parent::__construct(); } public function handle() { try { $cmds = ['export-csv', 'import-csv']; foreach ($cmds as $cmd) { if ($value = $this->option($cmd)) { $method = str_replace('-', '_', $cmd); $this->$method($value); } } } catch (ValidationException $e) { $name = $e->validator->getData()['name']; $msgs = $e->validator->getMessageBag()->all(); foreach($msgs as $msg) { $this->error($name . ' : ' . $msg); } return 1; } catch (\Exception $e) { $msg = $e->getMessage(); $this->error($msg); return 1; } return 0; } private function can_operate() { if (CH::isSlave() && CH::isMasterActive()) throw new \Exception('masterサーバがアクティブのため、slaveからの操作をキャンセルしました。'); if (CH::isCluster() && !CH::isMaster() && !CH::isSlave()) throw new \Exception('memberサーバからグループの変更を行うことはできません。'); if (ConfHelper::is_illegal()) throw new \Exception('認証方式の設定が誤っています。'); } private function export_csv() { $csvcmd = new ScvgroupCsvCmdImpl($this); $csvcmd->export(); } private function import_csv() { $this->can_operate(); $csvcmd = new ScvgroupCsvCmdImpl($this); $csvcmd->import(); } } class ScvgroupCsvCmdImpl { private $base_dir; private $target_file; private $result_dir; private $result_prefix; private $histsize; private $cmd; public function __construct($cmd) { $this->cmd = $cmd; $this->base_dir = $this->load_csvdir(); $this->histsize = $this->load_histsize(); $this->target_file = $this->base_dir . '/scvgroups.csv'; $this->result_dir = $this->base_dir . '/results'; $this->result_prefix = 'scvgroups_output_'; } private function load_csvdir() { $dir = ConfHelper::scvconf('SCV_USR_CSVDIR'); if ($dir === null) throw new \Exception('SCV_USR_CSVDIRが設定されていません。'); else if (!file_exists($dir) || !is_dir($dir)) throw new \Exception('SCV_USR_CSVDIRの指定先が存在しません。'); return $dir; } private function load_histsize() { $histsize = ConfHelper::scvconf('SCV_USR_HISTSIZE'); if ($histsize === null) throw new \Exception('SCV_USR_HISTSIZEが設定されていません。'); return $histsize; } private function init_result_dir() { if (!file_exists($this->result_dir)) { if (!mkdir($this->result_dir)) throw new \Exception('結果ファイルの出力先ディレクトリの作成に失敗しました。'); chown($this->result_dir, 'www-data'); } } public function export() { $admin_user = $this->get_admin_user(); $batch = new ScvgroupsController(); $output_csv = $batch->export_csv_text($admin_user); file_put_contents($this->target_file, $output_csv); $this->cmd->info('グループのエクスポートが完了しました。'); $this->cmd->info('出力先：' . $this->target_file); } public function import() { $sem = sem_get(config('scv.csv_sem_key')); if(!$sem){ logger('Failed to get semaphore - sem_get()'); throw new \Exception("排他制御に失敗しました"); } if(!sem_acquire($sem, true)){ throw new \Exception("CSV処理中のため実行できません"); } $this->init_result_dir(); if (!file_exists($this->target_file)) throw new \Exception("入力ファイル \"{$this->target_file}\" が存在しません。"); $admin_user = $this->get_admin_user(); $input_csv = file_get_contents($this->target_file); $batch = new ScvgroupsController(); $success_rows = []; $fail_rows = []; $through_row = []; $result_csv = $batch->import_csv_text($admin_user, $input_csv, $success_rows, $fail_rows, $through_row); $result_path = $this->get_result_path(); file_put_contents($result_path, $result_csv); if ($this->histsize > 0) $this->generation_change(); $this->cmd->info('グループのインポートが完了しました。'); $msg = sprintf( "成功した行：%d 件\n失敗した行：%d 件\n無視された行：%d 件", count($success_rows), count($fail_rows), count($through_row) ); $this->cmd->info($msg); $this->cmd->info('結果出力先：' . $result_path); } private function generation_change() { $files = glob("{$this->result_dir}/{$this->result_prefix}*"); $exceeded = count($files) - $this->histsize; for ($i = 0; $i < $exceeded; ++$i) unlink($files[$i]); } private function get_result_path() { $dir = $this->result_dir; $name = $this->result_prefix . date('YmdHis') . '.csv'; return $dir . '/' . $name; } private function get_admin_user() { return User::where('username', 'ADMIN')->first(); } } 