<?php
 namespace App\Console\Commands; use Illuminate\Console\Command; use App\User; use App\Scvuser; use App\Scvgroup; use App\Organization; use App\Libs\ClusterHelper as CH; use App\Libs\ConfHelper; use App\Libs\ADHelper as ADH; use App\Libs\UserHelper as UH; use App\Jobs\ScvuserJob; use Illuminate\Validation\ValidationException; use App\Http\Controllers\BatchEditController; class ScvuserCmd extends Command { protected $signature = 'scv:scvuser
                            {--w|without-operation}
                            {--y|yes}
                            {--a|add}
                            {--d|del}
                            {--organization=}
                            {--group=}
                            {--groupid=}    // LDAPコマンドとの互換用
                            {--id=}    //
                            {--name=}
                            {--password=}
                            {--email=}
                            {--employee_id=}
                            {--jpname=}
                            {--department=}
                            {--post=}
                            {--custom_data1=}
                            {--custom_data2=}
                            {--custom_data3=}
                            {--privilege=}
                            {--flow_group=}
                            {--comment=}
                            {--export-csv}
                            {--import-csv}
                            {--import-csv-diff}
                            {--set-pwd-reset-at=}'; protected $description = 'create and delete users'; public function __construct() { parent::__construct(); } public function handle() { try { $cmds = ['add', 'del', 'export-csv', 'import-csv', 'import-csv-diff', 'set-pwd-reset-at']; foreach ($cmds as $cmd) { if ($value = $this->option($cmd)) { $method = str_replace('-', '_', $cmd); $this->$method($value); } } } catch (ValidationException $e) { $name = $e->validator->getData()['name']; $msgs = $e->validator->getMessageBag()->all(); foreach($msgs as $msg) { $this->error($name . ' : ' . $msg); } return 1; } catch (ScvuserCmdException $e) { $msg = $e->getMessage(); $this->error($msg); return 1; } catch (\Exception $e) { $msg = $e->getMessage(); $this->error($msg); return 1; } return 0; } private function can_operate() { if (CH::isSlave() && CH::isMasterActive()) throw new ScvuserCmdException('masterサーバがアクティブのため、slaveからの操作をキャンセルしました'); if (CH::isCluster() && !CH::isMaster() && !CH::isSlave()) throw new ScvuserCmdException('memberサーバからユーザの変更を行うことはできません'); if (ConfHelper::is_illegal()) throw new \Exception('認証方式の設定が誤っています'); } private function add() { $this->can_operate(); $params = $this->option(); $params['password_confirmation'] = $params['password']; if (isset($params['groupid'])) { $group_id = $params['groupid']; $group_name = Scvgroup::find($group_id)->name; $params['group'] = $group_name; $params['organization'] = Organization::get_name_by_groupid($group_id); } dispatch_now(new ScvuserJob('store', $params)); $this->info("{$params['name']}を登録しました。"); } private function del() { $this->can_operate(); $params = $this->option(); if (isset($params['id'])) { $user_id = $params['id']; $group_id = Scvuser::find($user_id)->groupid; $params['name'] = Scvuser::find($user_id)->name; $params['group'] = Scvgroup::find($group_id)->name; $params['organization'] = Organization::get_name_by_groupid($group_id); } dispatch_now(new ScvuserJob('destroy', $params)); $this->info("{$params['name']}を削除しました。"); } private function export_csv() { $without_operation = $this->without_operation_option(); $csvcmd = new ScvuserCsvCmdImpl($this); $csvcmd->export($without_operation); } private function import_csv() { $this->can_operate(); $csvcmd = new ScvuserCsvCmdImpl($this); $csvcmd->import(); } private function import_csv_diff() { $this->can_operate(); $yes = $this->yes_option(); $without_operation = $this->without_operation_option(); $csvcmd = new ScvuserCsvCmdImpl($this); $csvcmd->import_diff($yes, $without_operation); } private function set_pwd_reset_at($value) { if (!env('APP_DEBUG')) { $this->error('このコマンドはデバッグ時のみ有効です'); return; } $params = explode(',', $value); if (count($params) !== 2) { $this->error('"--set-pwd-reset-at=\'組織名/ユーザ,0000-00-00 00:00:00\'" の形式で入力してください'); return; } $logintxt = $params[0]; $reset_at = $params[1]; $scvuser = Scvuser::by_logintxt($logintxt); if ($scvuser === null) { $this->error('ユーザ "' . $logintxt . '" は存在しません'); return; } $reset_at = date('Y-m-d H:i:s', strtotime($reset_at)); $scvuser->pwd_reset_at = $reset_at; $scvuser->save(); $this->info('ユーザ "' . $logintxt . '" が最後にパスワード変更を行った日時を "' . $reset_at . '" に設定しました'); } private function yes_option() { $options = $this->option(); return isset($options['yes']) && $options['yes']; } private function without_operation_option() { $options = $this->option(); return isset($options['without-operation']) && $options['without-operation']; } } class ScvuserCsvCmdImpl { private $base_dir; private $target_file; private $result_dir; private $result_prefix; private $histsize; private $cmd; public function __construct($cmd) { $this->cmd = $cmd; $this->base_dir = $this->load_csvdir(); $this->histsize = $this->load_histsize(); $this->target_file = $this->base_dir . '/scvusers.csv'; $this->result_dir = $this->base_dir . '/results'; $this->result_prefix = 'scvusers_output_'; $this->result_prefix_diff = 'scvusers_output_diff_'; } private function load_csvdir() { $dir = ConfHelper::scvconf('SCV_USR_CSVDIR'); if ($dir === null) throw new ScvuserCmdException('SCV_USR_CSVDIRが設定されていません。'); else if (!file_exists($dir) || !is_dir($dir)) throw new ScvuserCmdException('SCV_USR_CSVDIRの指定先が存在しません。'); return $dir; } private function load_histsize() { $histsize = ConfHelper::scvconf('SCV_USR_HISTSIZE'); if ($histsize === null) throw new ScvuserCmdException('SCV_USR_HISTSIZEが設定されていません。'); return $histsize; } private function init_result_dir() { if (!file_exists($this->result_dir)) { if (!mkdir($this->result_dir)) throw new ScvuserCmdException('結果ファイルの出力先ディレクトリの作成に失敗しました。'); chown($this->result_dir, 'www-data'); } } public function export($without_operation) { $admin_user = $this->get_admin_user(); $batch = new BatchEditController(); $output_csv = $batch->export_csv($admin_user); if ($without_operation) $output_csv = preg_replace('/^,/m', '', $output_csv, -1); file_put_contents($this->target_file, $output_csv); $this->cmd->info('ユーザのエクスポートが完了しました。'); $this->cmd->info('出力先：' . $this->target_file); } public function import() { $rawcsv = $this->common_init(); $admin_user = $this->get_admin_user(); $batch = new BatchEditController(); $result_csv = $batch->import_csv($admin_user, $rawcsv, $cntobj); $this->common_term($result_csv, $cntobj, false); } public function import_diff($yes, $without_operation) { $rawcsv = $this->common_init(); $admin_user = $this->get_admin_user(); $batch = new BatchEditController(); if ($without_operation) { $rawcsv = preg_replace('/^(.)/m', ',$1', $rawcsv, -1); $rawcsv = preg_replace('/^,(?=#)|^,\\s*$/m', '', $rawcsv, -1); } if (!$yes) { $preview = $batch->import_csv_diff_preview($admin_user, $rawcsv); $msg = "追加する行：{$preview->store} 件\r\n"; $msg .= "変更する行：{$preview->update} 件\r\n"; $msg .= "削除する行：{$preview->destroy} 件"; $this->cmd->info($msg); if (!$this->cmd->confirm('この内容で操作を実行してもよろしいですか？')) { $this->cmd->info('操作を取り消しました。'); return; } } $result_csv = $batch->import_csv_diff($admin_user, $rawcsv, $cntobj); if ($without_operation) { $result_csv = preg_replace('/^,/m', '', $result_csv, -1); } $this->common_term($result_csv, $cntobj, true); } private function common_init() { $this->init_result_dir(); if (!file_exists($this->target_file)) throw new ScvuserCmdException("入力ファイル \"{$this->target_file}\" が存在しません。"); return file_get_contents($this->target_file); } private function common_term($result_csv, $cntobj, $diff_mode) { $result_path = $this->get_result_path($diff_mode); file_put_contents($result_path, $result_csv); if ($this->histsize > 0) $this->generation_change(); $this->cmd->info('ユーザのインポートが完了しました。'); $msg = sprintf("成功した行：%d 件\n失敗した行：%d 件\n無視した行：%d 件", $cntobj->succeeded, $cntobj->failed, $cntobj->ignored); $this->cmd->info($msg); $this->cmd->info('結果出力先：' . $result_path); } private function generation_change() { $std_prefix = $this->result_dir . '/' . $this->get_result_prefix(false); $diff_prefix = $this->result_dir . '/' . $this->get_result_prefix(true); $std_csvs = []; $diff_csvs = []; $files = glob("{$this->result_dir}/*"); foreach ($files as $file) { if (strpos($file, $diff_prefix) === 0) $diff_csvs[] = $file; elseif (strpos($file, $std_prefix) === 0) $std_csvs[] = $file; } sort($std_csvs); $exceeded = count($std_csvs) - $this->histsize; for ($i = 0; $i < $exceeded; ++$i) unlink($std_csvs[$i]); sort($diff_csvs); $exceeded = count($diff_csvs) - $this->histsize; for ($i = 0; $i < $exceeded; ++$i) unlink($diff_csvs[$i]); } private function get_result_prefix($diff_mode) { return $diff_mode ? $this->result_prefix_diff : $this->result_prefix; } private function get_result_path($diff_mode) { $dir = $this->result_dir; $result_prefix = $this->get_result_prefix($diff_mode); $name = $result_prefix . date('YmdHis') . '.csv'; return $dir . '/' . $name; } private function get_admin_user() { return User::where('username', 'ADMIN')->first(); } } class ScvuserCmdException extends \Exception { public function __construct($message, $code = 0, Exception $previous = null) { parent::__construct($message, $code, $previous); } } 