<?php
 namespace App\Console\Commands; use Illuminate\Console\Command; use App\ThreatNotificationSetting as TNS; use App\Mail\ThreatNotificationMailable; use App\Libs\ClusterHelper as CH; class ThreatNotificationCommand extends Command { protected $signature = 'scv:threat_notice
                            {--send-mail}
                            {--user=}
                            {--file-name=}
                            {--product=}
                            {--option-type=}
                            {--virus-name=}
                            {--engine-version=}
                            {--vdl-version=}
                            {--desktop-name=}
                            {--setup : Set up the mail settings}
                            {--show-settings : Display email settings}'; protected $description = 'Send threat notification mail'; public function __construct() { parent::__construct(); } public function handle() { if($this->option('setup')){ $this->setup(); return; } $data = TNS::all()->first(); if(!$data){ $this->error('please set the email first'); return 1; } if($this->option('show-settings')){ $this->show($data->toArray()); return; } if($this->option('send-mail')){ $data->user = $this->option('user'); $data->file_name = $this->option('file-name'); $data->product = $this->option('product'); $data->optionType = $this->option('option-type'); $data->virusName = $this->option('virus-name'); $data->engineVersion = $this->option('engine-version'); $data->vdlVersion = $this->option('vdl-version'); $data->desktopName = $this->option('desktop-name'); try { \Mail::send(new ThreatNotificationMailable($data->toArray())); }catch(\Exception $e){ logger($e->getMessage()); $this->error($e->getMessage()); return 1; } } } private function setup() { if (CH::isCluster() && !CH::isMaster()) { $this->error('Please settings on Master Server.'); return; } $params['dest_addresses'] = $this->ask('destination addresses'); $params['cc'] = $this->ask('cc', false) ?: ""; $params['from_address'] = $this->ask('from address'); $params['from_name'] = $this->ask('from name'); $params['subject'] = $this->ask('mail subject'); $this->line('destination addresses : ' . $params['dest_addresses']); $this->line('cc                    : ' . $params['cc']); $this->line('from addresss         : ' . $params['from_address']); $this->line('from name             : ' . $params['from_name']); $this->line('mail subject          : ' . $params['subject']); if($this->confirm('Are you sure you want to use this setting?')){ }else{ $this->error("The settings was canceled"); return; } $TNS = TNS::createOrUpdate($params); } private function show($params) { $this->line('destination addresses : ' . $params['dest_addresses']); $this->line('cc                    : ' . $params['cc']); $this->line('from addresss         : ' . $params['from_address']); $this->line('from name             : ' . $params['from_name']); $this->line('mail subject          : ' . $params['subject']); } } 