<?php
 namespace App\Exceptions; use Exception; use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler; use Illuminate\Http\RedirectResponse; use Illuminate\Auth\AuthenticationException; use Illuminate\Contracts\Container\Container; use Illuminate\Contracts\Support\Responsable; use Illuminate\Session\TokenMismatchException; use Illuminate\Validation\ValidationException; use Illuminate\Auth\Access\AuthorizationException; use Illuminate\Http\Exceptions\HttpResponseException; use Symfony\Component\Debug\Exception\FlattenException; use Illuminate\Database\Eloquent\ModelNotFoundException; use Symfony\Component\HttpKernel\Exception\HttpException; use Symfony\Component\HttpKernel\Exception\NotFoundHttpException; use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException; use App\Libs\ConfHelper; use Aacotroneo\Saml2\Facades\Saml2Auth; use App\Exceptions\SamlException; use App\Scvuser; class Handler extends ExceptionHandler { use \App\Traits\ApiHelper; protected $dontReport = [ HttpException::class, ]; public function report(Exception $e) { return parent::report($e); } public function render($request, Exception $e) { $status_code = $this->isHttpException($e) ? $e->getStatusCode() : 500; if ($request->is('api/*') || $request->is('ajax/*') || $request->ajax()) { $msg = $e->getMessage(); if ($msg === '') $msg = 'システムエラー'; $data = ['status_code' => $status_code]; return $this->api_response(false, $msg, $data); } if ($e instanceof AuthorizationException) { return parent::render($request, $e); } if ($e instanceof TokenMismatchException) { return redirect(url()->current())->withInput()->withErrors(["errmsg" => "セッションの有効期限が切れました。再度入力してください。"]); } if ($e instanceof AuthenticationException) return parent::render($request, $e); if (env('APP_DEBUG') == 'true') return parent::render($request, $e); if ($e instanceof ValidationException) return $this->convertValidationExceptionToResponse($e, $request); if ($e instanceof QueryException) return response()->view('errors.index', ['errmsg' => 'データベースエラー']); if ($e instanceof NotFoundHttpException) return response()->view('errors.404', [], 404); if ($this->isHttpException($e) && $e->getStatusCode() == 403) return response()->view('errors.403', ['message' => $e->getMessage()]); if ($e instanceof SamlException) return $e->getMessage(); logger($e); return $request->expectsJson ? $this->api_response(false, 'システムエラー。詳細はログを参照してください') : response()->view('errors.500', ['errmsg' => 'システムエラー'], 500); } protected function unauthenticated($request, AuthenticationException $exception) { $isBr = in_array('revobr_api', $exception->guards()); $isDt = in_array('revodt_api', $exception->guards()); if ($isBr || $isDt) { return response()->json(['status' => 'error', 'message' => 'Invalid or expired token'], 403); } if (in_array('api', $exception->guards(), true)) { return $this->api_response(false, '有効なアクセストークンが見つかりません。'); } if ($request->expectsJson()) { return response()->json(['error' => 'Unauthenticated.'], 401); } $authkey = $request->header('X-SCVX-Flow'); if (ConfHelper::active_auth() === 'scvxkerberos') $authkey = null; if ($authkey !== null) { if (preg_match("/^[a-zA-Z0-9]+$/", $authkey)) { $output = shell_exec("scvflow -checkheader {$authkey}"); preg_match('/STAT:([^ ]+) org=([^ ]+) usr=([^ ]+)/', $output, $m); if (count($m) > 3) { $stat = $m[1]; $org = $m[2]; $user = $m[3]; if ($stat === 'OK') { $scvuser = Scvuser::with_org($org, $user); auth('scvuser')->login($scvuser); return redirect('/scvflow'); } else { logger("SCV Flow：認証スキップに失敗しました。コンテナが存在していません。"); } } else { logger("SCV Flow：認証スキップに失敗しました。-checkheaderの結果が正常に取得できませんでした。"); } } else { logger("SCV Flow：認証スキップに失敗しました。キーが不正です。"); } } if (in_array('scvuser', $exception->guards(), true)) { $auth = ConfHelper::active_auth(); if (strpos($auth, 'scvxsaml') === 0) { session(['intended' => \Request::path()]); return Saml2Auth::login(); } else return redirect()->intended(route('scvflow.login')); } return redirect()->intended(route('login')); } } 