<?php
 namespace App; use DB; use Illuminate\Database\Eloquent\Model; use Illuminate\Http\Request; use App\Libs\ClusterHelper as CH; use App\Organization; class Firefoxprofile extends Model { protected $guarded = [ '_token', 'about_all', 'about_preferences', 'about_config', 'about_accounts', 'about_support', 'about_addons', 'about_profiles' ]; public function scvgroups() { return $this->hasMany(Scvgroup::class); } public static function getFirefoxprofileWithOrg() { return FirefoxProfile::select('firefoxprofiles.*') ->join('organizations', 'firefoxprofiles.organization_id', '=', 'organizations.id') ->addselect('organizations.name as org_name') ->get(); } public static function getFirefoxprofileWithOrgByOrgId($organization_id) { return FirefoxProfile::select('firefoxprofiles.*') ->join('organizations', 'firefoxprofiles.organization_id', '=', 'organizations.id') ->addselect('organizations.name as org_name') ->where('organizations.id', '=', $organization_id) ->get(); } public static function getFirefoxprofileAndOrgByName($profile_name, $organization_id) { return FirefoxProfile::select('firefoxprofiles.name') ->join('organizations', 'firefoxprofiles.organization_id', '=', 'organizations.id') ->addselect('organizations.name as organization_name') ->where('firefoxprofiles.name', '=', $profile_name) ->where('organizations.id', '=', $organization_id) ->first(); } public static function getFirefoxprofilesByOrgId($organization_id) { return FirefoxProfile::where('organization_id', '=', $organization_id)->get(); } public function getPauthPassAttribute($value) { if($value === 'SCVUSER'){ return $value; } $clear = exec("scvstr -d -- '$value'"); return $clear; } public function getPauthPassCipherAttribute() { return $this->attributes['pauth_pass']; } public function setPauthPassAttribute($value) { $pass = null; if ($value == "") { $pass = ""; } else if ($value === 'SCVUSER'){ $pass = 'SCVUSER'; } else { $value = escapeshellarg($value); $cipher = exec("scvstr -e -- $value"); $pass = $cipher; } $this->attributes['pauth_pass'] = $pass; } public static function create(array $request = []) { $milli_time = floor(microtime(true) * 1000); $firefoxprof = new FirefoxProfile($request); $dbret = $firefoxprof->save(); $slavedbret = ""; if(!$dbret){ \Log::error('FirefoxProfController : store method', ['code' => 'FP01', 'ret' => $dbret]); \Session::flash('flash_msg', 'データベース処理に失敗しました。 : FP01'); return redirect()->back()->withInput(); } $organization_name = Organization::find($firefoxprof->organization_id)->name; parent::createProfile($firefoxprof, $organization_name); if(CH::isCluster()){ if(CH::isMasterActive() && $dbret){ if(CH::isSlaveAlive() && CH::isSlaveActive()){ $slaveprof = new Firefoxprofile($request); $slaveprof->setConnection('slave_database'); $slavedbret = $slaveprof->save(); } DB::table('clusters')->lockForUpdate()->where('role','MASTER')->update(['tpl_updatemill' => $milli_time]); } CH::updateClusters($dbret,$slavedbret,$milli_time); } } public static function updateSetting(array $request, $id) { $milli_time = floor(microtime(true) * 1000); $firefoxprof = parent::find($id); $before_organization_name = Organization::find($firefoxprof->organization_id)->name; $before_firefoxprof_name = $firefoxprof->name; $dbret = $firefoxprof->fill($request)->save(); $slavedbret = ""; if(!$dbret){ \Log::error('FirefoxProfController : store method', ['code' => 'FP01', 'ret' => $dbret]); \Session::flash('flash_msg', 'データベース処理に失敗しました。 : FP01'); return redirect()->back()->withInput(); } $organization_name = Organization::find($firefoxprof->organization_id)->name; parent::createProfile($firefoxprof, $organization_name); $before_cert_path = "/var/www/html/scv/scvtemplates/".$before_organization_name."/".$before_firefoxprof_name."/cert"; $certs_csv_path = "/var/www/html/scv/scvtemplates/".$before_organization_name."/".$before_firefoxprof_name."/certs.csv"; $after_cert_path = "/var/www/html/scv/scvtemplates/".$organization_name."/".$firefoxprof->name."/cert"; $after_certs_csv_path = "/var/www/html/scv/scvtemplates/".$organization_name."/".$firefoxprof->name."/certs.csv"; if (file_exists($before_cert_path)) { rename($before_cert_path, $after_cert_path); chown($after_cert_path, "www-data"); chgrp($after_cert_path, "docker"); } if (file_exists($certs_csv_path)) { rename($certs_csv_path, $after_certs_csv_path); chown($after_certs_csv_path, "www-data"); chgrp($after_certs_csv_path, "docker"); } if ($before_organization_name != $organization_name || $before_firefoxprof_name != $firefoxprof->name ) { $before_prof_path = "/var/www/html/scv/scvtemplates/".$before_organization_name."/".$before_firefoxprof_name; exec("rm -rf ${before_prof_path}"); } if(CH::isCluster()){ if(CH::isMasterActive() && $dbret){ if(CH::isSlaveAlive() && CH::isSlaveActive()){ $slaveprof = self::on('slave_database')->find($id); $slavedbret = $slaveprof->fill($request)->save(); } DB::table('clusters')->lockForUpdate()->where('role','MASTER')->update(['tpl_updatemill' => $milli_time]); } CH::updateClusters($dbret,$slavedbret,$milli_time); } } public static function destroy($id) { $firefoxprof = parent::find($id); $name = $firefoxprof->name; $organization = Organization::find($firefoxprof->organization_id); $dbret = $firefoxprof->delete(); $slavedbret = ""; if(!$dbret){ \Session::flash('flash_msg', 'データベース処理に失敗しました。'); return redirect()->back()->withInput(); } if(CH::isCluster()){ $milli_time = floor(microtime(true) * 1000); if(CH::isMasterActive() && $dbret){ if(CH::isSlaveAlive() && CH::isSlaveActive()){ $slavemodel = new Firefoxprofile; $slavemodel->setConnection('slave_database'); $tmp = $slavemodel->where('name', '=', $name)->first(); $slaveid = $tmp->id; $slaveprof = $slavemodel->find($slaveid); $slavedbret = $slaveprof->delete(); } DB::table('clusters')->lockForUpdate()->where('role','MASTER')->update(['tpl_updatemill' => $milli_time]); } CH::updateClusters($dbret,$slavedbret,$milli_time); } $path = "/var/www/html/scv/scvtemplates/".$organization->name."/".$name; if(file_exists($path)){ exec("rm -rf $path"); } } private static function makeAllowedPopups($text) { $text = str_replace(array("\r\n", "\r", "\n"), "\n", $text); $list = explode("\n", $text); $obj = json_decode('{"Allow":[],"Default":true,"Locked":false}'); $obj->Allow = $list; return $obj; } public static function createProfile($firefoxprof, $organization_name) { $organization_path = "/var/www/html/scv/scvtemplates/".$organization_name; $setting_path = "/var/www/html/scv/scvtemplates/".$organization_name."/".$firefoxprof->name; if(!file_exists($setting_path)){ mkdir($setting_path, 0777, true); chown($setting_path,"www-data"); chgrp($setting_path,"docker"); chmod($setting_path, 0770); chown($organization_path,"www-data"); chgrp($organization_path,"docker"); chmod($organization_path, 0770); } if(!file_exists($setting_path."/chrome")){ mkdir($setting_path."/chrome"); chown($setting_path."/chrome","www-data"); chgrp($setting_path."/chrome","docker"); chmod($setting_path."/chrome", 0770); } $userjs = array(); $userjs[] = 'user_pref("browser.reader.detectedFirstArticle",true);'; $userjs[] = 'user_pref("browser.shell.checkDefaultBrowser",false);'; $userjs[] = 'user_pref("toolkit.legacyUserProfileCustomizations.stylesheets",true);'; $userjs[] = 'user_pref("browser.sessionstore.resume_from_crash",false);'; $userjs[] = 'user_pref("browser.sessionstore.enabled",false);'; $userjs[] = 'user_pref("startup.homepage_welcome_url","");'; $userjs[] = 'user_pref("browser.urlbar.disableExtendForTests",true);'; $userjs[] = 'user_pref("browser.urlbar.maxRichResults",0);'; $userjs[] = 'user_pref("extensions.@scv-addon.max",'.$firefoxprof->max_tab.');'; $disable_js = $firefoxprof->disable_js ? "false" : "true"; $userjs[] = 'user_pref("javascript.enabled",'.$disable_js.');'; $userjs[] = 'user_pref("network.proxy.type",'.$firefoxprof->proxy_type.');'; if($firefoxprof->proxy_type == "1"){ $userjs[] = 'user_pref("network.proxy.http","'.$firefoxprof->http_proxy_host.'");'; $userjs[] = 'user_pref("network.proxy.http_port",'.$firefoxprof->http_proxy_port.');'; $userjs[] = 'user_pref("network.proxy.ssl","'.$firefoxprof->ssl_proxy_host.'");'; $userjs[] = 'user_pref("network.proxy.ssl_port",'.$firefoxprof->ssl_proxy_port.');'; $userjs[] = 'user_pref("network.proxy.no_proxies_on","'.$firefoxprof->no_proxy_host.'");'; } if($firefoxprof->proxy_type != "0"){ $auth_flag = $firefoxprof->proxy_auth ? "true" : "false"; $userjs[] = 'user_pref("signon.autologin.proxy",'.$auth_flag.');'; } if($firefoxprof->proxy_type == "2"){ $userjs[] = 'user_pref("network.proxy.autoconfig_url","'.$firefoxprof->proxy_url.'");'; } if($firefoxprof->homepage != ""){ $userjs[] = 'user_pref("browser.startup.homepage","'.$firefoxprof->homepage.'");'; } $userjs[] = 'user_pref("browser.startup.page",'.$firefoxprof->startup_page.');'; if($firefoxprof->file_path == "path_home"){ $userjs[] = 'user_pref("print.print_to_filename","/root/mozilla.pdf");'; $userjs[] = 'user_pref("extensions.@scv-addon.open_path","/root");'; }else if($firefoxprof->file_path == "path_dl"){ $userjs[] = 'user_pref("print.print_to_filename","/root/'.$firefoxprof->downloaddir.'/mozilla.pdf");'; $userjs[] = 'user_pref("extensions.@scv-addon.open_path","/root/'.$firefoxprof->downloaddir.'");'; } if($firefoxprof->contents_process > 0){ $userjs[] = 'user_pref("browser.preferences.defaultPerformanceSettings.enabled", false);'; $userjs[] = 'user_pref("dom.ipc.processCount", '.$firefoxprof->contents_process.');'; } $userjs[] = 'user_pref("layers.acceleration.disabled", true);'; if(!$firefoxprof->save_cookie || !$firefoxprof->save_history){ $userjs[] = 'user_pref("privacy.sanitize.sanitizeOnShutdown", true);'; }else{ $userjs[] = 'user_pref("privacy.sanitize.sanitizeOnShutdown", false);'; } $save_history = $firefoxprof->save_history ? "false" : "true"; $userjs[] = 'user_pref("privacy.clearOnShutdown.history",'.$save_history.');'; $save_password = $firefoxprof->save_password ? "true" : "false"; $userjs[] = 'user_pref("signon.rememberSignons",'.$save_password.');'; $clear_cookie = $firefoxprof->save_cookie ? "false" : "true"; $userjs[] = 'user_pref("privacy.clearOnShutdown.cookies",'.$clear_cookie.');'; $save_cookie = $firefoxprof->save_cookie ? "0" : "2"; $userjs[] = "user_pref(\"network.cookie.lifetimePolicy\",$save_cookie);"; $enable_pocket = $firefoxprof->disable_pocket == 1 ? "false" : "true"; $userjs[] = "user_pref(\"extensions.pocket.enabled\",$enable_pocket);"; $enable_formfill = $firefoxprof->disable_formfill == 1 ? "false" : "true"; $userjs[] = "user_pref(\"browser.formfill.enable\",$enable_formfill);"; $enable_open_chrome = $firefoxprof->enable_open_chrome ? "1" : "0"; $userjs[] = 'user_pref("extensions.@scv-addon.enable_open_chrome",'.$enable_open_chrome.');'; $dco = $firefoxprof->disable_config ? 1 : 0; $dac = $firefoxprof->disable_accounts ? 1 : 0; $dad = $firefoxprof->disable_addons ? 1 : 0; $dpre = $firefoxprof->disable_preferences ? 1 : 0; $dsu = $firefoxprof->disable_support ? 1 : 0; $dpro = $firefoxprof->disable_profiles ? 1 : 0; $dal = $firefoxprof->disable_all ? 1 : 0; $userjs[] = 'user_pref("extensions.@scv-addon.disable_config",'.$dco.');'; $userjs[] = 'user_pref("extensions.@scv-addon.disable_accounts",'.$dac.');'; $userjs[] = 'user_pref("extensions.@scv-addon.disable_addons",'.$dad.');'; $userjs[] = 'user_pref("extensions.@scv-addon.disable_preferences",'.$dpre.');'; $userjs[] = 'user_pref("extensions.@scv-addon.disable_support",'.$dsu.');'; $userjs[] = 'user_pref("extensions.@scv-addon.disable_profiles",'.$dpro.');'; $userjs[] = 'user_pref("extensions.@scv-addon.disable_all",'.$dal.');'; $userjs[] = 'user_pref("privacy.userContext.enabled",false);'; $userjs[] = 'user_pref("media.videocontrols.picture-in-picture.video-toggle.enabled",false);'; $userjs[] = 'user_pref("browser.backspace_action",0);'; $userjs[] = 'user_pref("browser.toolbars.bookmarks.visibility", "always");'; $userjs[] = 'user_pref("browser.download.always_ask_before_handling_new_types", true);'; $userjs_fp = fopen($setting_path."/user.js", "w+"); if($userjs_fp){ foreach ($userjs as $line) { fwrite($userjs_fp, $line."\n"); } fclose($userjs_fp); chown($setting_path."/user.js","www-data"); chgrp($setting_path."/user.js","docker"); chmod($setting_path."/user.js", 0770); }else{ \Log::error('FirefoxProfController : store method', ['code' => 'FP02']); \Session::flash('flash_msg', '<p style="color:red;">設定ファイルの書き込みに失敗しました。 : FP02</p>'); return view('errors.index'); } $chrome_array = array(); $content_array = array(); $menu_bar = "\n@-moz-document url-prefix(chrome://browser/content/browser) {\n"; $menu_bar .= "  #bookmarksShowAll,\n". "  #bookmarksShowAll *,\n". "  #BMB_bookmarksShowAllTop,\n". "  #BMB_bookmarksShowAllTop *,\n". "  #BMB_bookmarksShowAll,\n". "  #BMB_bookmarksShowAll *,\n". "  #menu_unsortedBookmarks,\n". "  #menu_unsortedBookmarks *,\n". "  #BMB_unsortedBookmarks,\n". "  #BMB_unsortedBookmarks *,\n". "  #helpSafeMode,\n". "  #helpSafeMode *\n"; if($firefoxprof->disable_all || $firefoxprof->disable_config){ $content_array[] = "@-moz-document url-prefix(about:config) {\n". "  * {\n". "    visibility: collapse !important;\n". "    -moz-user-focus: ignore !important;\n". "  }\n". "}\n"; } if($firefoxprof->disable_all || $firefoxprof->disable_preferences){ $content_array[] = "@-moz-document url-prefix(about:preferences) {\n". "  * {\n". "    visibility: collapse !important;\n". "    -moz-user-focus: ignore !important;\n". "  }\n". "}\n"; $menu_bar .=",\n". "  #preferences-button,\n". "  #appMenu-preferences-button,\n". "  #menu_preferences,\n". "  #menu_preferences *,\n". "  #prefsep,\n". "  #prefsep *,\n". "  #appMenu-settings-button,\n". "  #appMenu-settings-button *"; } if($firefoxprof->disable_all || $firefoxprof->disable_accounts){ $content_array[] = "@-moz-document url-prefix(about:accounts) {\n". "  * {\n". "    visibility: collapse !important;\n". "    -moz-user-focus: ignore !important;\n". "  }\n". "}\n"; $chrome_array[] = "/* user Chrome */\n". "@-moz-document url-prefix(chrome://browser/content/browser) {\n". "  #sync-setup,\n". "  #sync-setup *,\n". "  #sync-setup-state,\n". "  #sync-reauth-state,\n". "  #sync-syncnow-state,\n". "  #sync-start-panel,\n". "  #sync-start-panel *,\n". "  #sync-syncnowitem,\n". "  #sync-reauthitem,\n". "  #sync-EnginePrefs *,\n". "  #header-sync *,\n". "  #syncStatusMessage-container *,\n". "  #category-sync,\n". "  #category-sync *,\n". "  #syncGroupBox *,\n". "  #syncOptions *,\n". "  #sync-tabs-menuitem,\n". "  #sync-tabs-menuitem *,\n". "  #sync-tabs-menuitem2,\n". "  #sync-tabs-menuitem2 *,\n". "  #wrapper-sync-button,\n". "  #wrapper-sync-button * {\n". "    visibility: collapse !important;\n". "    -moz-user-focus: ignore !important;\n". "  }\n". "}"; } if($firefoxprof->disable_all || $firefoxprof->disable_addons){ $content_array[] = "@-moz-document url-prefix(about:addons) {\n". "  * {\n". "    visibility: collapse !important;\n". "    -moz-user-focus: ignore !important;\n". "  }\n". "}\n". "@-moz-document url-prefix(https://addons.mozilla.org/) {\n". "  * {\n". "    visibility: collapse !important;\n". "    -moz-user-focus: ignore !important;\n". "  }\n". "}\n"; $chrome_array[] = "/* addon menu */\n". "@-moz-document url-prefix(chrome://browser/content/browser) {\n". "  #menu_openAddons,\n". "  #menu_openAddons *,\n". "  #appMenu-extensions-themes-button,\n". "  #appMenu-extensions-themes-button *\n". "  {\n". "    visibility: collapse !important;\n". "    -moz-user-focus: ignore !important;\n". "  }\n". "}"; } if($firefoxprof->disable_all || ($firefoxprof->disable_accounts && $firefoxprof->disable_addons)){ $menu_bar .=",\n". "  #PanelUI-fxa-label,\n". "  #PanelUI-fxa-label *,\n". "  #menu_openAddons,\n". "  #menu_openAddons *,\n". "  #add-ons-button,\n". "  #appMenu-addons-button"; }elseif ($firefoxprof->disable_accounts) { $menu_bar .=",\n". "  #PanelUI-fxa-label,\n". "  #PanelUI-fxa-label *"; }elseif($firefoxprof->disable_addons){ $menu_bar .=",\n". "  #menu_openAddons,\n". "  #menu_openAddons *,\n". "  #add-ons-button, \n". "  #appMenu-addons-button"; } $menu_bar .=",\n". "  #webDeveloperMenu,\n". "  #developer-button,\n". "  #webDeveloperMenu,\n". "  #browserToolsMenu,\n". "  #appMenu-more-button2"; $chrome_array[] .= "/* context menu */\n". "@-moz-document url-prefix(chrome://browser/content/browser) {\n". "  #context-viewsource\n". "  {\n". "    visibility: collapse !important;\n". "    -moz-user-focus: ignore !important;\n". "  }\n". "}"; $content_array[] .= "@-moz-document url-prefix(view-source) {\n". "  #viewsource\n". "  {\n". "    visibility: collapse !important;\n". "    -moz-user-focus: ignore !important;\n". "  }\n". "}"; if($firefoxprof->disable_all || $firefoxprof->disable_support){ $content_array[] = "@-moz-document url-prefix(about:support) {\n". "  * {\n". "    visibility: collapse !important;\n". "    -moz-user-focus: ignore !important;\n". "  }\n". "}\n"; } if($firefoxprof->disable_all || $firefoxprof->disable_profiles){ $content_array[] = "@-moz-document url-prefix(about:profiles) {\n". "  * {\n". "    visibility: collapse !important;\n". "    -moz-user-focus: ignore !important;\n". "  }\n". "}\n"; } $content_array[] = "@-moz-document url-prefix(about:home) {\n". "  #launcher,\n". "  #launcher * {\n". "    visibility: collapse !important;\n". "    -moz-user-focus: ignore !important;\n". "  }\n". "}"; $menu_bar .="\n". "  {\n". "    display:none !important;\n". "  }\n". "}\n"; $chrome_array[] = $menu_bar; if(!file_exists($setting_path."/chrome")){ mkdir($setting_path."/chrome"); chown($setting_path."/chrome","www-data"); chgrp($setting_path."/chrome","docker"); chmod($setting_path."/chrome", 0770); } $contentfp = fopen($setting_path."/chrome/userContent.css", "w+"); if($contentfp){ foreach ($content_array as $line) { fwrite($contentfp, $line); } chown($setting_path."/chrome/userContent.css","www-data"); chgrp($setting_path."/chrome/userContent.css","docker"); chmod($setting_path."/chrome/userContent.css", 0770); }else{ \Log::error('FirefoxProfController:userContent.css', ['code' => 'FP02']); \Session::flash('flash_msg', '<p style="color:red;">設定ファイルの書き込みに失敗しました。</p>'); return view('errors.index'); } $chromefp = fopen($setting_path."/chrome/userChrome.css", "w+"); if($chromefp){ foreach ($chrome_array as $line) { fwrite($chromefp, $line); } chown($setting_path."/chrome/userChrome.css","www-data"); chgrp($setting_path."/chrome/userChrome.css","docker"); chmod($setting_path."/chrome/userChrome.css", 0770); }else{ \Log::error('FirefoxProfController:userChrome.css', ['code' => 'FP03']); \Session::flash('flash_msg', '<p style="color:red;">設定ファイルの書き込みに失敗しました。</p>'); return view('errors.index'); } $policie_engine_file = $setting_path."/policies.json"; if(is_readable($policie_engine_file)){ $policy_obj = json_decode(file_get_contents($policie_engine_file)); if($policy_obj == null){ \Session::flash('flash_msg', '<p style="color:red;">policies.jsonの書き込みに失敗しました。</p>'); return; } if($firefoxprof->disable_all){ $policy_obj->policies->BlockAboutAddons = true; $policy_obj->policies->BlockAboutConfig = true; $policy_obj->policies->BlockAboutProfiles = true; $policy_obj->policies->BlockAboutSupport = true; $policy_obj->policies->DisableFirefoxAccounts = true; }else{ $policy_obj->policies->BlockAboutAddons = $firefoxprof->disable_addons; $policy_obj->policies->BlockAboutConfig = $firefoxprof->disable_config; $policy_obj->policies->BlockAboutProfiles = $firefoxprof->disable_profiles; $policy_obj->policies->BlockAboutSupport = $firefoxprof->disable_support; $policy_obj->policies->DisableFirefoxAccounts = $firefoxprof->disable_accounts; } }else{ $policy_obj = json_decode('{"policies":{}}'); if($firefoxprof->disable_all){ $policy_obj->policies->BlockAboutAddons = true; $policy_obj->policies->BlockAboutConfig = true; $policy_obj->policies->BlockAboutProfiles = true; $policy_obj->policies->BlockAboutSupport = true; $policy_obj->policies->DisableFirefoxAccounts = true; }else{ $policy_obj->policies->BlockAboutAddons = $firefoxprof->disable_addons; $policy_obj->policies->BlockAboutConfig = $firefoxprof->disable_config; $policy_obj->policies->BlockAboutProfiles = $firefoxprof->disable_profiles; $policy_obj->policies->BlockAboutSupport = $firefoxprof->disable_support; $policy_obj->policies->DisableFirefoxAccounts = $firefoxprof->disable_accounts; } $policy_obj->policies->DisableAppUpdate = true; $policy_obj->policies->DisableDeveloperTools = true; $policy_obj->policies->DisableFeedbackCommands= true; $policy_obj->policies->DisableTelemetry = true; } $policy_obj->policies->DisablePrivateBrowsing = true; $policy_obj->policies->DisableAppUpdate = true; $policy_obj->policies->CaptivePortal = (bool)$firefoxprof->captive_portal; $policy_obj->policies->ShowHomeButton = true; $policy_obj->policies->WindowsSSO = false; $policy_obj->policies->DisableSafeMode = true; $policy_obj->policies->DisplayMenuBar = true; $policy_obj->policies->UseSystemPrintDialog = true; $locked = json_decode('{"Locked":{}}'); $locked->Locked = ["scvx@jscom.jp","revobrowser_extension@jscom.co.jp"]; $policy_obj->policies->Extensions = $locked; $policy_obj->policies->Bookmarks = json_decode($firefoxprof->bookmarks); $certificates = json_decode('{}'); $certificates->ImportEnterpriseRoots = (bool)$firefoxprof->import_enterprise_roots; $policy_obj->policies->Certificates = $certificates; $um = json_decode('{}'); $um->WhatsNew = false; $um->ExtensionRecommendations = false; $um->FeatureRecommendations = false; $um->SkipOnboarding = true; $policy_obj->policies->UserMessaging = $um; $policy_obj->policies->PopupBlocking = self::makeAllowedPopups($firefoxprof->allowed_popups); $policy_engine_json = json_encode($policy_obj, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES); file_put_contents($policie_engine_file, $policy_engine_json); chown($policie_engine_file,"www-data"); chgrp($policie_engine_file,"docker"); chmod($policie_engine_file, 0660); parent::setExtensionSettings($firefoxprof, $organization_name); } public static function setExtensionSettings($firefoxprof, $organization_name) { $path = "/var/www/html/scv/scvtemplates/".$organization_name."/".$firefoxprof->name; $settings_file = $path."/extension_settings.json"; $obj = json_decode('{"parameters":{}}'); $obj->parameters->save_history = (boolean)$firefoxprof->save_history; $obj->parameters->history_max_age = (int)$firefoxprof->history_max_age; $json = json_encode($obj, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES); file_put_contents($settings_file, $json); chown($settings_file,"www-data"); chgrp($settings_file,"docker"); chmod($settings_file, 0660); } public static function certData($profile_name, $organization_name) { $path = "/var/www/html/scv/scvtemplates/".$organization_name."/".$profile_name."/certs.csv"; $files = array(); if(file_exists($path)){ $text = file_get_contents($path); $files = array_values(array_filter(explode("\n", $text))); }else{ $files = array(); } return $files; } public static function certSave($firefoxprof, $organization_name, $file, $password) { $base_dir = "/var/www/html/scv/scvtemplates/".$organization_name."/".$firefoxprof->name; $path = $base_dir."/cert"; $fn = $file->getClientOriginalName(); $file->move($path, $fn); if($password){ $password = exec("/var/www/html/scv/scvbin/scvstr -e -- '$password'"); } $certs_file = $base_dir."/certs.csv"; $md5 = md5_file($path."/".$fn); $mt = microtime(true) * 10000; $first = $md5."_".$mt; file_put_contents($certs_file, "$first,$fn,$password\n", FILE_APPEND); if(CH::isCluster()){ $milli_time = floor(microtime(true) * 1000); DB::table('clusters')->lockForUpdate()->where('role','MASTER')->update(['tpl_updatemill' => $milli_time]); } } public static function certDelete($fn, $prof_name, $organization_name) { $base_dir = "/var/www/html/scv/scvtemplates/".$organization_name."/".$prof_name; $certs_file = $base_dir."/certs.csv"; $fb = file_get_contents($base_dir."/certs.csv"); $t = preg_quote($fn); $new_fb = preg_replace("/.*$t.*\n/", '', $fb); file_put_contents($certs_file, $new_fb); unlink($base_dir."/cert/".$fn); if(CH::isCluster()){ $milli_time = floor(microtime(true) * 1000); DB::table('clusters')->lockForUpdate()->where('role','MASTER')->update(['tpl_updatemill' => $milli_time]); } } public static function usedByFirefoxprofile($organization_id) { if(Firefoxprofile::where('organization_id', '=', $organization_id)->count() > 0) { return true; } return false; } } 