<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use App\Http\Requests; use App\Http\Requests\AdminPolicyRequest; use App\Http\Controllers\Controller; use App\Organization; use App\AdminPolicy; use App\Libs\ClusterHelper as CH; class AdminPolicyController extends Controller { private $pwd_length_max = 32; private $pwd_generation_limit_max = 24; public function index() { $adminpolicies = AdminPolicy::getAdminPoliciesAndOrgName(); return view('adminpolicy.index', compact('adminpolicies')); } public function create() { $organizations = Organization::getAllIdAndNames(); $pwd_length_max = $this->pwd_length_max; $pwd_generation_limit_max = $this->pwd_generation_limit_max; return view('adminpolicy.create', compact('organizations', 'pwd_length_max', 'pwd_generation_limit_max')); } public function show(Request $request) { $adminpolicy = Adminpolicy::getAdminpolicyById($request->id); $organization = Organization::find($adminpolicy->organization_id); $pwd_length_max = $this->pwd_length_max; $pwd_generation_limit_max = $this->pwd_generation_limit_max; return view('adminpolicy.show', compact('adminpolicy', 'organization', 'pwd_length_max', 'pwd_generation_limit_max')); } public function edit(Request $request) { $adminpolicy = Adminpolicy::getAdminpolicyById($request->id); $organization = Organization::find($adminpolicy->organization_id); if($adminpolicy->pwd_complexity) { $adminpolicy->pwd_complexity = true; } else { $adminpolicy->pwd_complexity = false; } $pwd_length_max = $this->pwd_length_max; $pwd_generation_limit_max = $this->pwd_generation_limit_max; return view('adminpolicy.edit', compact('adminpolicy', 'organization', 'pwd_length_max', 'pwd_generation_limit_max')); } public function store(AdminPolicyRequest $request) { $adminpolicy = new Adminpolicy; $params = $request->all(); $adminpolicy->pwd_complexity = $request->pwd_complexity !== null ? (int)$request->pwd_complexity : 0; if (Adminpolicy::existSetting($params['organization_id'])) { return redirect()->back()->withErrors('既にその組織管理者パスワードポリシーが存在しています。'); } $adminpolicy->fill($params); $dbret = $adminpolicy->save(); $slavedbret = ""; if (!$dbret) { return redirect()->back()->withErrors('設定の保存に失敗しました。'); } if(CH::isCluster()) { if(CH::isMasterActive() && $dbret) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slave_adminpolicy = new Adminpolicy; $slave_adminpolicy->setConnection('slave_database'); $slave_adminpolicy->pwd_complexity = $request->pwd_complexity !== null ? (int)$request->pwd_complexity : 0; $slave_adminpolicy->fill($params); $slavedbret = $slave_adminpolicy->save(); } } CH::updateClusters($dbret,$slavedbret); } return redirect('scvmanager/adminpolicy')->with('success', '設定を作成しました。'); } public function update(AdminPolicyRequest $request) { $adminpolicy = Adminpolicy::find($request->id); $params = $request->all(); $adminpolicy->fill($params); $adminpolicy->pwd_complexity = $request->pwd_complexity !== null ? (int)$request->pwd_complexity : 0; $dbret = $adminpolicy->save(); $slavedbret = ""; if (!$dbret) { return redirect()->back()->withErrors('設定の保存に失敗しました。'); } if(CH::isCluster()) { if(CH::isMasterActive() && $dbret) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slave_adminpolicy_model = new Adminpolicy; $slave_adminpolicy_model->setConnection('slave_database'); $slave_adminpolicy = $slave_adminpolicy_model->find($request->id); $slave_adminpolicy->fill($params); $slavedbret = $slave_adminpolicy->save(); } } CH::updateClusters($dbret,$slavedbret); } return redirect('scvmanager/adminpolicy')->with('success', '設定を保存しました。'); } public function delete(Request $request) { $adminpolicy = Adminpolicy::find($request->id); $dbret = $adminpolicy->delete(); $slavedbret = ""; if(CH::isCluster()) { if(CH::isMasterActive() && $dbret) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slave_adminpolicy_model = new Adminpolicy; $slave_adminpolicy_model->setConnection('slave_database'); $slave_adminpolicy = $slave_adminpolicy_model->find($request->id); $slavedbret = $slave_adminpolicy->delete(); } } CH::updateClusters($dbret,$slavedbret); } return redirect('scvmanager/adminpolicy'); } } 