<?php
 namespace App\Http\Controllers\Api; use Illuminate\Http\Request; use App\Clientlog; use App\Filelog; use App\Http\Controllers\Controller; use App\Http\Requests\revobr\CommonRequest; use App\Http\Requests\revobr\FilelogRequest; use App\Libs\ConfHelper; use App\Scvuser; use App\Services\Auth\AuthFailedException; use App\Services\Auth\ScvAuthType; use App\Services\Auth\ScvUserAuthService; class CommonController extends Controller { use \App\Traits\api\ApiHelper; const API_ERROR_LOCKED = 'This account has been locked.'; const API_ERROR_PWD_EXPIRED = 'Password Expired'; const API_ERROR_GENERAL = 'Bad Request'; private $scvUserAuthService; public function __construct(ScvUserAuthService $scvUserAuthService) { $this->scvUserAuthService = $scvUserAuthService; } public function login(CommonRequest $req) { $org = $req->input('organization'); $username = $req->input('user'); $password = $req->input('password'); $domain_logon = $req->input('domain_logon'); if ($domain_logon) { $authType = ScvAuthType::_DOMAIN_LOGON; } else { $currentAuthType = ConfHelper::active_auth(); switch ($currentAuthType) { case ScvAuthType::SCVXLDAP: $authType = ScvAuthType::SCVXLDAP; break; case ScvAuthType::SCVXKERBEROS: $authType = ScvAuthType::SCVXKERBEROS; break; case ScvAuthType::SCVXLOCAL: default: $authType = ScvAuthType::SCVXLOCAL; break; } } try { $scvuser = $this->scvUserAuthService->auth($authType, $org, $username, $password); } catch (AuthFailedException $e) { switch ($e->getCode()) { case AuthFailedException::USER_IS_LOCKED: $errmsg = self::API_ERROR_LOCKED; break; case AuthFailedException::PASSWORD_EXPIRED: $isLocalAuth = in_array($authType, [ ScvAuthType::SCVXLOCAL, ScvAuthType::SCVXLOCAL_GA ], true); if ($isLocalAuth) { $scvuser = $scvuser = Scvuser::by_logintxt("{$org}/{$username}"); } else { Clientlog::insertLog(Clientlog::MSG_LOGIN_FAILURE, $req); $errmsg = self::API_ERROR_PWD_EXPIRED; } break; case AuthFailedException::USER_NOT_FOUND: default: Clientlog::insertLog(Clientlog::MSG_LOGIN_FAILURE, $req); $errmsg = self::API_ERROR_GENERAL; break; } } $j_obj = $this->getTemplateObject(); if (isset($errmsg)) { $j_obj->message = $errmsg; return $this->apiResponse($j_obj, $this->API_BAD_REQUEST); } $j_obj->access_token = auth('revobr_api') ->setTTL(60 * 24) ->login($scvuser); $j_obj->expires_in = auth('revobr_api') ->factory() ->getTTL() * 60; return $this->apiResponse($j_obj, $this->API_SUCCESS); } private function getLimit($type) { if($type == "stz") $opt = "-stzlimit"; else if($type == "vck") $opt = "-vcklimit"; else if($type == "tck") $opt = "-tcklimit"; else $opt = "x"; $cmd = "sudo -i -u scvrun scvlicense ".$opt; exec($cmd, $out, $code); $j_obj = $this->getTemplateObject(); if($code != 0){ $j_obj->message = $out; return $this->apiResponse($j_obj, $this->API_INTERNAL_SERVER_ERROR); }else{ $j_obj->message = $out[0]; return $this->apiResponse($j_obj, $this->API_SUCCESS); } } public function stzlimit() { return $this->getLimit("stz"); } public function vcklimit() { return $this->getLimit("vck"); } public function tcklimit() { return $this->getLimit("tck"); } public function getSavEtags() { $j_obj = $this->getTemplateObject(); $etags = "/var/www/html/scv/sav/etag2.json"; if(!file_exists($etags)){ $j_obj->message = 'etag file does not exist.'; return $this->apiResponse($j_obj, $this->API_INTERNAL_SERVER_ERROR); } $json = json_decode(file_get_contents($etags)); $j_obj->etags = $json; return $this->apiResponse($j_obj, $this->API_SUCCESS); } public function getIdeFile() { $path = "/var/www/html/scv/sav/ide"; $ret = glob($path."/ide_*.zip"); $ide = @$ret[0]; if(!file_exists($ide)){ $j_obj = $this->getTemplateObject(); $j_obj->message = 'ide file does not exist.'; return $this->apiResponse($j_obj, $this->API_INTERNAL_SERVER_ERROR); } return response()->download($ide); } public function getVdlFile() { $vdl = "/var/www/html/scv/sav/vdl/vdl.zip"; if(!file_exists($vdl)){ $j_obj = $this->getTemplateObject(); $j_obj->message = 'vdl file does not exist.'; return $this->apiResponse($j_obj, $this->API_INTERNAL_SERVER_ERROR); } return response()->download($vdl); } public function getWin64Engine() { $engine = "/var/www/html/scv/sav/win64/savi_win64.zip"; if(!file_exists($engine)){ $j_obj = $this->getTemplateObject(); $j_obj->message = 'win64 engine file does not exist.'; return $this->apiResponse($j_obj, $this->API_INTERNAL_SERVER_ERROR); } return response()->download($engine); } public function getWin32Engine() { $engine = "/var/www/html/scv/sav/win32/savi_win32.zip"; if(!file_exists($engine)){ $j_obj = $this->getTemplateObject(); $j_obj->message = 'win32 engine file does not exist.'; return $this->apiResponse($j_obj, $this->API_INTERNAL_SERVER_ERROR); } return response()->download($engine); } public function threatNotification(Request $request) { $j_obj = $this->getTemplateObject(); $user = $request->input('user'); $file = $request->input('file'); $product = strtoupper($request->input('product')) ?: ''; $optionType = strtolower($request->input('option_type')) ?: ''; $virusName = $request->input('virus_name') ?: ''; $engineVersion = $request->input('engine_version') ?: ''; $vdlVersion = $request->input('vdl_version') ?: ''; $desktopName = $request->input('desktop_name') ?: ''; if ($product == 'BR') { $product = 'RevoWorks Browser'; } else if ($product == 'DT') { $product = 'RevoWorks Desktop'; } else { $product = 'SCVX'; } if ($optionType == 'tck') { $optionType = 'RevoWorks Threat Checker'; } else if ($optionType == 'vck') { $optionType = 'RevoWorks Virus Checker'; } $ret = \Artisan::call('scv:threat_notice',[ '--send-mail' => true, '--user' => $user, '--product' => $product, '--option-type' => $optionType, '--file-name' => $file, '--virus-name' => $virusName, '--engine-version' => $engineVersion, '--vdl-version' => $vdlVersion, '--desktop-name' => $desktopName ]); if($ret == 0){ return $this->apiResponse($j_obj, $this->API_SUCCESS); }else{ return $this->apiResponse($j_obj, $this->API_INTERNAL_SERVER_ERROR); } } public function filelog(FilelogRequest $reqest) { $j_obj = $this->getTemplateObject(); if (!Filelog::insertLog($reqest->all())) { $j_obj->message = "Failed to insert filelog"; return $this->apiResponse($j_obj, $this->API_INTERNAL_SERVER_ERROR); } return $this->apiResponse($j_obj, $this->API_SUCCESS); } } 