<?php
 namespace App\Http\Controllers\Api; use Illuminate\Http\Request; use App\Http\Controllers\Controller; use App\Libs\ConfHelper as CH; class TckController extends Controller { use \App\Traits\api\ApiHelper; private $florence_base_url = 'https://florence.jscom.jp/api/v1/tck'; private $proxy_option; public function __construct() { $this->proxy_option = $this->getProxyOption(); $this->florence_key = 'x-api-key: '. $this->getApiKey(); } public function getApiKey() { $path = '/var/www/html/scv/sav/api_key.txt'; $default_key = 'aUY0bz3jUY9roktcfzAhI7ezvH00RbZk49GZf2JC'; if (file_exists($path)) { $key = file_get_contents($path); return $key != false ? trim($key) : $default_key; } return $default_key; } public function getCompany() { $path = "/var/www/html/scv/scvlicense/run/license.1"; $file = fopen($path, "r"); if($file){ while($line = fgets($file)){ if(strpos($line, "COMPANY") === 0){ $company = explode("=", $line); return trim($company[1]); } } } return "NONE"; } private function getProxyOption() { $serv = CH::scvconf('SCV_PROXYSERVER'); $port = CH::scvconf('SCV_PROXYPORT'); $user = urlencode(CH::scvconf('SCV_PROXYUSR')); $pass = urlencode(CH::scvconf('SCV_PROXYPWD')); if(!$serv || !$port){ return ""; } if(strpos($serv, '://') === false){ return ""; } $ex = explode("://", $serv); $protocol = $ex[0]; $host = $ex[1]; if($user && $pass){ $url = "$protocol://$user:$pass@$host:$port"; }else{ $url = "$protocol://$host:$port"; } return "-x $url"; } public function getSandboxReport(Request $request, $sha256) { $url = $this->florence_base_url.'/sha256/'.$sha256; $cmd = "curl -k -X 'GET' -H '$this->florence_key' '$url' $this->proxy_option -w \"\n%{http_code}\""; exec($cmd, $out); $obj = json_decode($out[0]); $http_code = $out[1]; if($http_code != 200) { logger("getSandboxReport : ".implode($out)); } return response()->json($obj, $http_code); } private function getPresignedUrl() { $presign_url = $this->florence_base_url."/presigned-url"; $cmd = "curl -k -X 'GET' -H '$this->florence_key' '$presign_url' $this->proxy_option -w \"\n%{http_code}\""; exec($cmd, $out); $obj = json_decode($out[0]); $http_code = $out[1]; if($http_code != 200) { logger("getPresignedUrl : ".implode($out)); } return $obj; } private function putFileToS3($presigned_url, $file) { $upload_url = $presigned_url; $upload_cmd = "curl -k -X 'PUT' '$upload_url' --upload-file '$file' $this->proxy_option"; exec($upload_cmd, $out2); } private function enqueueJob($id) { $enqueue_url = $this->florence_base_url."/queues"; $data['id'] = $id; $data['company'] = $this->getCompany(); $data_json = json_encode($data); $upload_cmd = "curl -k -X 'POST' -H '$this->florence_key' -H 'Content-Type:application/json' '$enqueue_url' -d '$data_json' $this->proxy_option"; exec($upload_cmd, $out2); } public function sendFile(Request $request) { $res = $this->getTemplateObject(); $file = $request->file('file'); if(!$file){ $res->message = 'Please upload a file'; $res->from = 'scvx server'; return $this->apiResponse($res, $this->API_BAD_REQUEST); } if($file->getSize() < 1){ $res->message = 'The submitted file is empty'; $res->from = 'scvx server'; return $this->apiResponse($res, $this->API_BAD_REQUEST); } if($file->getClientSize() > 100 * 1024 * 1024){ $res->message = 'File size exceeded'; $res->from = 'scvx server'; return $this->apiResponse($res, $this->API_BAD_REQUEST); } $presigned_ret = $this->getPresignedUrl(); $tck_id = $presigned_ret->id; $this->putFileToS3($presigned_ret->presigned_url, $file->getRealPath()); $this->enqueueJob($tck_id); $res->status = "success"; $res->id = $tck_id; return $this->apiResponse($res, $this->API_SUCCESS); } public function getJobs(Request $request, $id) { $url = $this->florence_base_url."/jobs/".$id; $cmd = "curl -k -X 'GET' -H '$this->florence_key' '$url' $this->proxy_option -w \"\n%{http_code}\""; exec($cmd, $out); $obj = json_decode($out[0]); $http_code = $out[1]; if($http_code != 200) { logger("getSandboxReport : ".implode($out)); } return response()->json($obj, $http_code); } } 