<?php
 namespace App\Http\Controllers; use Request; use App\Http\Controllers\Controller; use App\Organization; use App\Scvgroup; use App\Scvuser; use App\Jobs\ScvuserJob; use App\Libs\ClusterHelper as CH; use App\Libs\BatchCsvManager; class BatchEditController extends Controller { private $bcm = null; private $cntobj = null; private $dont_job = 0; public function __construct() { $this->bcc = $this->init_csv_columns(); $this->bcm = new BatchCsvManager($this->bcc); $memory_limit = env('PHP_MEMORY_LIMIT', '256M'); ini_set('memory_limit', $memory_limit); $this->cntobj = new class { public $succeeded = 0; public $failed = 0; public $ignored = 0; }; } private function init_csv_columns() { $batcsvcol = BatchCsvManager::create_column_object(); $batcsvcol->add('action', '操作', '追加、変更、削除', '追加', false, false, false); $batcsvcol->add('organization', '組織名', '半角英数', 'ADMIN', true, true, true); $batcsvcol->add('user', 'ユーザ名', '半角英数', 'user01', true, true, true); $batcsvcol->add('group', 'グループ名', '半角英数', 'GROUP01', true, true, true); $batcsvcol->add('jpname', '氏名', '全角可', '山田太郎', false, false, false); $batcsvcol->add('employee_id', '社員番号', '全角可', 'em00001', false, false, false); $batcsvcol->add('department', '部署', '全角可', '〇〇部', false, false, false); $batcsvcol->add('post', '役職', '全角可', '部長', false, false, false); $batcsvcol->add('custom_data1', '任意データ1', '全角可', '任意データ1', false, false, false); $batcsvcol->add('custom_data2', '任意データ2', '全角可', '任意データ2', false, false, false); $batcsvcol->add('custom_data3', '任意データ3', '全角可', '任意データ3', false, false, false); $batcsvcol->add('privilege', '承認権限', '0か1', '1', false, false, false); $batcsvcol->add('flow_group', '承認グループ', '全角可', 'jscom', false, false, false); $batcsvcol->add('password', 'パスワード', '半角英数', 'password', false, false, false); $batcsvcol->add('email', 'メールアドレス', '半角英数', 'mail@example.com', false, false, false); $batcsvcol->add('comment', '備考', '全角可', '備考', false, false, false); $batcsvcol->add('result', '処理結果', '自動', '変更完了', false, false, false); return $batcsvcol; } public function index(Request $request) { return view('batch.index'); } public function csv(Request $request) { $user = $this->login_user(); $rawcsv = $this->export_csv($user); $rawcsv = str_replace(PHP_EOL, "\r\n", $rawcsv); $rawcsv = mb_convert_encoding($rawcsv, 'sjis-win', 'utf-8'); $filename = 'scvusers_' . date('Ymd') . '.csv'; logger("memory_get_peak_usage : ".memory_get_peak_usage(true)); return BatchCsvManager::response_csv($filename, $rawcsv); } public function upload(Request $request) { try { $file = Request::file('file'); if ($file === null) throw new \Exception('CSVがアップロードされていません。'); if (!$file->isValid()) throw new \Exception('CSVのアップロードに失敗しました。'); $name = $file->getClientOriginalName(); if (!preg_match('/.+\.csv$/', $name)) throw new \Exception('CSVファイルを選択して下さい。'); if (CH::isCluster()) if (!CH::isMasterActive() || !CH::isSlaveAlive() || !CH::isSlaveActive()) throw new \Exception('CSV一括登録はSlaveサーバが起動している場合のみ実行できます。'); $csv_path = $file->getRealPath(); $rawcsv = file_get_contents($csv_path); $rawcsv = mb_convert_encoding($rawcsv, 'utf-8', 'sjis-win'); $login_user = $this->login_user(); $rawcsv = $this->import_csv($login_user, $rawcsv); $rawcsv = mb_convert_encoding($rawcsv, 'sjis-win', 'utf-8'); $filename = 'result_' . date('Ymd') . '.csv'; logger("csv upload by web memory_get_peak_usage : ".memory_get_peak_usage(true)); return BatchCsvManager::response_csv($filename, $rawcsv); } catch (\Exception $e) { $errmsg = $e->getMessage(); logger("csv upload by web memory_get_peak_usage : ".memory_get_peak_usage(true)); return redirect()->back()->withErrors($errmsg); } } public function export_csv($user) { $batcsvrows = []; $scvusers = Scvuser::all_permitted($user); foreach ($scvusers as $scvuser) $batcsvrows[] = $this->row_db_to_row_object($scvuser); logger("export csv memory_get_peak_usage : ".memory_get_peak_usage(true)); return $this->bcm->row_objects_to_csv($batcsvrows); } public function import_csv($user, $rawcsv, &$cntobj = null) { $sem = sem_get(config('scv.csv_sem_key')); if(!$sem){ logger('Failed to get semaphore - sem_get()'); throw new \Exception("排他制御に失敗しました"); } if(!sem_acquire($sem, true)){ throw new \Exception("CSV処理中のため実行できません"); } $cntobj = $this->cntobj; $batcsvrows = $this->bcm->csv_to_row_objects($rawcsv); $this->check_duplication($batcsvrows, true); foreach ($batcsvrows as $batcsvrow) { if ($batcsvrow->is_failed()) continue; $action = $batcsvrow->get_action_english(); $this->dispatch_job($batcsvrow, $action, $user); } foreach ($batcsvrows as $batcsvrow) $batcsvrow->password = '非表示'; logger("import csv memory_get_peak_usage : ".memory_get_peak_usage(true)); return $this->bcm->row_objects_to_csv($batcsvrows); } public function import_csv_diff($user, $rawcsv, &$cntobj = null) { $sem = sem_get(config('scv.csv_sem_key')); if(!$sem){ logger('Failed to get semaphore - sem_get()'); throw new \Exception("排他制御に失敗しました"); } if(!sem_acquire($sem, true)){ throw new \Exception("CSV処理中のため実行できません"); } $cntobj = $this->cntobj; $batcsvrows = $this->bcm->csv_to_row_objects($rawcsv); $this->check_duplication($batcsvrows, true); $diffobj = $this->extract_diff($user, $batcsvrows); if (env('APP_DEBUG')) { logger('import_csv_diff'); logger('diff_store_keys：', $diffobj->store_keys); logger('diff_update_keys：', $diffobj->update_keys); logger('diff_destroy_keys：', $diffobj->destroy_keys); } foreach ($diffobj->store_keys as $key) $this->dispatch_job($diffobj->key2row[$key], 'store', $user); foreach ($diffobj->update_keys as $key) $this->dispatch_job($diffobj->key2row[$key], 'update', $user); foreach ($diffobj->destroy_keys as $key) { $this->dispatch_job($diffobj->key2row[$key], 'destroy', $user); $batcsvrows[] = $diffobj->key2row[$key]; } foreach ($batcsvrows as $batcsvrow) $batcsvrow->password = '非表示'; logger("import csv diff memory_get_peak_usage : ".memory_get_peak_usage(true)); return $this->bcm->row_objects_to_csv($batcsvrows); } public function import_csv_diff_preview($user, $rawcsv) { $batcsvrows = $this->bcm->csv_to_row_objects($rawcsv); $this->check_duplication($batcsvrows, false); $diffobj = $this->extract_diff($user, $batcsvrows); logger("import csv diff preview memory_get_peak_usage : ".memory_get_peak_usage(true)); return (object)[ 'store' => count($diffobj->store_keys), 'update' => count($diffobj->update_keys), 'destroy' => count($diffobj->destroy_keys) ]; } public function check_duplication($batcsvrows, $counting) { $read_keys = []; foreach ($batcsvrows as $batcsvrow) { $organization = mb_strtoupper($batcsvrow->organization); $name = mb_strtolower($batcsvrow->user); $key = "{$organization}/{$name}"; if (isset($read_keys[$key])) { $batcsvrow->set_failed('重複する行があります'); if ($counting) ++$this->cntobj->failed; continue; } $read_keys[$key] = 1; } } public function extract_diff($user, $batcsvrows) { $db_map = []; $scvusers = Scvuser::all_permitted($user); foreach ($scvusers as $scvuser) { $key = "{$scvuser->organization}/{$scvuser->name}"; $db_map[$key] = $scvuser; } $csv_map = []; foreach ($batcsvrows as $batcsvrow) { if ($batcsvrow->is_failed()) continue; $organization = mb_strtoupper($batcsvrow->organization); $name = mb_strtolower($batcsvrow->user); $key = "{$organization}/{$name}"; $csv_map[$key] = $batcsvrow; } $store_keys = []; $update_keys = []; $destroy_keys = []; foreach ($csv_map as $key => $dmy) { if (isset($db_map[$key])) $update_keys[] = $key; else $store_keys[] = $key; } foreach ($db_map as $key => $scvuser) { if (isset($csv_map[$key])) continue; $destroy_keys[] = $key; $batcsvrow = $this->row_db_to_row_object($scvuser); $batcsvrows[] = $batcsvrow; $csv_map[$key] = $batcsvrow; } return (object)[ 'key2row' => $csv_map, 'store_keys' => $store_keys, 'update_keys' => $update_keys, 'destroy_keys' => $destroy_keys ]; } private function dispatch_job($batcsvrow, $action, $user) { if ($batcsvrow->is_failed()) return; if ($action === 'store') $okmsg = '追加完了'; elseif ($action === 'update') $okmsg = '変更完了'; elseif ($action === 'destroy') $okmsg = '削除完了'; else { $batcsvrow->set_failed('未処理データ'); ++$this->cntobj->ignored; return; } try { $this->validate_scvtemplate($batcsvrow); $this->validate_required($batcsvrow, $action); $this->validate_user_permission($batcsvrow, $user); $this->validate_organization_exists($batcsvrow); $this->validate_scvgroup_exists($batcsvrow, $action); $params = $this->row_object_to_job_params($batcsvrow); $errmsg = dispatch_now(new ScvuserJob($action, $params, true, $user, $this->dont_job)); if ($errmsg) throw new \Exception($errmsg); $batcsvrow->result = $okmsg; ++$this->cntobj->succeeded; } catch (\Exception $e) { $errmsg = $e->getMessage(); $batcsvrow->set_failed($errmsg); ++$this->cntobj->failed; } } private function row_db_to_row_object($scvuser) { $batcsvrow = $this->bcm->create_row_object(); $batcsvrow->organization = $scvuser->organization; $batcsvrow->user = $scvuser->name; $batcsvrow->group = $scvuser->group; $batcsvrow->jpname = $scvuser->jpname; $batcsvrow->employee_id = $scvuser->employee_id; $batcsvrow->department = $scvuser->department; $batcsvrow->post = $scvuser->post; $batcsvrow->custom_data1 = $scvuser->custom_data1; $batcsvrow->custom_data2 = $scvuser->custom_data2; $batcsvrow->custom_data3 = $scvuser->custom_data3; $batcsvrow->privilege = $scvuser->privilege; $batcsvrow->flow_group = $scvuser->flow_group; $batcsvrow->password = '非表示'; $batcsvrow->email = $scvuser->email; $batcsvrow->comment = $scvuser->comment; return $batcsvrow; } private function row_object_to_job_params($batcsvrow) { $organization = mb_strtoupper($batcsvrow->organization); $name = mb_strtolower($batcsvrow->user); $group = mb_strtoupper($batcsvrow->group); $jpname = $batcsvrow->jpname; $employee_id = $batcsvrow->employee_id; $department = $batcsvrow->department; $post = $batcsvrow->post; $custom_data1 = $batcsvrow->custom_data1; $custom_data2 = $batcsvrow->custom_data2; $custom_data3 = $batcsvrow->custom_data3; $privilege = $batcsvrow->privilege === 1 || $batcsvrow->privilege === '1' ? 1 : 0; $flow_group = $batcsvrow->flow_group; $password = $batcsvrow->password === '非表示' ? '' : $batcsvrow->password; $password_confirmation = $batcsvrow->password; $email = $batcsvrow->email; $comment = $batcsvrow->comment; return compact( 'organization', 'group', 'name', 'jpname', 'employee_id', 'department', 'post', 'custom_data1', 'custom_data2', 'custom_data3', 'privilege', 'flow_group', 'password', 'password_confirmation', 'email', 'comment' ); } private function validate_scvtemplate($batcsvrow) { if ($batcsvrow->user === 'scvtemplate') throw new \Exception('一括登録では操作できないユーザです。'); } private function validate_required($batcsvrow, $action) { if ($action === 'store') $flag_type = 'required_add'; elseif ($action === 'update') $flag_type = 'required_edit'; elseif ($action === 'destroy') $flag_type = 'required_del'; else throw new \Exception('内部エラー：無効な操作名'); $bcc = $this->bcc; $columns = $bcc->get_columns(); foreach ($columns as $column) { if ($bcc->$column->$flag_type && $batcsvrow->$column === '') throw new \Exception('必須項目未入力'); } } private function validate_organization_exists($batcsvrow) { $name = $batcsvrow->organization; $organization = Organization::where('name', $name)->first(); if ($organization === null) throw new \Exception('存在しない組織'); } private function validate_user_permission($batcsvrow, $user) { if ($user->organization === 'ADMIN') return; if ($batcsvrow->organization === $user->organization) return; throw new \Exception('異なる組織'); } private function validate_scvgroup_exists($batcsvrow, $action) { $user_name = $batcsvrow->user; $org_name = $batcsvrow->organization; $csv_group_name = $batcsvrow->group; $scvgroup = Scvgroup::with_org($org_name, $csv_group_name); if ($scvgroup === null) { throw new \Exception('存在しないグループ'); } if($action === 'destroy') { $target_user = Scvuser::with_org($org_name, $user_name); $db_group_name = Scvgroup::find($target_user->groupid)->name; if ($csv_group_name !== $db_group_name) { throw new \Exception('存在しないグループ'); } } } private function login_user() { return auth()->guard('web')->user(); } } 