<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use App\Http\Controllers\Controller; use App\Http\Requests\BrSettingRequest; use App\BrSetting; use App\VpnSetting; use App\Shareprofile; use App\Models\ProxySetting; use App\Models\ChromeSetting; use App\Models\EdgeSetting; class BrSettingController extends Controller { public function index() { $settings = BrSetting::with(['vpnSettings', 'proxySetting', 'shareprofile'])->get(); return view('br_settings.index', ['settings' => $settings]); } public function create() { $shareprofiles = Shareprofile::getShareProfileWithOrg(); $vpn_settings = VpnSetting::all(); $proxy_settings = ProxySetting::all(); $chrome_settings = ChromeSetting::all(); $edge_settings = EdgeSetting::all(); $browsers = ['Firefox' => 'Firefox', 'Chrome' => 'Chrome', 'Edge' => 'Edge']; return view('br_settings.create', compact('shareprofiles','vpn_settings','proxy_settings','chrome_settings', 'edge_settings', 'browsers')); } public function store(BrSettingRequest $request) { $param = $request->formatParameters($request->all()); BrSetting::create($param); return redirect('/scvmanager/br_settings'); } public function show($id) { $setting = BrSetting::find($id); $shareprofile = Shareprofile::getShareProfileWithOrgById($setting->shareprofile_id); return view('br_settings.show', compact('setting','shareprofile')); } public function edit($id) { $shareprofiles = Shareprofile::getShareProfileWithOrg(); $vpn_settings = VpnSetting::all(); $br_setting = BrSetting::find($id); $proxy_settings = ProxySetting::all(); $chrome_settings = ChromeSetting::all(); $edge_settings = EdgeSetting::all(); $browsers = ['Firefox' => 'Firefox', 'Chrome' => 'Chrome', 'Edge' => 'Edge']; $selected_browser = explode(',', $br_setting->available_browser); return view('br_settings.edit', compact('br_setting', 'shareprofiles', 'vpn_settings', 'proxy_settings', 'chrome_settings', 'edge_settings', 'browsers', 'selected_browser')); } public function update(BrSettingRequest $request, $id) { $param = $request->formatParameters($request->all()); $setting = BrSetting::updateSetting($param, $id); return redirect('/scvmanager/br_settings'); } public function destroy(BrSettingRequest $request, $id) { BrSetting::destroy($id); return redirect('/scvmanager/br_settings'); } } 