<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use App\Http\Controllers\Controller; use Illuminate\Validation\ValidationException; use DB; use App\Scvuser; use App\Libs\ClusterHelper as CH; use App\Libs\ConfHelper; use App\Libs\ADHelper as ADH; use App\Libs\PasswordUpdator; class EditUserPasswdController extends Controller { public function edit(Request $request, $id) { if(!ctype_digit($id)) abort(404); $scvuser = Scvuser::find($id); if(!$scvuser) abort(404); if((ADH::isScvxKerberos() || ADH::isScvxLdap()) && $scvuser->name != 'scvtemplate') abort(404); $org_id = \Auth::user()->organization_id; if($org_id !== 1){ if($scvuser->scvgroup->organization_id !== $org_id){ abort(403); } } $gauth = ConfHelper::may_be_using_gauth(); return view('edit_user_passwd.edit', compact('id', 'scvuser', 'gauth')); } public function store(Request $request) { $action = $request->input('action'); $id = $request->input('id'); $name = $request->input('name'); $pwd1 = $request->input('pwd1'); $pwd2 = $request->input('pwd2'); $tmppwd1 = is_null($request->input('tmppwd1')) ? '' : $request->input('tmppwd1'); $tmppwd2 = is_null($request->input('tmppwd2')) ? '' : $request->input('tmppwd2'); $tmppwd_term = $request->input('tmppwd_term'); $scvuser = Scvuser::find($id); $org = $scvuser->organization; $data = compact('scvuser', 'name'); $both_formed = ($pwd1 !== '' || $pwd2 !== '') && ($tmppwd1 !== '' || $tmppwd2 !== ''); if ($both_formed) return redirect()->back()->withErrors('仮パスワード、パスワード変更のいずれかの情報のみ記入してください。'); if ($action === '発行') { $response = $this->change_temp_password($scvuser, $org, $name, $tmppwd1, $tmppwd2, $tmppwd_term); } elseif ($action === '変更') { $response = $this->change_password($scvuser, $org, $name, $pwd1, $pwd2); } elseif ($action === 'Google認証の初期化') { $response = $this->reset_gauth($scvuser); } else { return redirect()->back()->withErrors('無効な操作です。'); } $slave_dbret = 0; if (CH::needsToSyncSlave()) $slave_dbret = CH::updateScvuserToSlaveDB($scvuser); CH::update_clusters_if_necessary(true, $slave_dbret); return $response; } private function change_temp_password($scvuser, $org, $name, $pwd1, $pwd2, $term) { PasswordUpdator::validate_temp_changeable($org, $name, $pwd1, $pwd2); if (!PasswordUpdator::change_temp_password($scvuser, $pwd1, $errmsg, $term)) return redirect()->back()->withInput()->withErrors($errmsg); if (CH::needsToSyncSlave()) { $slavedbret = CH::updateScvuserToSlaveDB($scvuser); CH::updateClusters(true, $slavedbret); } return redirect("scvmanager/scvusers/{$scvuser->id}")->with('success', '仮パスワードを設定しました。'); } private function change_password($scvuser, $org, $name, $pwd1, $pwd2) { PasswordUpdator::validate_changeable($org, $name, $pwd1, $pwd2, true); if (!PasswordUpdator::change_password($scvuser, $pwd1, $errmsg)) return redirect()->back()->withInput()->withErrors($errmsg); return redirect("scvmanager/scvusers/{$scvuser->id}")->with('success', 'パスワードを変更しました。'); } private function reset_gauth($scvuser) { $scvuser->gauth_used = 0; $scvuser->gauth_key = ''; $scvuser->save(); return redirect("scvmanager/scvusers/{$scvuser->id}")->with('success', 'Google認証を初期化しました。'); } } 