<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use App\Http\Requests; use App\Http\Controllers\Controller; use App\Libs\ClusterHelper as CH; use App\EmergencyMode; class EmergencyModeController extends Controller { public function index() { $current_status = "無効"; $available_count = 4; $latest_status = EmergencyMode::getLatestStatus(); $activated_data = EmergencyMode::getActivatedData(); $all_log = EmergencyMode::getEmodeLogs(); $activated_date = "0000-00-00"; $expiration_date = "0000-00-00"; if(!empty($activated_data)) { $available_count -= $activated_data; } if(!empty($latest_status) && $latest_status->status) { $current_status = "有効"; $expiration_date = EmergencyMode::getExpirationDate($latest_status->created_at); $activated_date = date("Y-m-d", strtotime($latest_status->created_at)); } return view('emergency_mode.index', compact('available_count', 'current_status', 'activated_date', 'expiration_date', 'all_log')); } public function create() { $current_status = 0; $available_count = 4; $latest_status = EmergencyMode::getLatestStatus(); $activated_data = EmergencyMode::getActivatedData(); $activated_date = "0000-00-00"; $expiration_date = "0000-00-00"; if(!empty($activated_data)) { $available_count -= $activated_data; } if(!empty($latest_status) && $latest_status->status) { $current_status = 1; $expiration_date = EmergencyMode::getExpirationDate($latest_status->created_at); $activated_date = date("Y-m-d", strtotime($latest_status->created_at)); } return view('emergency_mode.create', compact('available_count', 'current_status', 'activated_date', 'expiration_date')); } public function store(Request $request) { $latest_status = EmergencyMode::getLatestStatus(); $status = $request->status !== null ? (int)$request->status : 0; $available_count = 4; $activated_data = EmergencyMode::getActivatedData(); if(!empty($activated_data)) { $available_count -= $activated_data; } if (!empty($latest_status) && $latest_status->status && $status) { return redirect('scvmanager/emergency_mode')->withErrors('既に災害時モードが有効化されています。'); } if (empty($latest_status) && !$status || !empty($latest_status) && !$latest_status->status && !$status) { return redirect('scvmanager/emergency_mode')->withErrors('既に災害時モードが無効化されています。'); } if($available_count <= 0 && $status) { return redirect('scvmanager/emergency_mode')->withErrors('災害時モードの年内使用回数上限に達しているため、災害時用モードを有効化できません。'); } if(CH::isCluster() && CH::isSlaveAlive() && !CH::isSlaveActive()) { return redirect('scvmanager/emergency_mode')->withErrors('サーバ同期中のため災害時モードの切り替えができません、同期終了までしばらくお待ち下さい。'); } if(empty($latest_status) || $status) { if(!EmergencyMode::isExecutableEmode()) { return redirect('scvmanager/emergency_mode')->withErrors('有効なベースライセンスが登録されていないため、災害時モードを利用できません。'); } $emergency_mode = new EmergencyMode; $emergency_mode->status = $status; $emergency_mode->updated_at = "0000-00-00 00:00:00"; $dbret = $emergency_mode->save(); $slave_dbret = ""; if (!$dbret) { return redirect()->back()->withErrors('設定の保存に失敗しました。'); } if(CH::isCluster()) { if(CH::isMasterActive() && $dbret) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slave_emergency_mode = new EmergencyMode; $slave_emergency_mode->setConnection('slave_database'); $slave_emergency_mode->status = $status; $slave_emergency_mode->updated_at = "0000-00-00 00:00:00"; $slave_dbret = $slave_emergency_mode->save(); } } CH::updateClusters($dbret,$slave_dbret); } } else { $latest_status->status = $status; $dbret = $latest_status->save(); $slave_dbret = ""; if (!$dbret) { return redirect()->back()->withErrors('設定の保存に失敗しました。'); } if(CH::isCluster()) { if(CH::isMasterActive() && $dbret) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slave_emergency_mode_model = new EmergencyMode; $slave_emergency_mode_model->setConnection('slave_database'); $slave_emergency_mode = $slave_emergency_mode_model->find($latest_status->id); $slave_emergency_mode->status = $status; $slave_dbret = $slave_emergency_mode->save(); } } CH::updateClusters($dbret,$slave_dbret); } } $mode = "無効"; if($request->status) { $mode = "有効"; } return redirect('scvmanager/emergency_mode')->with('success', '災害時モードを'.$mode.'化しました。'); } } 