<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use App\Http\Controllers\Controller; use App\Scvuser; use App\Scvgroup; use App\Firefoxprofile; use App\Organization; use DB; use App\Http\Requests\FirefoxProfRequest; use App\Http\Requests\CertUploadRequest; use App\Libs\ClusterHelper as CH; use App\Libs\ADHelper; use App\Libs\UserHelper as UH; class FirefoxProfController extends Controller { const ADMIN_ORG = 1; public function index() { \Session::flash('init','init'); if (\Auth::user()->organization_id === self::ADMIN_ORG) { $firefoxprofs = Firefoxprofile::getFirefoxprofileWithOrg(); } else { $firefoxprofs = Firefoxprofile::getFirefoxprofileWithOrgByOrgId(\Auth::user()->organization_id); } return view('firefoxprof.index', compact('firefoxprofs')); } public function create() { $firefoxprofs = Firefoxprofile::all(); if (\Auth::user()->organization_id === self::ADMIN_ORG) { $organizations = Organization::all(); } else { $organizations = Organization::find(\Auth::user()->organization_id); } return view('firefoxprof.create', compact('firefoxprofs', 'organizations')); } public function store(FirefoxProfRequest $request) { FirefoxProfile::create($request->all()); return redirect()->to('/scvmanager/firefoxprof'); } public function show($id) { $firefoxprof = Firefoxprofile::find($id); if($firefoxprof->organization_id !== \Auth::user()->organization_id && \Auth::user()->organization_id !== self::ADMIN_ORG) { abort(403); } $organization_name = Organization::find($firefoxprof->organization_id)->name; if(!isset($firefoxprof)){ abort(404); } $path = "/var/www/html/scv/scvtemplates/".$organization_name."/".$firefoxprof->name."/firefoxprof"; if (file_exists($path)) { $template_exists = 1; } else { $template_exists = 0; } return view('firefoxprof.show', compact('firefoxprof', 'template_exists', 'organization_name')); } public function edit($id) { $firefoxprof = Firefoxprofile::find($id); if($firefoxprof->organization_id !== \Auth::user()->organization_id && \Auth::user()->organization_id !== self::ADMIN_ORG) { abort(403); } if(isset($firefoxprof)){ $path = "/var/www/html/scv/scvtemplates/".$firefoxprof->name; if(!file_exists($path."/user.js")){ } if(!file_exists($path."/chrome/userChrome.css")){ } if(!file_exists($path."/chrome/userContent.css")){ } if (\Auth::user()->organization_id === self::ADMIN_ORG) { $organizations = Organization::all(); } else { $organizations = Organization::find($firefoxprof->organization_id); } return view('firefoxprof.edit', compact('firefoxprof', 'organizations')); }else{ \Session::flash('flash_msg', '<p><span style="color:red">プロファイルが見つかりませんでした。</span></p>'); $firefoxprofs = Firefoxprofile::all(); return view('firefoxprof.index', ['firefoxprofs' => $firefoxprofs]); } } public function update(FirefoxProfRequest $request) { Firefoxprofile::updateSetting($request->all(), $request->id); return redirect()->to('/scvmanager/firefoxprof'); } public function destroy(FirefoxProfRequest $request) { Firefoxprofile::destroy($request->id); return redirect()->to('/scvmanager/firefoxprof'); } public function certShow($id){ $firefoxprof = Firefoxprofile::find($id); if($firefoxprof->organization_id !== \Auth::user()->organization_id && \Auth::user()->organization_id !== self::ADMIN_ORG) { abort(403); } $organization_name = Organization::find($firefoxprof->organization_id)->name; $files = Firefoxprofile::certData($firefoxprof->name, $organization_name); return view('firefoxprof.cert_show', compact('firefoxprof', 'files')); } public function certSave(CertUploadRequest $request) { $firefoxprof = Firefoxprofile::find($request->id); if($firefoxprof->organization_id != \Auth::user()->organization_id && \Auth::user()->organization_id !== self::ADMIN_ORG) { abort(403); } $organization_name = Organization::find($firefoxprof->organization_id)->name; Firefoxprofile::certSave($firefoxprof, $organization_name, $request->file, $request->password); return redirect()->back(); } public function certDelete(Request $request) { $firefoxprof = Firefoxprofile::getFirefoxprofileAndOrgByName($request->prof_name, $request->organization_id); if($request->organization_id != \Auth::user()->organization_id && \Auth::user()->organization_id !== self::ADMIN_ORG) { abort(403); } Firefoxprofile::certDelete($request->fn, $firefoxprof->name, $firefoxprof->organization_name); return redirect()->back(); } }