<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use App\Http\Controllers\Controller; use App\Http\Requests\LdapSettingRequest; use App\Models\LdapSetting; use App\Scvgroup; use App\Exceptions\LdapException; use App\Libs\ADHelper; use App\Libs\LdapImportHelper; use App\Libs\UserHelper; use App\Organization; use Carbon\Carbon; use Illuminate\Support\Facades\Auth; class LdapSettingController extends Controller { public function index() { if (!ADHelper::canLdapSettings()) { abort(403); } if (UserHelper::isAdmin()) { $ldaps = LdapSetting::all(); $canCreate = !LdapSetting::isAllOrgsUsed(); } else { $orgId = Auth::user()->organization_id; $ldaps = LdapSetting::listByOrganizationId($orgId); $canCreate = (count($ldaps) == 0); } return view('scvusers.ldaps.index', ['ldaps' => $ldaps, 'can_create' => $canCreate]); } public function create() { return $this->edit(null); } public function store(LdapSettingRequest $request) { if (!ADHelper::canLdapSettings()) { abort(403); } $ldap = new LdapSetting(); $ldap->fill($request->all()); LdapSetting::create($ldap->toArray()); return redirect()->to("/scvmanager/scvusers/ldaps"); } public function show($id) { if (!ADHelper::canLdapSettings()) { abort(403); } $ldap = LdapSetting::find($id); if (!$ldap) { $ldap = new LdapSetting(); } else { $ldap = LdapSetting::find($id); } return view('scvusers.ldaps.show', ['ldap' => $ldap]); } public function edit($id) { if (!ADHelper::canLdapSettings()) { abort(403); } if (UserHelper::isAdmin()) { $orgs = Organization::all(); $selectableOrgs = LdapSetting::listSelectableOrgIds($id); $groups = Scvgroup::all(); } else { $orgId = Auth::user()->organization_id; $orgs = [Organization::find($orgId)]; $selectableOrgs = [$orgId]; $groups = Scvgroup::listGroupsByOrgId($orgId); } if (is_null($id)) { $ldap = new LdapSetting(); $ldap->applyDefault(); } else { $ldap = LdapSetting::find($id); } return view('scvusers.ldaps.edit', ['ldap' => $ldap, 'orgs' => $orgs, 'groups' => $groups, 'selectableOrgs' => $selectableOrgs]); } public function update(LdapSettingRequest $request, $id) { if (!ADHelper::canLdapSettings()) { abort(403); } $ldap = LdapSetting::find($id); if (!$ldap) { return $this->store($request); } $ldap->fill($request->all()); LdapSetting::updateLdapSetting($ldap->toArray(), $ldap->id); return redirect()->to("/scvmanager/scvusers/ldaps"); } public function destroy($id) { if (!ADHelper::canLdapSettings()) { abort(403); } $cnt = LdapSetting::destroy($id); if ($cnt < 1) { throw new LdapException('削除に失敗しました'); } return $this->index(); } public function ldapSearch(Request $request) { if (!ADHelper::canLdapSettings()) { abort(403); } $ldapid = $request->id; try { $ldap_setting = LdapSetting::find($ldapid); list($adduser, $deluser) = LdapImportHelper::matchLdapScvuser($ldap_setting); } catch (LdapException $e) { return redirect()->back()->with('err', $e->message); } session()->put('ldap_setting', $ldap_setting); session()->put('adduser', $adduser); session()->put('deluser', $deluser); session()->put('searched_at', Carbon::now()); return view('scvusers.ldaps.ldapsearch', ['adduser' => $adduser, 'deluser' => $deluser, 'ldapid' => $ldapid]); } public function ldapStore(Request $request) { if (!ADHelper::canLdapSettings()) { abort(403); } $sem = sem_get(config('scv.csv_sem_key')); if (!$sem) { logger('Failed to get semaphore - sem_get()'); $this->error("排他制御に失敗しました"); return; } if (!sem_acquire($sem, true)) { $this->error("CSV処理中のため実行できません"); return; } $ldap_setting = session()->get('ldap_setting'); $adduser = session()->get('adduser'); $deluser = session()->get('deluser'); $searched_at = session()->get('searched_at'); list($logFilePath, $logerr) = LdapImportHelper::getLogFilePath(); LdapImportHelper::synchronizeLdapScvusers($ldap_setting, $adduser, $deluser, $searched_at, $logFilePath); $to = redirect()->to("/scvmanager/scvusers/ldaps/" . $request->id); if (is_null($logerr)) { return $to->with("success", "登録が完了しました。"); } else { return $to->with("err", $logerr); } } } 