<?php
 namespace App\Http\Controllers; use App\Http\Requests\LicenseRequest; use App\Http\Requests; use App\Http\Controllers\Controller; use App\EmergencyMode; use App\Libs\ClusterHelper as CH; class LicenseController extends Controller { const SCVX_LABEL = "SCVX SECURE BROWSER"; const EXT_LABEL = "SCVX EXTENTION"; const STZ_LABEL = "SCVX SANITIZER"; const TCK_LABEL = "SCVX THREAT CHECKER"; const VCK_LABEL = "SCVX VIRUS CHECKER"; const REVOBR_LABEL = "REVOWORKS BROWSER"; const REVODT_LABEL = "REVOWORKS DESKTOP"; const RSTZ_LABEL = "REVOWORKS SANITIZER"; const RTCK_LABEL = "REVOWORKS THREAT CHECKER"; const RVCK_LABEL = "REVOWORKS VIRUS CHECKER"; const PPU_STZ_LABEL = "SANITIZER"; const PPU_VTC_LABEL = "VIRUS THREAT CHECKER"; const LICENSE_PATH = "/var/www/html/scv/scvlicense/run"; public function index() { return view('license.index'); } public function getList() { return view('license.list', ['licenses' => $this->getLicenses()]); } public function upload(LicenseRequest $request) { $files = $request->file('license'); $lics = $this->getLicenses(); $return_array = array(); for ($i=0,$len=count($files); $i < $len; $i++) { $obj = $this->fileToObject($files[$i]); $_ = function($s){return $s;}; $is_optlic = !startsWith($obj->name, self::SCVX_LABEL) && !startsWith($obj->name, self::REVOBR_LABEL) && !startsWith($obj->name, self::REVODT_LABEL); if($is_optlic && !$this->baseExists($obj, $lics)){ $return_array[] = "<p style=\"color:red\">ベースライセンスがインストールされていません。先に{$_(self::SCVX_LABEL)}または{$_(self::REVOBR_LABEL)}、{$_(self::REVODT_LABEL)}ライセンスをインストールして下さい。</p>"; return view('license.index', ['return_array' => $return_array]); } $is_tcklic = $obj->name == self::TCK_LABEL || startsWith($obj->name, self::RTCK_LABEL); if($is_tcklic && !$this->vckExists($obj, $lics)){ $return_array[] = "<p style=\"color:red\">{$_(self::VCK_LABEL)}または{$_(self::RVCK_LABEL)}ライセンスがインストールされていません。先に{$_(self::VCK_LABEL)}または{$_(self::RVCK_LABEL)}ライセンスをインストールして下さい。</p>"; return view('license.index', ['return_array' => $return_array]); } if($this->isInValid($files[$i])){ $return_array[] = '<p style="color:red">'.$files[$i]->getClientOriginalName()." : 無効なライセンス</p>"; unset($files[$i]); continue; } if($this->isDuplicate($obj, $lics)){ $return_array[] = '<p style="color:red">'.$files[$i]->getClientOriginalName()." : インストール済みのライセンス</p>"; unset($files[$i]); continue; } } $path = self::LICENSE_PATH; foreach ($files as $file) { $fn = $this->generateFileName($file); $ret = $file->move($path, $fn); $return_array[] = '<p class="text-success">'.$file->getClientOriginalName()." : アップロード完了</p>"; } $this->relocateLicense(); exec("chown -R www-data:docker $path"); exec("scvlicense -load"); $milli_time = floor(microtime(true) * 1000); \DB::table('clusters')->lockForUpdate()->where('role','MASTER')->update(['tpl_updatemill' => $milli_time]); return view('license.index', ['return_array' => $return_array]); } public function delete(LicenseRequest $request){ $serial = $request->input('serial'); $licenses = $this->getLicenses(); $target; foreach($licenses as $l){ if($l->serial == $serial){ $target = $l; } } unlink($target->file_name); $this->relocateLicense(); $path = self::LICENSE_PATH; exec("chown -R www-data:docker $path"); exec("scvlicense -load"); $milli_time = floor(microtime(true) * 1000); \DB::table('clusters')->lockForUpdate()->where('role','MASTER')->update(['tpl_updatemill' => $milli_time]); $emode_status = EmergencyMode::getLatestStatus(); $emode_executable = EmergencyMode::isExecutableEmode(); if(!empty($emode_status) && $emode_status->status && !$emode_executable) { $emode_status->status = false; $dbret = $emode_status->save(); logger("Emergency mode has been disabled because the license does not exist "); $slave_dbret = ''; if(CH::isCluster()) { if(CH::isMasterActive() && $dbret) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slave_emergency_mode_model = new EmergencyMode; $slave_emergency_mode_model->setConnection('slave_database'); $slave_emode = $slave_emergency_mode_model->find($emode_status->id); $slave_emode->status = false; $slave_dbret = $slave_emode->save(); logger("Slave emergency mode has been disabled because the license does not exist "); } } CH::updateClusters($dbret, $slave_dbret); } } return redirect('/scvmanager/scvxlicense/list'); } private function relocateLicense(){ $this->renameLicense("base"); $this->renameLicense("ext"); $this->renameLicense("stz"); $this->renameLicense("vck"); $this->renameLicense("tck"); $this->renameLicense("vtc"); } private function renameLicense($type){ $path = self::LICENSE_PATH; if($type == "base"){ $file_path = $path.'/license.*'; }else{ $file_path = $path."/license_$type.*"; } $ret = glob($file_path); $sort = array(); foreach ($ret as $line) { preg_match("/.+?([0-9]+)$/", $line, $m); $sort[$m[1]] = $m[0]; } ksort($sort); if($type == "base"){ $cnt = 0; foreach ($sort as $line) { rename($line,$path."/license.".($cnt+1)); $cnt++; } }else{ $cnt = 0; foreach ($sort as $line) { rename($line,$path."/license_$type.".($cnt+1)); $cnt++; } } } private function getLicenses() { $path = self::LICENSE_PATH; $files = glob($path."/license*"); $objects = array(); foreach ($files as $file) { $objects[] = $this->fileToObject($file); } return $objects; } private function fileToObject($file) { $lines = file($file); if(strpos($this->getValue($lines[2]),'PPU') !== false){ $lic_array = array( 'name' => $this->getValue($lines[0]), 'serial' => $this->getValue($lines[1]), 'type' => $this->getValue($lines[2]), 'cores' => "0", 'company' => $this->getValue($lines[3]), 'date' => $this->getValue($lines[4]), 'expiration' => $this->getValue($lines[5]), 'license_key'=> $this->getValue($lines[6]), 'file_name' => $file ); }else{ $lic_array = array( 'name' => $this->getValue($lines[0]), 'serial' => $this->getValue($lines[1]), 'type' => $this->getValue($lines[2]), 'cores' => $this->getValue($lines[3]), 'company' => $this->getValue($lines[4]), 'date' => $this->getValue($lines[5]), 'expiration' => $this->getValue($lines[6]), 'license_key'=> $this->getValue($lines[7]), 'file_name' => $file ); } return (object)$lic_array; } private function getValue($line) { $line = str_replace(PHP_EOL, '', $line); $eq = strpos($line, '='); $key = substr($line, 0, $eq); $value = substr($line, $eq + 1); return $value; } private function isDuplicate($obj, $lics) { foreach ($lics as $lic) { if($obj->serial == $lic->serial){ return true; } } return false; } private function isInValid($file) { $p = $file->getRealPath(); $r = exec("scvlicense -check $p"); return strpos($r,"STAT:LIC_OK") === false; } private function isMatchCores($obj, $lics) { foreach ($lics as $lic) { if($lic->name == self::SCVX_LABEL && $lic->cores == $obj->cores){ return true; } } return false; } private function baseExists($obj, $lics) { foreach ($lics as $lic) { if(startsWith($lic->name, self::SCVX_LABEL) || startsWith($lic->name, self::REVOBR_LABEL) || startsWith($lic->name, self::REVODT_LABEL)){ return true; } } return false; } private function vckExists($obj, $lics) { foreach ($lics as $lic) { if($lic->name == self::VCK_LABEL || startsWith($lic->name, self::RVCK_LABEL)){ return true; } } return false; } private function generateFileName($file) { $path = self::LICENSE_PATH; $obj = $this->fileToObject($file); $is_baselic = startsWith($obj->name, self::SCVX_LABEL) || startsWith($obj->name, self::REVOBR_LABEL) || startsWith($obj->name, self::REVODT_LABEL); $is_extlic = $obj->name == self::EXT_LABEL; $is_stzlic = $obj->name == self::STZ_LABEL || startsWith($obj->name, self::RSTZ_LABEL) || startsWith($obj->name, self::PPU_STZ_LABEL); $is_tcklic = $obj->name == self::TCK_LABEL || startsWith($obj->name, self::RTCK_LABEL); $is_vcllic = $obj->name == self::VCK_LABEL || startsWith($obj->name, self::RVCK_LABEL); $is_vtclic = $obj->name == self::PPU_VTC_LABEL; if ($is_baselic) return "license.".(count(glob($path.'/license.*')) + 1); elseif ($is_extlic) return "license_ext.".(count(glob($path.'/license_ext.*')) + 1); elseif ($is_stzlic) return "license_stz.".(count(glob($path.'/license_stz.*')) + 1); elseif ($is_tcklic) return "license_tck.".(count(glob($path.'/license_tck.*')) + 1); elseif ($is_vcllic) return "license_vck.".(count(glob($path.'/license_vck.*')) + 1); elseif($is_vtclic) return "license_vtc.".(count(glob($path.'/license_vtc.*')) + 1); } } function startsWith($haystack, $needle) { return strpos($haystack, $needle) === 0; } 