<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use App\Http\Requests; use App\Http\Controllers\Controller; use DB; use App\Libs\UserHelper as UH; use App\Libs\ConfHelper; use App\Clientlog; use App\Filelog; use App\ScvflowLog; use App\revobr\Updaterlog; class LogSearchController extends Controller { use \App\Traits\DateManager; private function init_keyword(&$keyword) { if (\Request::input('keyword') === null) { $keyword = ''; } else { $keyword = \Request::input('keyword'); } } public function logindex(Request $request) { $this->init_date($start_date, $end_date, '1day_ago'); $this->init_keyword($keyword); $clientlogs = $this->query_clientlogs(0); return view('logsearch.show', compact( 'clientlogs', 'start_date', 'end_date', 'keyword' )); } public function logsearch(Request $request) { $this->init_date($start_date, $end_date, '1day_ago'); $this->init_keyword($keyword); $web_flg = $request->input('download') === null; $clientlogs = $this->query_clientlogs(-1, $start_date, $end_date, $keyword); $cnt = $clientlogs->count(); if ($cnt === 0) { \Session::flash('flash_msg', '該当するデータがありません。'); } else if ($cnt > 10000) { \Session::flash('flash_msg', '検索結果が多すぎます。絞り込んで検索してください。'); } if ($web_flg) { return view('logsearch.show', compact( 'clientlogs', 'start_date', 'end_date', 'keyword' )); } else { return $this->download_csv_from_records($clientlogs, 'client_log_'); } } public function filelogindex(Request $request) { $this->init_date($start_date, $end_date, '1day_ago'); $this->init_keyword($keyword); $filelogs = $this->query_filelogs(0); $flow_available = $this->is_flow_availavle(); return view('logsearch.filelog', compact( 'filelogs', 'start_date', 'end_date', 'keyword', 'flow_available' )); } public function filelogsearch(Request $request) { $this->init_date($start_date, $end_date, '1day_ago'); $this->init_keyword($keyword); $web_flg = $request->input('download') === null; $filelogs = $this->query_filelogs(-1, $start_date, $end_date, $keyword); $flow_available = $this->is_flow_availavle(); $cnt = $filelogs->count(); if ($cnt === 0) { \Session::flash('flash_msg', '該当するデータがありません。'); } else if ($cnt > 10000) { \Session::flash('flash_msg', '検索結果が多すぎます。絞り込んで検索してください。'); } if ($web_flg) { return view('logsearch.filelog', compact( 'filelogs', 'start_date', 'end_date', 'keyword', 'flow_available' )); } else { return $this->download_csv_from_records($filelogs, 'file_log_'); } } private function is_flow_availavle() { $flow = ConfHelper::scvconf('SCV_FLOW'); return $flow >= 1 && $flow <= 4; } private function query_clientlogs($limit = -1, $start_date = '', $end_date = '', $keyword = '') { $query = DB::table('clientlogs'); if ($start_date && $end_date) { $query->where('created_at', '>', $start_date) ->where('created_at', '<', $end_date); } if ($keyword) { $keyword = "%{$keyword}%"; $query->where(function($query) use($keyword) { $query->where('scvuser', 'like', $keyword) ->orWhere('statmsg', 'like', $keyword) ->orWhere('hostname', 'like', $keyword); }); } if ($limit >= 0) { $query->limit($limit); } return $query->orderBy('created_at', 'asc') ->get(); } private function query_filelogs($limit = -1, $start_date = '', $end_date = '', $keyword = '') { $query = DB::table('filelogs') ->leftJoin('scvflow_logs', 'filelogs.scvflow_id', '=', 'scvflow_logs.id'); if ($start_date && $end_date) { $query->where(function($query) use($start_date, $end_date) { $query->where(function($query) use($start_date, $end_date) { $query->where('created_at', '>', $start_date) ->where('created_at', '<', $end_date); }) ->orWhere(function($query) use($start_date, $end_date) { $query->where('requested_at', '>', $start_date) ->where('requested_at', '<', $end_date); }); }); } if ($keyword) { $keyword = "%{$keyword}%"; $query->where(function($query) use($keyword) { $query->where('filelogs.filename', 'like', $keyword) ->orWhere('scvuser', 'like', $keyword) ->orWhere('operation', 'like', $keyword) ->orWhere('scvflow_logs.filename', 'like', $keyword) ->orWhere('scvflow_logs.comment', 'like', $keyword) ->orWhere('scvflow_logs.why_denied', 'like', $keyword) ->orWhere('scvflow_logs.applicant_summary', 'like', $keyword) ->orWhere('scvflow_logs.authorizer_summary', 'like', $keyword) ->orWhere('scvflow_logs.applicant_user', 'like', $keyword); }); } $query->select([ 'filelogs.*', 'scvflow_logs.*', 'filelogs.id                 as     filelogs_id', 'filelogs.filename           as     filelogs_filename', 'scvflow_logs.filename       as scvflow_logs_filename', 'filelogs.src_filesize       as     filelogs_filesize', 'scvflow_logs.filesize       as scvflow_logs_filesize', 'filelogs.comment            as     filelogs_comment', 'scvflow_logs.comment        as scvflow_logs_comment', 'filelogs.status             as     filelogs_status', 'scvflow_logs.status         as scvflow_logs_status', 'filelogs.organization_name  as     filelogs_organization', 'scvflow_logs.organization   as scvflow_logs_organization', 'filelogs.scvuser            as     filelogs_user', 'scvflow_logs.applicant_user as scvflow_logs_user', 'filelogs.ipaddress          as     filelogs_ipaddress', 'scvflow_logs.applicant_ip   as scvflow_logs_ipaddress' ]); if ($limit >= 0) $query->limit($limit); $query->orderBy('created_at', 'asc'); $records = $query->get(); foreach ($records as $record) { $record->id = $record->filelogs_id; $record->filename = $record->filelogs_filename; $record->comment = $record->filelogs_comment; $record->status = $record->filelogs_status; if ($record->action_type == 'upload') { $record->action_type = 'アップロード'; } else if ($record->action_type == 'download') { $record->action_type = 'ダウンロード'; } else { $record->action_type = '不明'; } } return $records; } private function download_csv_from_records($records, $filename_prefix) { if ($records->count() === 0) return back()->with('flash_msg', '該当するデータがありません。'); $fp = fopen('php://temp','w'); $keys = []; foreach ($records[0] as $key => $value) { if ($key === 'filelogs_id') continue; $keys[] = $key; } fputcsv($fp, $keys); foreach ($records as $key => $value) { if ($key === 'filelogs_id') continue; $values = []; foreach ($value as $key => $value) { if ($key === 'filelogs_id') continue; $values[] = $value; } fputcsv($fp, $values); } rewind($fp); $csv = stream_get_contents($fp); $csv = str_replace(PHP_EOL, "\r\n", $csv); $csv = mb_convert_encoding($csv, 'SJIS', 'UTF-8'); fclose($fp); $filename = $filename_prefix . date('Ymd') . '.csv'; return \Response::make($csv, 200, [ 'Content-Type' => 'text/csv', 'Content-Disposition' => 'attachment; filename="' . $filename . '"' ]); } public function updaterlogIndex() { return view('logsearch.updaterlog'); } public function updaterlogSearch(Request $request) { $start = $request->input('start_date'); $end = $request->input('end_date'); $keyword = $request->input('keyword'); $ret = Updaterlog::likeSearch($start, $end, $keyword)->get(); return view('logsearch.updaterlog', ['updaterlogs' => $ret]); } public function updaterlogCsv(Request $request) { $start = $request->input('start_date'); $end = $request->input('end_date'); $keyword = $request->input('keyword'); $ret = Updaterlog::likeSearch($start, $end, $keyword)->get()->toArray(); $ret = collect($ret); return $this->download_csv_from_records($ret, 'updater_log_'); } } 