<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use App\Http\Requests\OrganizationRequest; use App\Http\Controllers\Controller; use App\Organization; use App\Scvgroup; use App\Scvuser; use App\Libs\ConfHelper; use App\Libs\ClusterHelper as CH; use App\Libs\UserHelper as UH; use App\Jobs\ScvuserJob; class OrganizationController extends Controller { private $pwd_length_max = 32; private $pwd_generation_limit_max = 24; public function index(OrganizationRequest $request) { if (UH::isAdmin()) $organizations = Organization::paginate(50); else { abort(403); } $is_admin = UH::isAdmin(); return view('organization.index', compact('organizations', 'is_admin')); } public function create(OrganizationRequest $request) { if (!UH::isAdmin()) abort(403); $organization = new Organization; $pwd_length_max = $this->pwd_length_max; $pwd_generation_limit_max = $this->pwd_generation_limit_max; return view('organization.create', compact('organization', 'pwd_length_max', 'pwd_generation_limit_max')); } public function store(OrganizationRequest $request) { if (!UH::isAdmin()) abort(403); $pwd_length = $request->input('pwd_length'); $pwd_min_term = $request->input('pwd_min_term'); $pwd_max_term = $request->input('pwd_max_term'); $pwd_generation_limit = $request->input('pwd_generation_limit'); $pwd_warning_term = $request->input('pwd_warning_term'); $pwd_complexity = $request->input('pwd_complexity'); $pwd_ngwords = $request->input('pwd_ngwords'); $lockout_threshold = $request->input('lockout_threshold'); $enable_stz = $request->input('enable_stz'); $enable_vck = $request->input('enable_vck'); $enable_tck = $request->input('enable_tck'); $organization = new Organization; $organization->name = mb_strtoupper($request->input('name')); $organization->max_limit = $request->input('max_limit'); $organization->comment = $request->input('comment'); $organization->pwd_length = $pwd_length !== null ? $pwd_length : 4; $organization->pwd_min_term = $pwd_min_term !== null ? $pwd_min_term : 0; $organization->pwd_max_term = $pwd_max_term !== null ? $pwd_max_term : 0; $organization->pwd_generation_limit = $pwd_generation_limit !== null ? $pwd_generation_limit : 0; $organization->pwd_warning_term = $pwd_warning_term !== null ? $pwd_warning_term : 0; $organization->pwd_complexity = $pwd_complexity !== null ? (int)$pwd_complexity : 0; $organization->pwd_ngwords = $pwd_ngwords !== null ? $pwd_ngwords : ''; $organization->lockout_threshold = $lockout_threshold !== null ? $lockout_threshold : 0 ; $organization->enable_stz = $enable_stz ?: 0; $organization->enable_vck = $enable_vck ?: 0; $organization->enable_tck = $enable_tck ?: 0; $dbret = $organization->save(); $slavedbret = 0; if (CH::needsToSyncSlave()) { $slaveorg = new Organization; $slaveorg->setConnection('slave_database'); $slaveorg->id = $organization->id; $slaveorg->name = $organization->name; $slaveorg->max_limit = $organization->max_limit; $slaveorg->comment = $organization->comment; $slaveorg->pwd_length = $organization->pwd_length; $slaveorg->pwd_min_term = $organization->pwd_min_term; $slaveorg->pwd_max_term = $organization->pwd_max_term; $slaveorg->pwd_generation_limit = $organization->pwd_generation_limit; $slaveorg->pwd_warning_term = $organization->pwd_warning_term; $slaveorg->pwd_complexity = $organization->pwd_complexity; $slaveorg->pwd_ngwords = $organization->pwd_ngwords; $slaveorg->lockout_threshold = $organization->lockout_threshold; $slaveorg->enable_stz = $organization->enable_stz; $slaveorg->enable_vck = $organization->enable_vck; $slaveorg->enable_tck = $organization->enable_tck; $slavedbret = $slaveorg->save(); } CH::updateClusters($dbret, $slavedbret); if(empty(Scvgroup::with_org($organization->name, 'SCVTEMPLATE'))) { $scvgroup = new Scvgroup; $data = [ 'name' => 'SCVTEMPLATE', 'organization_id' => $organization->id, 'hour' => '00:00-24:00', 'enable' => 1, 'applist' => 'firefox', 'runmode' => 'SINGLE', 'image' => 'DEFAULT', 'dayofweek' => 'SUN,MON,TUE,WED,THU,FRI,SAT', 'copypaste' => 1, 'firefoxsave' => 1, 'comment' => 'プロファイル作成用グループ', 'scvpriority' => 'NORMAL' ]; $dbret = $scvgroup->fill($data)->save(); if(CH::isCluster()) { $slave_dbret = false; if(CH::isSlaveActive()) { $slave_dbret = Scvgroup::on('slave_database')->create($data); } CH::updateClusters($dbret, $slave_dbret); } } if(empty(Scvuser::with_org($organization->name, 'SCVTEMPLATE'))) { $template_group = Scvgroup::with_org($organization->name, 'SCVTEMPLATE'); $scvuser = new Scvuser; $data = [ 'name' => 'scvtemplate', 'password' => 'scvtemplate', 'password_confirmation' => 'scvtemplate', 'group' => $template_group->name, 'organization' => $organization->name ]; dispatch_now(new ScvuserJob("store", $data)); } return redirect()->route('organization.index'); } public function show(OrganizationRequest $request, $name) { $active_auth = ConfHelper::active_auth(); $organization = Organization::where('name', $name)->first(); $is_admin = UH::isAdmin(); $this->abort_ifnot_exists($organization); if (!$is_admin) $this->abort_ifnot_mine($organization); return view('organization.show', compact('organization', 'active_auth', 'is_admin')); } public function edit(OrganizationRequest $request, $name) { $organization = Organization::where('name', $name)->first(); $this->abort_ifnot_exists($organization); if (!UH::isAdmin()) $this->abort_ifnot_mine($organization); $is_admin = UH::isAdmin(); $pwd_length_max = $this->pwd_length_max; $pwd_generation_limit_max = $this->pwd_generation_limit_max; return view('organization.edit', compact('organization', 'pwd_length_max', 'pwd_generation_limit_max', 'is_admin')); } public function update(OrganizationRequest $request, $name) { $organization = Organization::where('name', $name)->first(); $this->abort_ifnot_exists($organization); if (!UH::isAdmin()) $this->abort_ifnot_mine($organization); $input_name = mb_strtoupper($request->input('name')); if ($name === 'ADMIN' && $input_name !== 'ADMIN') return back()->with('flash_msg', 'ADMIN組織の名前を変更することはできません'); $reset = $organization->pwd_max_term != $request->input('pwd_max_term'); if (UH::isAdmin()) { $organization->name = $input_name; $organization->max_limit = $request->input('max_limit'); $organization->comment = $request->input('comment'); $organization->enable_stz = $request->input('enable_stz') ?: 0; $organization->enable_vck = $request->input('enable_vck') ?: 0; $organization->enable_tck = $request->input('enable_tck') ?: 0; } $pwd_length = $request->input('pwd_length'); $pwd_min_term = $request->input('pwd_min_term'); $pwd_max_term = $request->input('pwd_max_term'); $pwd_generation_limit = $request->input('pwd_generation_limit'); $pwd_warning_term = $request->input('pwd_warning_term'); $pwd_complexity = $request->input('pwd_complexity'); $pwd_ngwords = $request->input('pwd_ngwords'); $lockout_threshold = $request->input('lockout_threshold'); $enable_stz = $request->input('enable_stz'); $enable_vck = $request->input('enable_vck'); $enable_tck = $request->input('enable_tck'); $organization->pwd_length = $pwd_length !== null ? $pwd_length : 4; $organization->pwd_min_term = $pwd_min_term !== null ? $pwd_min_term : 0; $organization->pwd_max_term = $pwd_max_term !== null ? $pwd_max_term : 0; $organization->pwd_generation_limit = $pwd_generation_limit !== null ? $pwd_generation_limit : 0; $organization->pwd_warning_term = $pwd_warning_term !== null ? $pwd_warning_term : 0; $organization->pwd_complexity = $pwd_complexity !== null ? (int)$pwd_complexity : 0; $organization->pwd_ngwords = $pwd_ngwords !== null ? $pwd_ngwords : ''; $organization->lockout_threshold = $lockout_threshold !== null ? $lockout_threshold : 0 ; $dbret = $organization->save(); if ($reset) Scvuser::join('scvgroups', 'scvusers.groupid', 'scvgroups.id') ->join('organizations', 'scvgroups.organization_id', 'organizations.id') ->getQuery() ->where('organizations.name', $name) ->update(['pwd_reset_at' => '0000-00-00 00:00:00']); $slavedbret = 0; if (CH::needsToSyncSlave()) { $slavemodel = new Organization; $slavemodel->setConnection('slave_database'); $slaveorg = $slavemodel->find($organization->id); $slaveorg->name = $organization->name; $slaveorg->max_limit = $organization->max_limit; $slaveorg->authentication = $organization->authentication; $slaveorg->comment = $organization->comment; $slaveorg->pwd_length = $organization->pwd_length; $slaveorg->pwd_min_term = $organization->pwd_min_term; $slaveorg->pwd_max_term = $organization->pwd_max_term; $slaveorg->pwd_generation_limit = $organization->pwd_generation_limit; $slaveorg->pwd_warning_term = $organization->pwd_warning_term; $slaveorg->pwd_complexity = $organization->pwd_complexity; $slaveorg->pwd_ngwords = $organization->pwd_ngwords; $slaveorg->lockout_threshold = $organization->lockout_threshold; $slaveorg->enable_stz = $organization->enable_stz; $slaveorg->enable_vck = $organization->enable_vck; $slaveorg->enable_tck = $organization->enable_tck; $slavedbret = $slaveorg->save(); if ($reset) { $scvusers = Scvuser::join('scvgroups', 'scvusers.groupid', 'scvgroups.id') ->join('organizations', 'scvgroups.organization_id', 'organizations.id') ->where('organizations.name', $name) ->select('scvusers.id as scvuser_id') ->get(); foreach ($scvusers as $scvuser) { $slavemodel = new Scvuser; $slavemodel->setConnection('slave_database'); $slaveuser = $slavemodel->find($scvuser->scvuser_id); $slaveuser->pwd_reset_at = '0000-00-00 00:00:00'; $slaveuser->save(); } } } CH::updateClusters($dbret, $slavedbret); if(empty(Scvgroup::with_org($organization->name, 'SCVTEMPLATE'))) { $scvgroup = new Scvgroup; $data = [ 'name' => 'SCVTEMPLATE', 'organization_id' => $organization->id, 'hour' => '00:00-24:00', 'enable' => 1, 'applist' => 'firefox', 'runmode' => 'SINGLE', 'image' => 'DEFAULT', 'dayofweek' => 'SUN,MON,TUE,WED,THU,FRI,SAT', 'copypaste' => 1, 'firefoxsave' => 1, 'comment' => 'プロファイル作成用グループ', 'scvpriority' => 'NORMAL' ]; $dbret = $scvgroup->fill($data)->save(); if(CH::isCluster()) { $slave_dbret = false; if(CH::isSlaveActive()) { $slave_dbret = Scvgroup::on('slave_database')->create($data); } CH::updateClusters($dbret, $slave_dbret); } } if(empty(Scvuser::with_org($organization->name, 'SCVTEMPLATE'))) { $template_group = Scvgroup::with_org($organization->name, 'SCVTEMPLATE'); $scvuser = new Scvuser; $data = [ 'name' => 'scvtemplate', 'password_confirmation' => 'scvtemplate', 'group' => $template_group->name, 'organization' => $organization->name ]; if (ConfHelper::usingPassword()) { $data['password'] = 'scvtemplate'; $data['password_confirmation'] = 'scvtemplate'; } dispatch_now(new ScvuserJob("store", $data)); } if (UH::isAdmin()) return redirect()->route('organization.index'); else return redirect("/scvmanager/organization/{$name}"); } public function destroy(OrganizationRequest $request, $name) { if (!UH::isAdmin()) abort(403); $organization = Organization::where('name', $name)->first(); Scvuser::deleteScvtemplate($organization->id); Scvgroup::deleteScvtemplate($organization->id); $dbret = $organization->delete(); $slavedbret = 0; if (CH::needsToSyncSlave()) { $organization = new Organization; $slavedbret = $organization->setConnection('slave_database') ->where('name', $name) ->delete(); } CH::updateClusters($dbret, $slavedbret); return redirect()->route('organization.index'); } private function abort_ifnot_exists($organization) { if ($organization === null) return abort(404); } private function abort_ifnot_mine($organization) { $login_org = \Auth::user()->organization; if ($organization !== null && $organization->name !== $login_org) return abort(403); } } 