<?php
 namespace App\Http\Controllers; use App\Http\Controllers\Controller; use Illuminate\Http\Request; use App\Scvuser; use App\Libs\GAuthManager; class ScvLoginController extends Controller { public function index(Request $req) { if (!session()->get('errors')) { session([ 'scvlogin_faze' => 'scvxlocal', 'scvlogin_user' => null ]); } return view('scvlogin.index'); } public function store(Request $req) { switch (session('scvlogin_faze')) { case 'scvxlocal': $user = $req->input('user'); $password = $req->input('password'); return $this->first_auth($user, $password); case 'totp': $password = $req->input('password'); return $this->second_auth($password); default: return redirect()->back()->withErrors('不正なリクエストです'); } } private function first_auth($user, $password) { $scvuser = Scvuser::attemptScvLogin($user, $password); if ($scvuser === null) return redirect()->back()->withErrors('ユーザ名かパスワードが誤っています'); session([ 'scvlogin_faze' => 'totp', 'scvlogin_user' => $scvuser->id ]); return view('scvlogin.index', [ 'faze' => 'totp', 'user' => $scvuser->name ]); } private function second_auth($password) { $userid = (int)session('scvlogin_user'); $scvuser = Scvuser::find($userid); if ($scvuser === null) return redirect()->back()->withErrors('不正なリクエストです'); $gam = new GAuthManager($scvuser); if ($gam->get_secretkey() === '') return redirect()->back()->withErrors('認証用の秘密鍵が見つかりませんでした。ユーザ作成後に2要素認証を有効にした場合はパスワードを再変更してください'); if (!$gam->verify_password($password)) return redirect()->back()->withErrors('ワンタイムパスワードが一致しません'); return $this->success_auth(); } private function success_auth() { return "認証成功！（SCVXを起動）"; } public function debug_qr(Request $req, $org, $user) { $scvuser = Scvuser::with_org($org, $user); if ($scvuser === null) return '指定されたユーザが存在しません<br>' . $org . '/' . $user; $gam = new GAuthManager($scvuser); $gam->renew_secretkey(); $qr = $gam->get_qr_url(); $output = '秘密鍵を生成しました。以下のQRコードをGoogle認証で読み取ってください<br>'; $output .= '<img src="' . $qr . '"><br>'; return $output; } } 