<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use App\Http\Controllers\Controller; use App\Organization; use App\Scvgroup; use App\Firefoxprofile; use App\ScvxChromeSetting; use App\Shareprofile; use App\BrSetting; use App\Scvflow; use App\Jobs\ScvgroupJob; use App\Libs\ClusterHelper as CH; use App\Libs\UserHelper as UH; use App\Libs\ConfHelper; define('LIC_STZ_FS', 0x10); define('LIC_STZ_MM', 0x20); define('LIC_STZ_SCVX', 0x40); define('LIC_VCK', 0x80); define('LIC_TCK', 0x100); define('LIC_DL_STZ', 0x01); define('LIC_DL_VCK', 0x02); define('LIC_DL_TCK', 0x04); define('DL_TCK_STZ', 0x10); define('NEMO_MENUBAR', 0x01); define('NEMO_SIDEBAR', 0x02); define('COLINFO_IDX_COLUMN_NAME', 0); define('COLINFO_IDX_VALUE_FORMAT', 1); define('COLINFO_IDX_ADD_REQUIRED', 2); define('COLINFO_IDX_EDIT_REQUIRED', 3); define('COLINFO_IDX_DEL_REQUIRED', 4); define('COLINFO_IDX_VALUE_EXAMPLE', 5); class ScvgroupsController extends Controller { const SCVTEMPLATE = 'scvtemplate'; private $csv_column_info = null; private $column2idx = null; public function __construct() { $this->csv_column_info = [ ['操作', '追加、変更、削除', '追加', '変更', '削除', '（例）追加'], ['組織名', '半角英数', '必須', '必須', '必須', 'ADMIN'], ['グループ名', '半角英数', '必須', '必須', '必須', 'GROUP01'], ['有効', '0か1', null, null, null, '1'], ['曜日有効', '0か1', null, null, null, '1'], ['許可曜日', '"曜日(,区切り)"', null, null, null, '"SUN,MON"'], ['時間有効', '0か1', null, null, null, '1'], ['許可時間', '時刻範囲', null, null, null, '00:00-24:00'], ['アイドルタイムアウト', '分数', null, null, null, '10'], ['アイドルタイムアウトメッセージ', '秒数', null, null, null, '30'], ['強制タイムアウト', '分数', null, null, null, '20'], ['強制タイムアウトメッセージ', '秒数', null, null, null, '30'], ['アプリケーション', 'アプリ名', null, null, null, 'firefox'], ['Firefox保存', '0か1', null, null, null, '1'], ['コピー＆ペースト', '0-3', null, null, null, '3'], ['無害化有効', 'フラグ', null, null, null, '416'], ['印刷有効', '0-3', null, null, null, '3'], ['ダウンロード有効', 'フラグ', null, null, null, '7'], ['アップロード有効', '0か1', null, null, null, '1'], ['SCV Flow', '0-3', null, null, null, '1'], ['ファイルマネージャ表示', '0-3', null, null, null, '2'], ['実行モード', 'SINGLE/MULTI', null, null, null, 'MULTI'], ['PRIORITY', 'LOW/HIGH', null, null, null, 'LOW'], ['Firefox設定', '半角英数', null, null, null, 'PROF_TEST'], ['SCVX Chrome設定', '半角英数', null, null, null, 'SCVX_CHROME_TEST'], ['共有フォルダ設定', '半角英数', null, null, null, 'SHARE_TEST'], ['RevoBrowser設定', '半角英数', null, null, null, 'BR_TEST'], ['SCVイメージ', '半角英数', null, null, null, 'DEFAULT'], ['デスクトップ設定', '半角英数', null, null, null, '"TEST1,TEST2"'], ['オフライン起動有効期限', '0-240', null, null, null, '240'], ['備考', '全角可', null, null, null, 'テスト'], ['処理結果', null, null, null, null, '変更完了'] ]; $this->column2idx = []; foreach ($this->csv_column_info as $idx => $array) { $column = $array[0]; $this->column2idx[$column] = $idx; } } private function generate_example_csv() { $column_cols = []; $valtype_cols = []; $create_cols = []; $update_cols = []; $delete_cols = []; $example_cols = []; $row_cnt = count($this->csv_column_info); for ($i = 0; $i < $row_cnt; ++$i) { $col_info = $this->csv_column_info[$i]; $column_cols[] = $col_info[COLINFO_IDX_COLUMN_NAME]; $valtype_cols[] = $col_info[COLINFO_IDX_VALUE_FORMAT]; $create_cols[] = $col_info[COLINFO_IDX_ADD_REQUIRED]; $update_cols[] = $col_info[COLINFO_IDX_EDIT_REQUIRED]; $delete_cols[] = $col_info[COLINFO_IDX_DEL_REQUIRED]; $example_cols[] = $col_info[COLINFO_IDX_VALUE_EXAMPLE]; } $column_row = join(',', $column_cols); $valtype_row = join(',', $valtype_cols); $create_row = join(',', $create_cols); $update_row = join(',', $update_cols); $delete_row = join(',', $delete_cols); $example_row = join(',', $example_cols); $text = <<<EOM
#---------------------------------------------------------------------------------
# ※操作列に追加、変更、削除のいずれかを入力し、必要項目を入力してください。
# ※操作列が追加、変更、削除以外または#で始まる場合処理をスキップします。
# ※処理結果列は処理後に更新されます。
#---------------------------------------------------------------------------------
# {$column_row}
# {$valtype_row}
# {$create_row}
# {$update_row}
# {$delete_row}
# {$example_row}
#---------------------------------------------------------------------------------
# {$column_row}
EOM;
return $text; } public function export_csv_text($user) { $fp = fopen('php://temp','w'); fwrite($fp, $this->generate_example_csv() . PHP_EOL); $scvgroups = $this->editable_scvgroups_by($user); $c2i = $this->column2idx; $row = []; foreach ($scvgroups as $scvgroup) { $row[$c2i['操作']] = ''; $row[$c2i['組織名']] = $scvgroup->organization; $row[$c2i['グループ名']] = $scvgroup->name; $row[$c2i['有効']] = $scvgroup->enable; $row[$c2i['曜日有効']] = $scvgroup->ena_dayofweek; $row[$c2i['許可曜日']] = $scvgroup->dayofweek; $row[$c2i['時間有効']] = $scvgroup->ena_hour; $row[$c2i['許可時間']] = $scvgroup->hour; $row[$c2i['アイドルタイムアウト']] = $scvgroup->idle_timeout / 60; $row[$c2i['アイドルタイムアウトメッセージ']] = $scvgroup->idle_msg_wait; $row[$c2i['強制タイムアウト']] = $scvgroup->force_timeout / 60; $row[$c2i['強制タイムアウトメッセージ']] = $scvgroup->force_msg_wait; $row[$c2i['アプリケーション']] = $scvgroup->applist; $row[$c2i['Firefox保存']] = $scvgroup->firefoxsave; $row[$c2i['コピー＆ペースト']] = $scvgroup->copypaste; $row[$c2i['無害化有効']] = $scvgroup->sanitize; $row[$c2i['印刷有効']] = $scvgroup->print; $row[$c2i['ダウンロード有効']] = $scvgroup->download; $row[$c2i['アップロード有効']] = $scvgroup->upload; $row[$c2i['SCV Flow']] = $scvgroup->scv_flow; $row[$c2i['ファイルマネージャ表示']] = $scvgroup->nemo_settings; $row[$c2i['実行モード']] = $scvgroup->runmode; $row[$c2i['PRIORITY']] = $scvgroup->scvpriority; $row[$c2i['Firefox設定']] = $scvgroup->firefoxprofileName; $row[$c2i['SCVX Chrome設定']] = $scvgroup->scvxchromesettingName; $row[$c2i['共有フォルダ設定']] = $scvgroup->shareprofileName; $row[$c2i['RevoBrowser設定']] = $scvgroup->brSetting ? $scvgroup->brSetting->name : ''; $row[$c2i['SCVイメージ']] = $scvgroup->image; $row[$c2i['デスクトップ設定']] = $scvgroup->visionprofile_list; $row[$c2i['オフライン起動有効期限']] = $scvgroup->offline_expiration; $row[$c2i['備考']] = $scvgroup->comment; $row[$c2i['処理結果']] = ''; fputcsv($fp, $row); } rewind($fp); $output_csv = stream_get_contents($fp); fclose($fp); return $output_csv; } public function import_csv_text($user, $input_csv, &$success_rows, &$fail_rows, &$through_rows) { $this->add_scvgroups_from_csv($user, $input_csv, $success_rows, $fail_rows, $through_rows); $output_csv = $this->make_csv_from_rows($success_rows, $fail_rows, $through_rows); return $output_csv; } private function add_scvgroups_from_csv($user, $input_csv, &$success_rows, &$fail_rows, &$through_rows) { $org = Organization::find($user->organization_id); $editable_org = mb_strtoupper($org->name); $success_rows = []; $fail_rows = []; $through_rows = []; $c2i = $this->column2idx; $csv_column_info = $this->csv_column_info; $columns_cnt = count($csv_column_info); $fp = tmpfile(); fwrite($fp, $input_csv); rewind($fp); while (($input_row = fgetcsv($fp, 1000, ',')) !== false) { if ($input_row[0] === null) continue; if (strpos($input_row[0], '#') === 0) continue; $cnt = count($input_row); $errmsg = ''; if ($cnt < $columns_cnt) { $errmsg = '項目が' . ($columns_cnt - $cnt) . '個足りません'; } else if ($cnt > $columns_cnt) { $errmsg = '項目が' . ($cnt - $columns_cnt) . '個過剰です'; } if ($errmsg) { $input_row[$c2i['処理結果']] = $errmsg; $fail_rows[] = $input_row; continue; } $action = $input_row[$c2i['操作']]; if ($action === '操作') continue; if ($action === '追加') $required_idx = COLINFO_IDX_ADD_REQUIRED; else if ($action === '変更') $required_idx = COLINFO_IDX_EDIT_REQUIRED; else if ($action === '削除') $required_idx = COLINFO_IDX_DEL_REQUIRED; else { $input_row[$c2i['処理結果']] = '未処理データ'; $through_rows[] = $input_row; continue; } $org_name = mb_strtoupper($input_row[$c2i['組織名']]); $organization = Organization::where('name', $org_name)->first(); if ($organization === null) { $input_row[$c2i['処理結果']] = '存在しない組織'; $fail_rows[] = $input_row; continue; } $ffprof_name = $input_row[$c2i['Firefox設定']]; $firefoxprofile = Firefoxprofile::where('name', $ffprof_name)->where('organization_id', $organization->id)->first(); if ($ffprof_name && $firefoxprofile === null) { $input_row[$c2i['処理結果']] = '存在しないFirefox設定'; $fail_rows[] = $input_row; continue; } $scvx_chrome_name = $input_row[$c2i['SCVX Chrome設定']]; $scvx_chrome_setting = ScvxChromeSetting::where('name', $scvx_chrome_name)->where('organization_id', $organization->id)->first(); if ($scvx_chrome_name && $scvx_chrome_setting === null) { $input_row[$c2i['処理結果']] = '存在しないSCVX Chrome設定'; $fail_rows[] = $input_row; continue; } $share_name = $input_row[$c2i['共有フォルダ設定']]; $shareprofile = Shareprofile::where('shname', $share_name)->where('organization_id', $organization->id)->first(); if ($share_name && $shareprofile === null) { $input_row[$c2i['処理結果']] = '存在しない共有フォルダ設定'; $fail_rows[] = $input_row; continue; } $br_setting_name = $input_row[$c2i['RevoBrowser設定']]; $br_setting = BrSetting::where('name', $br_setting_name)->first(); if ($br_setting_name && $br_setting === null) { $input_row[$c2i['処理結果']] = '存在しないRevoBrowser設定'; $fail_rows[] = $input_row; continue; } $organization_id = $organization->id; $name = mb_strtoupper($input_row[$c2i['グループ名']]); $enable = $input_row[$c2i['有効']]; $ena_dayofweek = $input_row[$c2i['曜日有効']]; $dayofweek = $input_row[$c2i['許可曜日']]; $ena_hour = $input_row[$c2i['時間有効']]; $hour = $input_row[$c2i['許可時間']]; $idle_timeout = $input_row[$c2i['アイドルタイムアウト']] * 60; $idle_msg_wait = $input_row[$c2i['アイドルタイムアウトメッセージ']]; $force_timeout = $input_row[$c2i['強制タイムアウト']] * 60; $force_msg_wait = $input_row[$c2i['強制タイムアウトメッセージ']]; $applist = $input_row[$c2i['アプリケーション']]; $firefoxsave = $input_row[$c2i['Firefox保存']]; $copypaste = $input_row[$c2i['コピー＆ペースト']]; $sanitize = $input_row[$c2i['無害化有効']]; $print = $input_row[$c2i['印刷有効']]; $download = $input_row[$c2i['ダウンロード有効']]; $upload = $input_row[$c2i['アップロード有効']]; $scv_flow = $input_row[$c2i['SCV Flow']]; $nemo_settings = $input_row[$c2i['ファイルマネージャ表示']]; $runmode = mb_strtoupper($input_row[$c2i['実行モード']]) === 'MULTI' ? 'MULTI' : 'SINGLE'; $scvpriority = $input_row[$c2i['PRIORITY']]; $firefoxprofile_id = $firefoxprofile ? $firefoxprofile->id : 0; $scvx_chrome_setting_id = $scvx_chrome_setting ? $scvx_chrome_setting->id : 0; $shareprofile_id = $shareprofile ? $shareprofile->id : 0; $br_setting_id = $br_setting ? $br_setting->id : 0; $image = $input_row[$c2i['SCVイメージ']]; $visionprofile_list = $input_row[$c2i['デスクトップ設定']]; $offline_expiration = intval($input_row[$c2i['オフライン起動有効期限']]); $comment = $input_row[$c2i['備考']]; if($scv_flow == 1 || $scv_flow == 3){ $upload = 1; } if ($editable_org !== 'ADMIN') { if ($editable_org !== $input_row[$c2i['組織名']]) { $input_row[$c2i['処理結果']] = '異なる組織'; $fail_rows[] = $input_row; continue; } } for ($i = 0; $i < $columns_cnt; ++$i) { $required = $csv_column_info[$i][$required_idx]; $value = $input_row[$i]; if ($required && !$value) { $input_row[$c2i['処理結果']] = '必須項目未入力'; $fail_rows[] = $input_row; continue 2; } } $params = compact( 'organization_id', 'name', 'enable', 'ena_dayofweek', 'dayofweek', 'ena_hour', 'hour', 'idle_timeout', 'idle_msg_wait', 'force_timeout', 'force_msg_wait', 'applist', 'firefoxsave', 'copypaste', 'sanitize', 'print', 'download', 'upload', 'scv_flow', 'nemo_settings', 'runmode', 'scvpriority', 'firefoxprofile_id', 'scvx_chrome_setting_id', 'shareprofile_id', 'br_setting_id', 'image', 'visionprofile_list', 'offline_expiration', 'comment' ); switch ($action) { case '追加': $err_msg = dispatch_now(new ScvgroupJob('store', $params, true)); break; case '変更': $err_msg = dispatch_now(new ScvgroupJob('update', $params, true)); break; case '削除': $err_msg = dispatch_now(new ScvgroupJob('destroy', $params, true)); } if ($err_msg === '') { $input_row[$c2i['処理結果']] = $action . '完了'; $success_rows[] = $input_row; } else { $input_row[$c2i['処理結果']] = $err_msg; $fail_rows[] = $input_row; } } return true; } private function make_csv_from_rows(&$success_rows, &$fail_rows, &$through_rows) { $columns = []; foreach ($this->csv_column_info as $col_info) $columns[] = $col_info[COLINFO_IDX_COLUMN_NAME]; $stream = fopen('php://temp', 'w'); fputcsv($stream, $columns); foreach (array_merge($fail_rows, $through_rows, $success_rows) as $row) fputcsv($stream, $row); rewind($stream); $output_csv = stream_get_contents($stream); $output_csv = str_replace(PHP_EOL, "\r\n", $output_csv); fclose($stream); return $output_csv; } private function login_user() { return auth()->guard('web')->user(); } private function editable_scvgroups_by($user) { $organization = Organization::find($user->organization_id); if ($organization->name === 'ADMIN') $scvgroups = Scvgroup::all(); else $scvgroups = Scvgroup::where('organization_id', $organization->id)->get(); return $scvgroups; } private function validate_cluster_from_web(&$err_res) { if (CH::isCluster() && !CH::isMasterActive()) { $val = \Validator::make([], []); $val->errors()->add('field', 'masterサーバがActiveではありません。'); $err_res = redirect()->back()->withErrors($val); return false; } if (CH::isCluster() && !CH::isMaster()) { $val = \Validator::make([], []); $val->errors()->add('field', 'slaveサーバからグループの登録/変更を行うことはできません。'); $err_res = redirect()->back()->withErrors($val); return false; } return true; } public function index() { $query = Scvgroup::leftJoin('firefoxprofiles', 'scvgroups.firefoxprofile_id', 'firefoxprofiles.id') ->leftJoin('scvx_chrome_settings', 'scvgroups.scvx_chrome_setting_id', 'scvx_chrome_settings.id') ->leftJoin('shareprofiles', 'scvgroups.shareprofile_id', 'shareprofiles.id') ->leftJoin('organizations', 'scvgroups.organization_id', 'organizations.id'); if (!UH::isAdmin()) { $org_id = \Auth::user()->organization_id; $query->where('scvgroups.organization_id', $org_id); } $query->orderBy('id', 'asc'); $scvgroups = $query->select([ 'scvgroups.*', 'firefoxprofiles.name as profname', 'scvx_chrome_settings.name as scvxchromename', 'shareprofiles.shname', 'organizations.name as orgname' ]) ->paginate(50); return view('scvgroups.index', compact('scvgroups')); } public function create() { $availableOptions = []; if(UH::isAdmin()){ $organizations = Organization::all(); }else{ $org_id = \Auth::user()->organization_id; $organizations = Organization::where('id','=',$org_id)->get(); $organization = $organizations->first(); $availableOptions['stz'] = $organization->enable_stz == '1' ? true : false; $availableOptions['vck'] = $organization->enable_vck == '1' ? true : false; $availableOptions['tck'] = $organization->enable_tck == '1' ? true : false; } exec('docker images --format "{{.Repository}}:{{.Tag}}" | grep ^scv', $scvimages, $ret); $firefoxprofs = Firefoxprofile::all(); $scvx_chromes = ScvxChromeSetting::all(); $shareprofiles = Shareprofile::all(); $br_settings = BrSetting::all(); $flow_available = Scvflow::is_available(); $copypaste_options = Scvgroup::get_copypaste_options(); $enable_flow = ConfHelper::scvconf('SCV_FLOW') > 0 ? true : false; return view('scvgroups.create', compact( 'scvimages', 'firefoxprofs', 'scvx_chromes', 'shareprofiles', 'br_settings', 'organizations', 'flow_available', 'copypaste_options', 'availableOptions', 'enable_flow' )); } public function store(Request $request) { if (!$this->validate_cluster_from_web($err_res)) return $err_res; $prms = $request->all(); $prms = $this->convert_db_params($prms); dispatch_now(new ScvgroupJob('store', $prms)); return redirect()->to('/scvmanager/scvgroups'); } public function show($id) { $scvgroup = Scvgroup::find($id); if (!$this->has_authority($scvgroup)) abort(403); $scvgroup = Scvgroup::leftJoin('firefoxprofiles', 'scvgroups.firefoxprofile_id', 'firefoxprofiles.id') ->leftJoin('scvx_chrome_settings', 'scvgroups.scvx_chrome_setting_id', 'scvx_chrome_settings.id') ->leftJoin('shareprofiles', 'scvgroups.shareprofile_id', 'shareprofiles.id') ->leftJoin('organizations', 'scvgroups.organization_id', 'organizations.id') ->leftJoin('br_settings', 'scvgroups.br_setting_id', 'br_settings.id') ->where('scvgroups.id', $id) ->select( 'scvgroups.*', 'firefoxprofiles.name as profname', 'scvx_chrome_settings.name as scvx_chrome_name', 'shareprofiles.shname', 'br_settings.name as br_setting_name' ) ->first(); $enable_flow = ConfHelper::scvconf('SCV_FLOW') > 0 ? true : false; return view('scvgroups.show', ['scvgroup' => $scvgroup, 'enable_flow' => $enable_flow]); } public function edit($id) { $availableOptions = []; if(!UH::isAdmin()){ $org_id = \Auth::user()->organization_id; $organization = Organization::find($org_id); $availableOptions['stz'] = $organization->enable_stz == '1' ? true : false; $availableOptions['vck'] = $organization->enable_vck == '1' ? true : false; $availableOptions['tck'] = $organization->enable_tck == '1' ? true : false; } $scvgroup = Scvgroup::find($id); if (!$this->has_authority($scvgroup)) abort(403); $firefoxprofs = Firefoxprofile::getFirefoxprofilesByOrgId($scvgroup->organization_id); $scvx_chromes = ScvxChromeSetting::getChromeSettingsByOrg($scvgroup->organization_id); $shareprofiles = Shareprofile::getShareProfileByOrgId($scvgroup->organization_id); $br_settings = BrSetting::getSelectBoxArray(); $flow_available = Scvflow::is_available(); $copypaste_options = Scvgroup::get_copypaste_options(); $enable_flow = ConfHelper::scvconf('SCV_FLOW') > 0 ? true : false; $flgs = $this->composite_webui_flag($scvgroup->sanitize, $scvgroup->download); $stz_flag = $flgs['stz_flag']; $stz_dl_flag = $flgs['stz_dl_flag']; $vck_flag = $flgs['vck_flag']; $tck_flag = $flgs['tck_flag']; $tck_stz_dl_flag = $flgs['tck_stz_dl_flag']; exec('docker images --format "{{.Repository}}:{{.Tag}}" | grep ^scv', $scvimages, $ret); return view('scvgroups.edit', compact( 'scvgroup', 'scvimages', 'firefoxprofs', 'scvx_chromes', 'shareprofiles', 'br_settings', 'stz_flag', 'stz_dl_flag', 'vck_flag', 'tck_flag', 'tck_stz_dl_flag', 'flow_available', 'copypaste_options', 'availableOptions', 'enable_flow' )); } public function update(Request $request) { if (!$this->validate_cluster_from_web($err_res)) return $err_res; $prms = $request->all(); $scvgroup = Scvgroup::find($prms['id']); if (!$this->has_authority($scvgroup)) abort(403); $prms = $this->convert_db_params($prms); $prms['organization_id'] = $scvgroup->organization_id; dispatch_now(new ScvgroupJob('update', $prms)); return redirect()->to("/scvmanager/scvgroups"); } public function destroy(Request $request) { if (!$this->validate_cluster_from_web($err_res)) return $err_res; $prms = $request->all(); $scvgroup = Scvgroup::find($prms['id']); if (!$this->has_authority($scvgroup)) abort(403); $prms['organization_id'] = $scvgroup->organization_id; $prms['name'] = $scvgroup->name; dispatch_now(new ScvgroupJob('destroy', $prms)); return redirect()->to('/scvmanager/scvgroups'); } public function csv() { return view('scvgroups.csv'); } public function csv_download() { $user = $this->login_user(); $raw_csv = $this->export_csv_text($user); $raw_csv = str_replace(PHP_EOL, "\r\n", $raw_csv); $raw_csv = mb_convert_encoding($raw_csv, 'sjis-win', 'utf-8'); $filename = 'scvgroups_' . date('Ymd') . '.csv'; return \Response::make($raw_csv, 200, [ 'Content-Type' => 'text/csv', 'Content-Disposition' => 'attachment; filename="' . $filename . '"' ]); } public function csv_upload(Request $request) { if (CH::isCluster()) { if (!CH::isMasterActive() || !CH::isSlaveAlive() || !CH::isSlaveActive()) { return redirect()->back()->withErrors('CSV一括登録はSlaveサーバが起動している場合のみ実行できます。'); } } $file = $request->file('file'); if ($file === null) return redirect()->back()->withErrors('CSVがアップロードされていません。'); if (!$file->isValid()) return redirect()->back()->withErrors('CSVのアップロードに失敗しました。'); $name = $file->getClientOriginalName(); if (!preg_match('/.+\.csv$/', $name)) return redirect()->back()->withErrors('CSVファイルを選択して下さい。'); $sem = sem_get(config('scv.csv_sem_key')); if(!$sem){ logger('Failed to get semaphore - sem_get()'); throw new \Exception("排他制御に失敗しました"); } if(!sem_acquire($sem, true)){ throw new \Exception("CSV処理中のため実行できません"); } try { $input_path = $file->getRealPath(); $login_user = $this->login_user(); $input_csv = file_get_contents($input_path); $input_csv = mb_convert_encoding($input_csv, 'utf-8', 'sjis-win'); $output_csv = $this->import_csv_text($login_user, $input_csv, $success_rows, $fail_rows, $through_rows); $output_csv = mb_convert_encoding($output_csv, 'sjis-win', 'utf-8'); } catch (\Exception $e) { $errmsg = $e->getMessage(); if (env('APP_DEBUG')) { $errmsg .= ':' . $e->getFile(); $errmsg .= ':' . $e->getLine(); } return redirect()->back()->withErrors($errmsg); } $filename = 'result_' . date('Ymd') . '.csv'; return \Response::make($output_csv, 200, [ 'Content-Type' => 'text/csv', 'Content-Disposition' => 'attachment; filename="' . $filename . '"' ])->cookie('EXPORTED', 'EXPORTED', 1, "", "", false, false); } private function has_authority($scvgroup) { $login_user = \Auth::user(); if ($login_user->organization_id === 1) return true; if ($scvgroup && $scvgroup->organization_id === $login_user->organization_id) return true; return false; } private function update_clusters_if_necessary($me, $slave) { if (!CH::isCluster()) return; if (CH::isMaster() && CH::isSlaveAlive() && CH::isSlaveActive()) { CH::updateClusters($me, $slave); } else if (CH::isMaster()) { CH::updateClusters($me, false); } else if (CH::isSlave()) { CH::updateClusters(false, $me); } else { throw new \Exception('MemberサーバでDBを変更しようとしました'); } } private function convert_db_params($prms) { $prms['name'] = mb_strtoupper($prms['name']); $prms['sort'] = $prms['name']; $prms['enable'] = isset($prms['enable']) ? 1 : 0; $prms['ena_dayofweek'] = isset($prms['ena_dayofweek']) ? 1 : 0; $prms['ena_hour'] = isset($prms['ena_hour']) ? 1 : 0; $prms['firefoxsave'] = isset($prms['firefoxsave']) ? 1 : 0; $prms['upload'] = $this->uploadIsAffectedByFlow($prms); $prms['dayofweek'] = isset($prms['dayofweek']) ? implode(',', $prms['dayofweek']) : ''; $prms['maxlimit'] = isset($prms['maxlimit']) ? $prms['maxlimit'] : -1; $prms['scvpriority'] = strlen($prms['scvpriority']) ? $prms['scvpriority'] : 'NORMAL'; $prms['idle_timeout'] = (int)$prms['idle_timeout'] * 60; $prms['force_timeout'] = (int)$prms['force_timeout'] * 60; $prms['custom'] = isset($prms['custom']) ? $prms['custom'] : ''; $prms['custom'] = $this->composite_custom_str($prms['custom']); $stz_dl_flag = isset($prms['stz_dl_flag']) ? $prms['stz_dl_flag'] : 0; $stz_flag = isset($prms['stz_flag']) ? $prms['stz_flag'] : 0; $tck_flag = isset($prms['tck_flag']) ? $prms['tck_flag'] : 0; $vck_flag = isset($prms['vck_flag']) ? $prms['vck_flag'] : 0; $tck_stz_dl_flag = isset($prms['tck_stz_dl_flag']) ? $prms['tck_stz_dl_flag'] : 0; $prms['sanitize'] = $this->composite_sanitize_flag($stz_flag, $tck_flag, $vck_flag); $prms['download'] = $this->composite_download_flag($stz_dl_flag, $tck_flag, $vck_flag, $tck_stz_dl_flag); $prms['nemo_settings'] = isset($prms['nemo_settings']) ? $this->composite_nemo_flag($prms['nemo_settings']) : 0; return $prms; } private function uploadIsAffectedByFlow($prms) { $flow = $prms['scv_flow'] ?? 0; if ($flow == 1 || $flow == 3) { return 1; } return isset($prms['upload']) ? 1 : 0; } private function composite_custom_str($custom) { $custom_str = ''; $custom = str_replace(["\r\n", "\r", "\n"], "\n", $custom); $custom = explode("\n", $custom); foreach ($custom as $line) { if (preg_match('/.*,.*,.*,.*/', $line)) { $url = explode(",", $line); $url[1] = (rawurlencode($url[1])); $url[1] = str_replace('%2F', '/', $url[1]); $custom_str .= implode(',', $url) . "\r\n"; } else { $custom_str .= $line; continue; } } return $custom_str; } private function composite_nemo_flag($a){ $ns = 0x00; if(in_array('menubar', $a, true)) $ns |= NEMO_MENUBAR; if(in_array('sidebar', $a, true)) $ns |= NEMO_SIDEBAR; return $ns; } private function composite_sanitize_flag($stz_flag, $tck_flag, $vck_flag) { $sanitize = 0x00; if ($stz_flag == 1) { $sanitize |= LIC_STZ_SCVX; } elseif ($stz_flag == 2) { $sanitize |= LIC_STZ_FS; } elseif ($stz_flag == 3) { $sanitize |= LIC_STZ_MM; } if ($tck_flag == 1 || $tck_flag == 2) $sanitize |= LIC_TCK; if ($vck_flag == 1 || $vck_flag == 2) $sanitize |= LIC_VCK; return $sanitize; } private function composite_download_flag($stz_dl_flag, $tck_flag, $vck_flag, $tck_stz_dl_flag) { $download = 0x00; if ($stz_dl_flag) $download |= LIC_DL_STZ; if ($tck_flag == 2) $download |= LIC_DL_TCK; if ($vck_flag == 2) $download |= LIC_DL_VCK; if($tck_stz_dl_flag && $stz_dl_flag && ($tck_flag == 2)) $download |= DL_TCK_STZ; return $download; } private function composite_webui_flag($sanitize, $download) { $params = []; $sanitize = (int)$sanitize; $download = (int)$download; $params['stz_flag'] = 0; if ($sanitize & LIC_STZ_SCVX) $params['stz_flag'] = 1; if ($sanitize & LIC_STZ_FS) $params['stz_flag'] = 2; if ($sanitize & LIC_STZ_MM) $params['stz_flag'] = 3; $params['stz_dl_flag'] = $download & LIC_DL_STZ ? 1 : 0; $params['vck_flag'] = 0; if ($sanitize & LIC_VCK) $params['vck_flag'] = 1; if ($sanitize & LIC_VCK && $download & LIC_DL_VCK) $params['vck_flag'] = 2; $params['tck_flag'] = 0; if ($sanitize & LIC_TCK) $params['tck_flag'] = 1; if ($sanitize & LIC_TCK && $download & LIC_DL_TCK) $params['tck_flag'] = 2; $params['tck_stz_dl_flag'] = $download & DL_TCK_STZ ? 1: 0; return $params; } public function syncFirefoxProfile(Request $request) { $firefoxprofs = Firefoxprofile::getFirefoxprofilesByOrgId($request->organization_id); return json_encode($firefoxprofs); } public function syncShareProfile(Request $request) { $shareprofiles = Shareprofile::getShareProfileByOrgId($request->organization_id); return json_encode($shareprofiles); } public function syncScvxChromeSetting(Request $request) { $scvx_chrome_setting = ScvxChromeSetting::getChromeSettingsByOrg($request->organization_id); return json_encode($scvx_chrome_setting); } } 