<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use App\Http\Controllers\Controller; use App\Scvuser; use App\Scvgroup; use App\Organization; use App\Scvflow; use DB; use App\Libs\UserHelper as UH; use App\Libs\ClusterHelper as CLH; use App\Jobs\ScvuserJob; class ScvusersController extends Controller { public function index() { $query = Scvuser::join('scvgroups', 'scvusers.groupid', 'scvgroups.id') ->join('organizations', 'scvgroups.organization_id', 'organizations.id'); if (!UH::isAdmin()) { $org_id = \Auth::user()->organization_id; $query->where('scvgroups.organization_id', $org_id); } $scvusers = $query->select( 'scvusers.*', 'scvgroups.name as groupname', 'organizations.name as org_name', 'organizations.id as org_id' ) ->orderby('scvusers.id') ->Paginate(50); return view('scvusers.index', compact('scvusers')); } public function userList($organization) { $selected = $organization; if($selected == 'all') $selected = ''; $org_id = \Auth::user()->organization_id; if(UH::isAdmin()){ $scvusers = DB::table('scvusers') ->leftjoin('scvgroups', 'scvusers.groupid', '=', 'scvgroups.id') ->leftjoin('organizations', 'scvgroups.organization_id', '=', 'organizations.id') ->select(DB::raw('scvusers.*, scvgroups.name as groupname, organizations.name as org_name, organizations.id as org_id')) ->where('organizations.name', 'like', "%$selected%") ->orderby('scvusers.id') ->Paginate(50); $organizations = Organization::all(); return view('scvusers.index', ['scvusers' => $scvusers, 'organizations' => $organizations, 'selected' => $selected]); } } public function create() { $flow_available = Scvflow::is_available(); $org_id = \Auth::user()->organization_id; $org_name = Organization::find($org_id)->name; if (UH::isAdmin()) $scvgroups = Scvgroup::get(); else { $scvgroups = Scvgroup::where('organization_id', $org_id)->get(); } $organization = $org_name; return view('scvusers.create', compact('organization', 'scvgroups', 'flow_available')); } public function store(Request $request) { if (CLH::isCluster() && !CLH::isMasterActive()) { $val = \Validator::make([], []); $val->errors()->add('field', 'masterサーバがActiveではありません。'); return redirect()->back()->withErrors($val); } if (CLH::isCluster() && !CLH::isMaster()) { $val = \Validator::make([], []); $val->errors()->add('field', 'slaveサーバからユーザの登録/変更を行うことはできません。'); return redirect()->back()->withErrors($val); } $params = $request->all(); $params['privilege'] = $request->input('privilege') !== null; $org_group = explode('/', $params['org_group']); $params['organization'] = $org_group[0]; $params['group'] = $org_group[1]; dispatch_now(new ScvuserJob("store", $params)); return redirect()->to('/scvmanager/scvusers'); } public function show($id) { $flow_available = Scvflow::is_available(); $scvuser = Scvuser::join('scvgroups', 'scvusers.groupid', 'scvgroups.id') ->select(['scvusers.*', 'scvgroups.name as groupname']) ->where('scvusers.id', $id) ->first(); if($scvuser == null){ abort(404); } if (!UH::isAdmin()) UH::checkGroup($scvuser->groupid); return view('scvusers.show', compact('scvuser','flow_available')); } public function edit($id) { $flow_available = Scvflow::is_available(); $scvuser = Scvuser::join('scvgroups', 'scvusers.groupid', 'scvgroups.id') ->select('scvusers.*', 'scvgroups.name as groupname') ->where('scvusers.id', $id) ->first(); if ($scvuser == null) abort(404); if ($scvuser->name == 'scvtemplate') abort(404); if (!UH::isAdmin()) UH::checkGroup($scvuser->groupid); $org_name = $scvuser->organization; $org_id = Organization::where('name', $org_name)->first()->id; $scvgroups = Scvgroup::where('organization_id', $org_id)->get(); return view('scvusers.edit', compact('scvuser', 'scvgroups', 'flow_available')); } public function update(Request $request) { if (CLH::isCluster() && !CLH::isMasterActive()) { $val = \Validator::make([], []); $val->errors()->add('field', 'masterサーバがActiveではありません。'); return redirect()->back()->withErrors($val); } if (CLH::isCluster() && !CLH::isMaster()) { $val = \Validator::make([], []); $val->errors()->add('field', 'slaveサーバからユーザの登録/変更を行うことはできません。'); return redirect()->back()->withErrors($val); } $params = $request->all(); $params['privilege'] = $request->input('privilege') !== null; dispatch_now(new ScvuserJob('update', $params)); return redirect()->to('/scvmanager/scvusers'); } public function destroy(Request $request, $id) { if (CLH::isCluster() && !CLH::isMasterActive()) { $val = \Validator::make([], []); $val->errors()->add('field', 'masterサーバがActiveではありません。'); return redirect()->back()->withErrors($val); } if (CLH::isCluster() && !CLH::isMaster()) { $val = \Validator::make([], []); $val->errors()->add('field', 'slaveサーバからユーザの登録/変更を行うことはできません。'); return redirect()->back()->withErrors($val); } $params = $request->all(); $org_group = explode('/', $params['org_group']); $params['organization'] = $org_group[0]; $params['group'] = $org_group[1]; dispatch_now(new ScvuserJob('destroy', $params)); return redirect()->to("/scvmanager/scvusers"); } public function search(Request $request) { $query = Scvuser::join('scvgroups', 'scvusers.groupid', '=', 'scvgroups.id') ->join('organizations', 'scvgroups.organization_id', '=', 'organizations.id'); if (!UH::isAdmin()) { $org_id = \Auth::user()->organization_id; $query->where('organizations.id', $org_id); } $word = $request->input('word'); $query->where(function ($query) use($word) { $query->where('organizations.name', 'like', "%{$word}%") ->orWhere('scvgroups.name', 'like', "%{$word}%") ->orWhere('scvusers.name', 'like', "%{$word}%") ->orWhere('scvusers.jpname', 'like', "%{$word}%") ->orWhere('scvusers.department', 'like', "%{$word}%") ->orWhere('scvusers.post', 'like', "%{$word}%") ->orWhere('scvusers.employee_id', 'like', "%{$word}%") ->orWhere('scvusers.custom_data1', 'like', "%{$word}%") ->orWhere('scvusers.custom_data2', 'like', "%{$word}%") ->orWhere('scvusers.custom_data3', 'like', "%{$word}%") ->orWhere('scvusers.email', 'like', "%{$word}%") ->orWhere('scvusers.comment', 'like', "%{$word}%"); }); $query->select([ 'scvusers.*', 'scvgroups.name as groupname', 'scvgroups.organization_id', 'organizations.name as org_name' ]); $query->orderby('scvusers.id'); $users = $query->Paginate(50); return view('scvusers.search', compact('users', 'word')); } } 