<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use App\ScvxChromeSetting; use App\Http\Requests\ScvxChromeSettingRequest; use App\Http\Requests\ChromeCertUploadRequest; use App\Models\ManagedBookmark; use App\Organization; class ScvxChromeSettingController extends Controller { const ADMIN_ORG = 1; public function index() { if($this->isAdmin()){ $settings = ScvxChromeSetting::getChromeSettingsWithOrg(); } else { $settings = ScvxChromeSetting::getChromeSettingsByOrg(\Auth::user()->organization_id); } return view('scvx_chrome_settings.index', compact('settings')); } public function create() { $organization_id = \Auth::user()->organization_id; if($this->isAdmin()) { $organizations = Organization::all(); } else { $organizations = Organization::find($organization_id); } return view('scvx_chrome_settings.create', compact('organizations')); } public function store(ScvxChromeSettingRequest $request) { ScvxChromeSetting::create($request->all()); return redirect('/scvmanager/scvx_chrome_settings'); } public function show($id) { $setting = ScvxChromeSetting::getChromeSettingWithOrgById($id); if ($setting == null) { return abort(404); } if(!$this->isAdmin() && !$this->isOwnSetting($setting)) { return abort(403); } if($this->isAdmin()) { $organizations = Organization::all(); } else { $organizations = Organization::find($setting->organization_id); } return view('scvx_chrome_settings.show', compact('setting', 'organizations')); } public function edit($id) { $setting = ScvxChromeSetting::getChromeSettingWithOrgById($id); if(!$this->isAdmin() && !$this->isOwnSetting($setting)) { return abort(403); } if($this->isAdmin()) { $organizations = Organization::all(); } else { $organizations = Organization::find(\Auth::user()->organization_id); } return view('scvx_chrome_settings.edit', compact('setting', 'organizations')); } public function update(ScvxChromeSettingRequest $request, $id) { $setting = ScvxChromeSetting::updateSetting($request->all(), $id); return redirect('/scvmanager/scvx_chrome_settings'); } public function destroy(ScvxChromeSettingRequest $request, $id) { ScvxChromeSetting::destroy($id); return redirect('/scvmanager/scvx_chrome_settings'); } public function certShow($id){ $setting = ScvxChromeSetting::find($id); if($setting->organization_id !== \Auth::user()->organization_id && \Auth::user()->organization_id !== self::ADMIN_ORG) { abort(403); } $organization_name = Organization::find($setting->organization_id)->name; $files = ScvxChromeSetting::certData($setting->name, $organization_name); return view('scvx_chrome_settings.cert_show', compact('setting', 'files')); } public function certSave(ChromeCertUploadRequest $request) { $setting = ScvxChromeSetting::find($request->id); if($setting->organization_id != \Auth::user()->organization_id && \Auth::user()->organization_id !== self::ADMIN_ORG) { abort(403); } $organization_name = Organization::find($setting->organization_id)->name; ScvxChromeSetting::certSave($setting, $organization_name, $request->file, $request->password); return redirect()->back(); } public function certDelete(Request $request) { $setting = ScvxChromeSetting::getChromeSettingAndOrgByName($request->prof_name, $request->organization_id); if($request->organization_id != \Auth::user()->organization_id && \Auth::user()->organization_id !== self::ADMIN_ORG) { abort(403); } ScvxChromeSetting::certDelete($request->fn, $setting->name, $setting->organization_name); return redirect()->back(); } private function isAdmin() { if(\Auth::user()->organization_id === self::ADMIN_ORG) { return true; } return false; } private function isOwnSetting($setting) { if(\Auth::user()->organization_id === $setting->organization_id) { return true; } return false; } } 