<?php
namespace App\Http\Controllers; use Illuminate\Http\Request; use App\Http\Requests; use App\Http\Controllers\Controller; use App\Scvuser; use App\Libs\ClusterHelper as CH; use App\Libs\ConfHelper; use App\Libs\PasswordUpdator; use App\Libs\GAuthManager; class UserAccountController extends Controller { public function index(Request $request, $org, $user, $ip_int) { $scvuser = Scvuser::with_org($org, $user); if ($scvuser === null) abort(404); $username = "{$org}/{$user}"; $view = view('user_account.index', compact('username', 'org', 'user', 'ip_int')); if (CH::isSlave() && CH::isMasterActive()) $view->withErrors('MasterサーバがアクティブのときはSlaveサーバからパスワード変更を行うことはできません'); if (ConfHelper::is_illegal()) $view->withErrors('認証方式の設定が誤っています。'); return $view; } public function store(Request $request, $org, $user, $ip_int) { if (CH::isSlave() && CH::isMasterActive()) return redirect()->back(); if (ConfHelper::is_illegal()) return redirect()->back(); if(Scvuser::is_locked($org, $user)){ return redirect()->back()->withInput()->withErrors('アカウントがロックされています。管理者にお問い合わせください。'); } $sem = sem_get(config('scv.csv_sem_key')); if (!sem_acquire($sem, true)) { return redirect()->back()->withInput()->withErrors('現在パスワードの変更を行えません。しばらく待ってから実行してください。'); } $scvuser = Scvuser::with_org($org, $user); if ($scvuser) { $today = date('Y-m-d 00:00:00'); $expired = Scvuser::where('id', $scvuser->id) ->where('pwd_tmp_expired_at', '!=', '0000-00-00 00:00:00') ->where('pwd_tmp_expired_at', '<=', $today) ->exists(); if ($expired) return redirect()->back()->withInput()->withErrors('仮パスワードの有効期限が切れました。管理者にお問合せください。'); } $state_gauth = $request->session()->get('gauth'); $next = $request->input('next'); $ip = long2ip($ip_int); if ($this->using_gauth($org, $user, $ip) && $state_gauth && $next === 'gauth') return $this->from_gauth_form($request); return $this->from_general_form($request, $org, $user, $ip_int); } private function from_general_form($request, $org, $user, $ip_int) { $org = strtolower($org); $user = strtolower($user); $logintxt = $request->input('username'); $current_pwd = $request->input('current_pwd'); $pwd1 = $request->input('pwd1'); $pwd2 = $request->input('pwd2'); $ip = long2ip($ip_int); $this->parse_logintxt($logintxt, $org, $user); if ($logintxt === '') return redirect()->back()->withInput()->withErrors('ユーザ名を入力してください'); if ($user === 'scvtemplate') return redirect()->back()->withErrors('指定ユーザのパスワードはクライアントから変更することはできません。'); PasswordUpdator::authenticate($org, $user, $current_pwd); PasswordUpdator::validate_changeable($org, $user, $pwd1, $pwd2); $scvuser = Scvuser::with_org($org, $user); if ($this->using_gauth($org, $user, $ip)) { $request->session()->flash('gauth', 1); $request->session()->flash('userid', $scvuser->id); $request->session()->flash('new_pwd', $pwd1); return view('user_account.gauth', compact('org', 'user', 'ip_int')); } else { return $this->change_password($scvuser, $pwd1); } } private function from_gauth_form($request) { $userid = $request->session()->get('userid'); $new_pwd = $request->session()->get('new_pwd'); $totp = $request->input('password'); $scvuser = Scvuser::find($userid); $org = strtolower($scvuser->organization); $user = strtolower($scvuser->name); $ip_int = $request->input('ip_int'); if (!$this->attempt_gauth($scvuser, $totp, $errmsg)) { $request->session()->reflash(); return view('user_account.gauth', compact('org', 'user', 'ip_int'))->withErrors($errmsg); } return $this->change_password($scvuser, $new_pwd); } private function using_gauth($org, $user, $ip) { $org = strtolower($org); $user = strtolower($user); if ($org === 'admin' && $user === 'scvtemplate') return false; $auth = ConfHelper::active_auth($ip); return $auth === 'scvxlocal_ga'; } private function change_password($scvuser, $pwd) { if (!PasswordUpdator::change_password($scvuser, $pwd, $errmsg)) return redirect()->back()->withErrors($errmsg); $slave_dbret = 0; if (CH::needsToSyncSlave()) $slave_dbret = CH::updateScvuserToSlaveDB($scvuser); CH::update_clusters_if_necessary(true, $slave_dbret); return redirect(\Request::url())->with('success', 'パスワードを変更しました'); } private function attempt_gauth($scvuser, $password, &$errmsg) { $gm = new GAuthManager($scvuser); if ($gm->get_secretkey() === '') { $errmsg = '認証用の秘密鍵が見つかりませんでした'; return false; } if (!$gm->verify_password($password)) { $errmsg = 'ワンタイムパスワードが一致しません'; return false; } return true; } private function parse_logintxt($logintxt, &$org, &$user) { $prms = explode('/', $logintxt); if (count($prms) === 1) { $org = 'ADMIN'; $user = $prms[0]; } else { $org = strtoupper($prms[0]); $user = $prms[1]; } } } 