<?php
 namespace App\Http\Controllers; use App\Http\Requests\UserRequest; use App\Http\Controllers\Controller; use App\User; use App\Organization; use App\AdminPolicy; use Mail; use Hash; use App\Libs\ClusterHelper as CH; use App\Libs\UserHelper as UH; use App\Libs\AdminPasswordHelper; class UsersController extends Controller { public function index() { $query = User::leftjoin('organizations','users.organization_id', 'organizations.id'); if (!UH::isAdmin()) { $org_id = UH::login_user()->organization_id; $query->where('organizations.id', $org_id); } $users = $query->select('users.*', 'organizations.name')->get(); $is_admin = UH::isAdmin(); return view('users.index', compact('users', 'is_admin')); } public function create() { UH::abort_ifnot_admin(); $organizations = Organization::all(); return view('users.create', compact('organizations')); } public function store(UserRequest $request) { UH::abort_ifnot_admin(); $errmsgs = []; $user = new User; $user->username = $request->input('username'); $user->organization_id = $request->input('organization'); $user->email = $request->input('email'); $user->password = bcrypt($request->input('password')); $added_generations = ""; if (AdminPolicy::existSetting($user->organization_id)) { $aph = new AdminPasswordHelper($user->organization_id, $user->username); if(!$aph->registerable($request->input('password'), $errmsgs)) { return redirect()->back()->withErrors($errmsgs); } $salt = $aph->generate_salt(); $hash = $aph->generate_hash($request->input('password'), $salt); $added_generations = $hash; } else { if (strlen($user->password) < 4 || strlen($user->pasword) > 32) { return redirect()->back()->withErrors("パスワードは4文字から32文字で入力してください。"); } } $user->pwd_generations = $added_generations; $user->pwd_reset_at = date('Y-m-d H:i:s'); $dbret = $user->save(); $slave_dbret = 0; if (CH::needsToSyncSlave()) { $slaveuser = new User; $slaveuser->setConnection('slave_database'); $slaveuser->id = $user->id; $slaveuser->username = $user->username; $slaveuser->organization_id = $user->organization_id; $slaveuser->email = $user->email; $slaveuser->password = $user->password; $slaveuser->pwd_generations = $user->pwd_generations; $slaveuser->pwd_reset_at = $user->pwd_reset_at; $slave_dbret = $slaveuser->save(); } CH::update_clusters_if_necessary($dbret, $slave_dbret); return redirect()->to('/scvmanager/users'); } public function show(UserRequest $request, $name) { $user = User::where('username', $name)->first(); if ($user === null) abort(404); $is_admin = UH::isAdmin(); if (!$is_admin) { $org_id = UH::login_user()->organization_id; if ($user->organization_id !== $org_id) { abort(403); } } return view('users.show', compact('user', 'is_admin')); } public function edit(UserRequest $request, $name) { $user = User::where('username', $name)->first(); if ($user === null) abort(404); if (!empty(\Auth::user()->tmp_pwd) && \Auth::user()->username !== $user->username ) { return abort(403); } $is_admin = UH::isAdmin(); if (!$is_admin) { $org_id = UH::login_user()->organization_id; if ($user->organization_id !== $org_id) { abort(403); } } return view('users.edit', compact('user')); } public function update(UserRequest $request) { $errmsgs = []; $name = $request->input('username'); $email = $request->input('email'); $pwd = $request->input('password'); $user = User::where('username', $name)->first(); $user->email = $email; $added_generations = ""; if (AdminPolicy::existSetting($user->organization_id)) { $aph = new AdminPasswordHelper($user->organization_id, $user->username); if(!$aph->changeable($request->input('password'), $errmsgs)) { return redirect()->back()->withErrors($errmsgs); } $salt = $aph->generate_salt(); $hash = $aph->generate_hash($pwd, $salt); $added_generations = $aph->get_added_new_generations($hash); } else { if (strlen($pwd) < 4 || strlen($pwd) > 32) { return redirect()->back()->withErrors("パスワードは4文字から32文字で入力してください。"); } } if ($pwd !== '') { $user->password = bcrypt($pwd); } $user->pwd_generations = $added_generations; $user->pwd_reset_at = date('Y-m-d H:i:s'); $user->reset = 0; $user->tmp_pwd = ""; $dbret = $user->save(); $slave_dbret = 0; if(CH::needsToSyncSlave()) { $slavemodel = new User; $slavemodel->setConnection('slave_database'); $slaveuser = $slavemodel->find($user->id); $slaveuser->email = $user->email; $slaveuser->password = $user->password; $slaveuser->pwd_generations = $user->pwd_generations; $slaveuser->pwd_reset_at = $user->pwd_reset_at; $slaveuser->reset = 0; $slaveuser->tmp_pwd = ""; $slave_dbret = $slaveuser->save(); } CH::update_clusters_if_necessary($dbret, $slave_dbret); \Session::flash('flash_msg', '<p class="text-success">変更しました。</p>'); return redirect()->to('/scvmanager/users/' . $user->username); } public function destroy(UserRequest $request, $id) { UH::abort_ifnot_admin(); $user = User::find($id); $dbret = $user->delete(); $slave_dbret = 0; if(CH::needsToSyncSlave()) { $slavemodel = new User; $slavemodel->setConnection('slave_database'); $slaveuser = $slavemodel->find($id); $slave_dbret = $slaveuser->delete(); } CH::update_clusters_if_necessary($dbret, $slave_dbret); return redirect()->to('/scvmanager/users'); } } 