<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use App\Shareprofile; use App\Visionprofile; use App\AllowAppList; use App\AppSetting; use App\Revodesktop; use App\Scvgroup; use App\Libs\Utils; use App\Libs\ClusterHelper as CH; use App\Models\ProxySetting; use App\Models\Wallpaper; use App\VpnSetting; use Illuminate\Support\Facades\DB; class VisionprofController extends Controller { const VOLUME_MAX_CONFIG_KEY = 'scv.dt_volume_max'; public function index() { $visionprofiles = Visionprofile::all(); return view('visionprof.index', compact('visionprofiles')); } public function show($id) { $visionprofile = Visionprofile::findOrFail($id); $allowed_apps = AllowAppList::getAllowAppListByDtSettings($id); $shareprofile = Shareprofile::getShareProfileWithOrgById($visionprofile->shareprofile_id); $shortcut_list = AllowAppList::getShortcutsByDtSettings($id); $proxySetting = ProxySetting::find($visionprofile->proxy_setting_id); $wallpaper = Wallpaper::find($visionprofile->wallpaper_id) ?: Wallpaper::getDefault(); return view('visionprof.show', compact('visionprofile', 'allowed_apps', 'shortcut_list', 'shareprofile', 'proxySetting', 'wallpaper')); } public function create() { $visionprofile = new Visionprofile; $visionprofile->wallpaper_id = 0; $volume_max = config(self::VOLUME_MAX_CONFIG_KEY); $shareprofiles = Shareprofile::getShareProfileWithOrg(); $proxysettings = ProxySetting::getAllProxySettingIDandName(); $wallpapers = Wallpaper::getAllSummariesWithDefault(); $vpn_settings = VpnSetting::all(); return view('visionprof.create', compact('visionprofile', 'volume_max', 'shareprofiles', 'proxysettings', 'wallpapers', 'vpn_settings')); } public function edit($id) { $visionprofile = Visionprofile::findOrFail($id); $allowed_apps = AllowAppList::getAllowAppListByDtSettings($id); $denied_apps = AppSetting::getDeniedAppsByDtAppNames($allowed_apps->all()); $shareprofiles = Shareprofile::getShareProfileWithOrg(); $shortcut_list = AllowAppList::getShortcutsByDtSettings($id); $proxysettings = ProxySetting::getAllProxySettingIDandName(); $wallpapers = Wallpaper::getAllSummariesWithDefault(); $vpn_settings = VpnSetting::all(); return view('visionprof.edit', compact('visionprofile', 'allowed_apps', 'denied_apps', 'shortcut_list','shareprofiles', 'proxysettings', 'wallpapers', 'vpn_settings')); } public function store(Request $req) { $params = $req->all(); $params = $this->process_params($params); $volumeMax = config(self::VOLUME_MAX_CONFIG_KEY); $allowed_apps = Utils::split_by_comma($req->allowed_apps); $denied_apps = Utils::split_by_comma($req->denied_apps); $shortcut_settings = $req->shortcut_settings; if ($params['name'] === '') { return redirect()->back()->withInput()->with(['volume_max' => $volumeMax, 'allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('デスクトップ設定名を入力してください。'); } if ($this->name_exists($params['name'])) { return redirect()->back()->withInput()->with(['volume_max' => $volumeMax, 'allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('既に同名のデスクトップ設定が存在しています。'); } if ($this->name_invalid_length($params['name'])) { return redirect()->back()->withInput()->with(['volume_max' => $volumeMax, 'allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('デスクトップ設定名は3文字から32文字で入力してください。'); } if ($this->name_invalid_chars($params['name'])) { return redirect()->back()->withInput()->with(['volume_max' => $volumeMax, 'allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('デスクトップ設定名に使用できない文字が含まれています。'); } if ($params['volume_mb'] > $volumeMax) { return redirect()->back()->withInput()->with(['volume_max' => $volumeMax, 'allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors("ボリュームサイズは${volumeMax}以下を指定してください。"); } if (!empty($params['vpn_ipaddr']) && $this->ip_address_notation_valid_is($params['vpn_ipaddr'])) { return redirect()->back()->withInput()->with(['volume_max' => $volumeMax, 'allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('VPNサーバアドレス(ローカル)の入力形式が異なっているか、無効な文字が入力されています。'); } if (!empty($params['global_vpn_ipaddr']) && $this->global_ip_address_notation_valid_is($params['global_vpn_ipaddr'])) { return redirect()->back()->withInput()->with(['volume_max' => $volumeMax, 'allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('VPNサーバアドレス(グローバル)の入力形式が異なっているか、無効な文字が入力されています。'); } if (!empty($params['vpn_nic_name']) && $this->is_valid_vpn_nic_name($params['vpn_nic_name'])) { return redirect()->back()->withInput()->with(['volume_max' => $volumeMax, 'allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('VPNインターフェース名に使用できない文字が含まれています。'); } if (!empty($params['dns_server_ipaddr']) && $this->ip_address_notation_valid_is($params['dns_server_ipaddr'])) { return redirect()->back()->withInput()->with(['volume_max' => $volumeMax, 'allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('DNSサーバアドレスの入力形式が異なっているか、無効な文字が入力されています。'); } if (empty($allowed_apps)) { return redirect()->back()->withInput()->with(['volume_max' => $volumeMax, 'allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('必ず1つ以上許可アプリを設定してください。'); } $visionprofile = Visionprofile::create($params); if(!$visionprofile){ return redirect()->back()->withInput()->withErrors('設定の保存に失敗しました。'); } if(empty($shortcut_settings)) { $shortcut_settings = []; } $slave_allowed_app_list = ""; if(CH::isCluster()) { if(CH::isMasterActive()) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slave_allowed_app_list = new AllowAppList; $slave_allowed_app_list->setConnection('slave_database'); } } } foreach ($allowed_apps as $allowed_app ) { $shortcut_flag = 0; if(in_array($allowed_app, $shortcut_settings)){ $shortcut_flag = 1; } $allowed_ret = AllowAppList::updateOrCreate( ['appname' => $allowed_app, 'dt_id' => $visionprofile->id], ['appname' => $allowed_app, 'dt_id' => $visionprofile->id, 'enabled' => true, 'shortcut' => $shortcut_flag] ); if(CH::isCluster()) { if(CH::isMasterActive() && !empty($allowed_ret)) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slave_allowed_ret = $slave_allowed_app_list->updateOrCreate ( ['appname' => $allowed_app, 'dt_id' => $visionprofile->id], ['appname' => $allowed_app, 'dt_id' => $visionprofile->id, 'enabled' => true, 'shortcut' => $shortcut_flag] ); } } CH::updateClusters(!empty($slave_allowed_ret->id), !empty($slave_allowed_ret->id)); } } return redirect('scvmanager/visionprof')->with('success', '設定を作成しました。'); } public function update(Request $req, $id) { $params = $req->all(); $params = $this->process_params($params); $allowed_apps = Utils::split_by_comma($req->allowed_apps); $denied_apps = Utils::split_by_comma($req->denied_apps); $shortcut_settings = $req->shortcut_settings; if ($params['name'] === '') { return redirect()->back()->withInput()->with(['allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('デスクトップ設定名を入力してください。'); } if (!$this->name_exists($params['name'])) { return redirect()->back()->withInput()->with(['allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('デスクトップ設定が存在しません。'); } if ($this->name_invalid_length($params['name'])) { return redirect()->back()->withInput()->with(['allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('デスクトップ設定名は3文字から32文字で入力してください。'); } if ($this->name_invalid_chars($params['name'])) { return redirect()->back()->withInput()->with(['allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('デスクトップ設定名に使用できない文字が含まれています。'); } if (!empty($params['vpn_ipaddr']) && $this->ip_address_notation_valid_is($params['vpn_ipaddr'])) { return redirect()->back()->withInput()->with(['allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('VPNサーバアドレス(ローカル)の入力形式が異なっているか、無効な文字が入力されています。'); } if (!empty($params['global_vpn_ipaddr']) && $this->global_ip_address_notation_valid_is($params['global_vpn_ipaddr'])) { return redirect()->back()->withInput()->with(['allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('VPNサーバアドレス(グローバル)の入力形式が異なっているか、無効な文字が入力されています。'); } if (!empty($params['vpn_nic_name']) && $this->is_valid_vpn_nic_name($params['vpn_nic_name'])) { return redirect()->back()->withInput()->with(['allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('VPNインターフェース名に使用できない文字が含まれています。'); } if (!empty($params['dns_server_ipaddr']) && $this->ip_address_notation_valid_is($params['dns_server_ipaddr'])) { return redirect()->back()->withInput()->with(['allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('DNSサーバアドレスの入力形式が異なっているか、無効な文字が入力されています。'); } if (empty($allowed_apps)) { return redirect()->back()->withInput()->with(['allowed_apps' => $allowed_apps, 'denied_apps' => $denied_apps, 'backed' => true ])->withErrors('必ず1つ以上許可アプリを設定してください。'); } $visionprofile = Visionprofile::updateSetting($params, $id); if (!$visionprofile) { return redirect()->back()->withInput()->withErrors('設定の変更に失敗しました。'); } if(empty($shortcut_settings)) { $shortcut_settings = []; } $slave_allowed_app_list = ""; $slave_denied_app_list = ""; if(CH::isCluster()) { if(CH::isMasterActive()) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slave_allowed_app_list = new AllowAppList; $slave_allowed_app_list->setConnection('slave_database'); $slave_denied_app_list = new AllowAppList; $slave_denied_app_list->setConnection('slave_database'); } } } foreach ($denied_apps as $denied_app ) { $denied_ret = AllowAppList::updateOrCreate( ['appname' => $denied_app, 'dt_id' => $id], ['appname' => $denied_app, 'dt_id' => $id, 'enabled' => false, 'shortcut' => 0] ); if(CH::isCluster()) { if(CH::isMasterActive() && !empty($denied_ret)) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slave_denied_ret = $slave_denied_app_list->updateOrCreate ( ['appname' => $denied_app, 'dt_id' => $id], ['appname' => $denied_app, 'dt_id' => $id, 'enabled' => false] ); } } CH::updateClusters(!empty($denied_ret->id), !empty($slave_denied_ret->id)); } } foreach ($allowed_apps as $allowed_app ) { $shortcut_flag = 0; if(in_array($allowed_app, $shortcut_settings)){ $shortcut_flag = 1; } $allowed_ret = AllowAppList::updateOrCreate( ['appname' => $allowed_app, 'dt_id' => $id], ['appname' => $allowed_app, 'dt_id' => $id, 'enabled' => true, 'shortcut' => $shortcut_flag] ); if(CH::isCluster()) { if(CH::isMasterActive() && !empty($allowed_ret)) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slave_allowed_ret = $slave_allowed_app_list->updateOrCreate ( ['appname' => $allowed_app, 'dt_id' => $visionprofile->id], ['appname' => $allowed_app, 'dt_id' => $visionprofile->id, 'enabled' => true, 'shortcut' => $shortcut_flag] ); } } CH::updateClusters(!empty($allowed_ret->id), !empty($slave_allowed_ret->id)); } } return redirect('scvmanager/visionprof')->with('success', '設定を変更しました。'); } public function destroy($id) { $visionprofile = Visionprofile::find($id); if ($visionprofile === null) { return redirect()->back()->withErrors('デスクトップ設定が存在しません。'); } if ($this->used_by_revodesktop_or_scvgroup($visionprofile->name)) { return redirect()->back()->withErrors('使用中のデスクトップ設定は削除できません。'); } $dbret = Visionprofile::destroy($id); if (0 == $dbret) { return redirect()->back()->withErrors('設定の削除に失敗しました。'); } $delete_app_ret= AllowAppList::where('dt_id', $id, '=')->delete(); $slave_delete_app_ret = ""; if(CH::isCluster()) { if(CH::isMasterActive() && !empty($delete_app_ret)) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slave_allow_app_list = new AllowAppList; $slave_allow_app_list->setConnection('slave_database'); $slave_delete_app_ret = $slave_allow_app_list->where('dt_id', $id, '=')->delete(); } } CH::updateClusters(!empty($delete_app_ret->id), !empty($slave_delete_app_ret->id)); } return redirect('scvmanager/visionprof')->with('success', '設定を削除しました。'); } private function process_params($params) { $params['allowed_hosts'] = trim($params['allowed_hosts']); $params['allowed_hosts'] = preg_replace("/[\r\n]+/", "\n", $params['allowed_hosts']); $params['name'] = strtoupper($params['name']); $vpn_settings = array(); if (!isset($params['vpn_settings'])) { $params['vpn_settings'] = null; } else { foreach ($params['vpn_settings'] as $key => $value) { $vpn_settings[$key] = [ 'order' => $value]; } } $params['vpn_settings'] = $vpn_settings; return $params; } private function name_invalid_length($name) { $len = mb_strlen($name); return $len <= 2 || $len >= 33; } private function name_invalid_chars($name) { return !preg_match('/^[A-Za-z0-9]+[A-Za-z0-9_\\.\\-]+$/', $name); } private function name_exists($name) { return Visionprofile::where('name', $name)->exists(); } private function used_by_revodesktop_or_scvgroup($visionprofile_name) { return $this->used_by_revodesktop($visionprofile_name) || $this->used_by_scvgroup($visionprofile_name); } private function used_by_revodesktop($visionprofile_name) { return Revodesktop::where('dtname', $visionprofile_name) ->where('dtstatus', '<>', 'DELETED') ->exists(); } private function used_by_scvgroup($visionprofile_name) { $scvgroups = Scvgroup::all(); foreach ($scvgroups as $scvgroup) { $joined = $scvgroup->visionprofile_list; $visionprofile_names = Utils::split_by_comma($joined); foreach ($visionprofile_names as $name) { if ($name === $visionprofile_name) return true; } } return false; } private function ip_address_notation_valid_is($ipaddr) { $regex = '/^(([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/'; return !preg_match($regex, $ipaddr); } private function global_ip_address_notation_valid_is($global_ipaddr) { $regex = '/^(([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]):([1-9][0-9]{4}|[1-9][0-9]{3}|[1-9][0-9]{2}|[1-9][0-9]{1})$/'; if(preg_match($regex, $global_ipaddr)) { $port_number = explode(':', $global_ipaddr); if(intval($port_number[1]) < 65536 && intval($port_number[1]) > 9) { return false; } } return true; } private function is_valid_vpn_nic_name($nic_name) { $regex ='/^\w*$/'; return !preg_match($regex, $nic_name); } } 