<?php
declare(strict_types = 1); namespace App\Http\Controllers; use App\Http\Requests\WallpaperRequest; use App\Models\Wallpaper; use Exception; use InvalidArgumentException; class WallpaperController extends Controller { public function index() { $wallpapers = Wallpaper::getAllSummaries(); return view('wallpaper.index', [ 'wallpapers' => $wallpapers ]); } public function store(WallpaperRequest $request) { try { $realPath = $request->file('wallpaper')->getRealPath(); $content = $this->readFile($realPath); $model = new Wallpaper([ 'filename' => $request->input('filename'), 'mimetype' => $request->input('mimetype'), 'size' => strlen($content), 'style' => Wallpaper::INITIAL_STYLE, 'content' => $content, ]); Wallpaper::create($model->toArray()); } catch (Exception $e) { return redirect()->back()->with('err', $e->getMessage()); } return redirect()->route('wallpaper.index'); } public function edit(int $id) { $model = Wallpaper::find($id); return view('wallpaper.edit', [ 'wallpaper' => $model, 'styles' => Wallpaper::STYLES ]); } public function update(WallpaperRequest $request, int $id) { $model = Wallpaper::find($id); $model->fill([ 'style' => $request->input('style') ]); Wallpaper::updateWallpaper($model->toArray(), $model->id); return redirect()->route('wallpaper.index'); } public function destroy( WallpaperRequest $request, int $id ) { $isSuccess = Wallpaper::destroy($id); if (!$isSuccess) { return redirect()->back()->with('err', '削除に失敗しました。'); } return redirect()->route('wallpaper.index'); } private function readFile(string $path): string { $size = filesize($path); if ($size <= 0) { throw new InvalidArgumentException('ファイルが空です。'); } $handle = fopen($path, 'rb'); try { $content = fread($handle, filesize($path)); } finally { fclose($handle); } if (!$content) { throw new InvalidArgumentException('ファイルの取得に失敗しました。'); } return $content; } } 