<?php
declare(strict_types = 1); namespace App\Http\Controllers; use App\Models\Wallpaper; use Illuminate\Http\JsonResponse; use Illuminate\Http\Response; use SplFileObject; class WallpaperDownloadController extends Controller { use \App\Traits\api\ApiHelper; public function download(int $id) { $model = Wallpaper::find($id); if (is_null($model)) { abort(Response::HTTP_NOT_FOUND); } $content = $model->content; $mimetype = $model->mimetype; $filename = $model->filename; $callback = function () use ($content) { $file = new SplFileObject('php://output', 'w'); $file->fwrite($content); $file->fflush(); }; $headers = [ 'Content-Type' => $mimetype, 'Content-Disposition' => 'inline; filename="' . $filename . '"', 'Content-Transfer-Encoding' => 'binary', ]; return response()->stream($callback, Response::HTTP_OK, $headers); } public function downloadAsJson(int $id) { $model = Wallpaper::find($id); if (is_null($model)) { abort(JsonResponse::HTTP_NOT_FOUND); } $content = $model->content; $size = strlen($content); $encoded = base64_encode($content); $response = $this->getTemplateObject(); $response->filename = $model->filename; $response->mimetype = $model->mimetype; $response->filesize = $size; $response->style = $model->style; $response->encoded_content = $encoded; return $this->apiResponse($response, $this->API_SUCCESS); } } 