<?php
 namespace App\Http\Controllers\revobr; use App\Http\Controllers\Controller; use Illuminate\Http\Request; use App\Http\Requests\revobr\CommonRequest; use App\Http\Requests\revobr\UpdatelogRequest; use App\Scvgroup; use App\Models\ProxySetting; use App\revobr\BrUpdatePolicy as BUP; use App\revobr\BrUpdateModule; use App\revobr\Updaterlog; class RevoBrCommonController extends Controller { use \App\Traits\api\ApiHelper; public function version() { $j_obj = $this->getTemplateObject(); $versions = BrUpdateModule::getSpecifiedModulesVersion(); $j_obj->client_specified_version = $versions->client; $j_obj->updater_specified_version = $versions->updater; $j_obj->firefox_specified_version = $versions->firefox; $j_obj->chrome_specified_version = $versions->chrome; $j_obj->extension_specified_version = $versions->extension; return $this->apiResponse($j_obj, $this->API_SUCCESS); } public function download($version = null) { $path = "/var/www/html/scv/revobr/kits/"; if($version){ $client_path = $path."clients/"."revobr_".$version.".zip"; }else{ if(basename(url()->current()) == "client"){ $module = BrUpdateModule::where('specified', 1)->where('type', BrUpdateModule::MODULE_TYPE_CLIENT)->first(); }else if(basename(url()->current()) == "updater"){ $module = BrUpdateModule::where('specified', 1)->where('type', BrUpdateModule::MODULE_TYPE_UPDATER)->first(); }else if(basename(url()->current()) == "firefox"){ $module = BrUpdateModule::where('specified', 1)->where('type', BrUpdateModule::MODULE_TYPE_FIREFOX)->first(); }else if(basename(url()->current()) == "chrome"){ $module = BrUpdateModule::where('specified', 1)->where('type', BrUpdateModule::MODULE_TYPE_CHROME)->first(); }else if(basename(url()->current()) == "extension"){ $module = BrUpdateModule::where('specified', 1)->where('type', BrUpdateModule::MODULE_TYPE_EXTENSION)->first(); } if($module === null){ return $this->badRequestResponse(); } $client_path = $module->save_location; } return response()->download($client_path); } public function updateLog(UpdatelogRequest $request) { $params = $request->filter(); $ret = Updaterlog::create($params); $j_obj = $this->getTemplateObject(); if($ret){ return $this->apiResponse($j_obj, $this->API_SUCCESS); }else{ return $this->apiResponse($j_obj, $this->API_INTERNAL_SERVER_ERROR); } } private function ipCheck($cidr, $ip) { list($accept_ip, $mask) = explode('/', $cidr); $accept_long = ip2long($accept_ip) >> (32 - $mask); $remote_long = ip2long($ip) >> (32 - $mask); if ($accept_long == $remote_long) { return true; }else{ return false; } } private function policyMatching($params) { $policies = BUP::where('match_type', '!=', 0)->orderBy('order')->get(); foreach ($policies as $policy) { if($policy->match_type == BUP::MATCH_TYPE_IPV4){ if(!isset($params['ip'])){ break; } if($this->ipCheck($policy->match_value, $params['ip'])){ return $policy->getOriginal(); } } if($policy->match_type == BUP::MATCH_TYPE_HOSTNAME){ if(!isset($params['hostname'])){ break; } if(strpos($params['hostname'], $policy->match_value) !== false){ return $policy->getOriginal(); } } if($policy->match_type == BUP::MATCH_TYPE_SCVGROUP){ if(!isset($params['organization']) && !isset($params['user'])){ break; } $org = $params['organization'] ?: ''; $user = $params['user'] ?: ''; if($org == '' || $user == '') break; $group = Scvgroup::getGroupByUserAndOrg($org, $user); if(!$group) break; if($group->name == strtoupper($policy->match_value)){ return $policy->getOriginal(); } } } $default_pol = BUP::where('match_type', 0)->first(); return $default_pol ? $default_pol->getOriginal() : null ; } public function policy(CommonRequest $request) { $j_obj = $this->getTemplateObject(); $j_obj->return = $this->policyMatching($request->all()); return $this->apiResponse($j_obj, $this->API_SUCCESS); } private function formatBrSettingForApi($br_setting, $j_obj) { if(!$br_setting){ return $j_obj; } return $br_setting->formatForApi($j_obj); } public function getSettings($id) { $j_obj = $this->getTemplateObject(); $user = \Auth::user(); if($user->id != $id) return $this->apiResponse($j_obj, $this->API_BAD_REQUEST); $exp_url = explode('/', url()->current()); $browser = $exp_url[sizeof($exp_url)-2]; $group = Scvgroup::find($user->groupid); if($browser == "browser"){ $j_obj = $this->formatBrSettingForApi($group->brSetting, $j_obj); }else{ $origin = $group->firefoxprofile; if ($origin) { $prof = $origin->only([ 'xff_flag', 'pauth_flag', 'pauth_user', 'pauth_pass', 'proxy_type', 'http_proxy_host', 'http_proxy_port', 'ssl_proxy_host', 'ssl_proxy_port', 'no_proxy_host', 'proxy_url' ]); $prof['xff_flag'] = (boolean)$prof['xff_flag']; $prof['pauth_flag'] = (boolean)$prof['pauth_flag']; $prof['pauth_pass'] = $origin['pauth_pass_cipher']; } else { $prof['xff_flag'] = false; $prof['pauth_flag'] = false; $prof['pauth_user'] = ""; $prof['pauth_pass'] = ""; $prof['proxy_type'] = 0; $prof['http_proxy_host'] = "0"; $prof['http_proxy_port'] = 0; $prof['ssl_proxy_host'] = "0"; $prof['ssl_proxy_port'] = 0; $prof['no_proxy_host'] = ""; $prof['proxy_url'] = ""; } $prof['copy_paste'] = $group->copypaste; $j_obj->settings = $prof; } return $this->apiResponse($j_obj, $this->API_SUCCESS); } } 