<?php
 namespace App\Http\Controllers\revodt; use Illuminate\Http\Request; use App\Http\Controllers\Controller; use App\Revodesktop; use App\AppPath; use App\AppSetting; use App\AllowAppList; use App\Libs\RevoDtApps; use App\Libs\Utils; use App\Libs\ConfHelper; use App\Visionprofile; use App\Http\Requests\revodt\RevodtApiRequest; use App\Models\ProxySetting; use App\Models\Wallpaper; class RevodtApiController extends Controller { use \App\Traits\api\ApiHelper; public function set_client_infos() { logger('---- api/v1/revodt/set_client_infos called'); $pcname = $this->get_param_or_fail('pcName'); $installed_apps = $this->get_param_or_fail('installedApps', false); $revodesktop = Revodesktop::by_pcnameOrFail($pcname); $revodesktop->installed_apps = json_encode($installed_apps, JSON_UNESCAPED_UNICODE); $revodesktop->save(); Revodesktop::update_installed_apps_as_json($pcname, $installed_apps); $res = $this->getTemplateObject(); $res->message = 'Succeed in storing the installed apps info.'; return $this->apiResponse($res, $this->API_SUCCESS); } public function get_available_apps() { logger('---- api/v1/revodt/get_available_apps called'); $dtname = $this->get_param_or_fail('dtName'); $pcname = $this->get_param_or_fail('pcName'); $installed_apps = Revodesktop::by_pcnameOrFail($pcname)->installed_app_array; $available_apps = RevoDtApps::by_dtname($dtname)->get_available_apps($installed_apps); logger(count($available_apps) . "' available apps are found."); $res = $this->getTemplateObject(); $res->message = 'Succeed in getting the available apps info.'; $res->availableApps = $available_apps; return $this->apiResponse($res, $this->API_SUCCESS); } public function saveClientApps(Request $request) { $pcname = $request->pcname; $installed_apps = $request->installed_apps; Revodesktop::update_installed_apps_as_json($pcname, $installed_apps); $res = $this->getTemplateObject(); $res->message = 'Succeed in storing the installed apps info.'; return $this->apiResponse($res, $this->API_SUCCESS); } public function getAllowedApps(Request $request) { $dtname = $request->dtname; $pcname = $request->pcname; $installed_apps = Revodesktop::by_pcnameOrFail($pcname)->installed_app_array; $available_apps = RevoDtApps::by_dtname($dtname)->get_available_apps($installed_apps); $app_paths = AppPath::getAppPathsByAppnames($available_apps); $create_shortcuts = AllowAppList::getShortcutsByDtSettings(Visionprofile::getVisionprofileByName($dtname)->id); $res = $this->getTemplateObject(); $res->message = 'Succeed in getting the available apps info.'; $res->availableApps = $available_apps; $res->app_path = $app_paths; $res->create_shortcuts = $create_shortcuts; return $this->apiResponse($res, $this->API_SUCCESS); } private function get_param_or_fail($key, $logging = true) { static $params = null; if ($params === null) $params = Utils::parse_json_request(); if (!isset($params[$key])) { throw new \Exception("JSON param '{$key}' not existed."); } if ($logging) logger("JSON param '{$key}'=" . $params[$key]); else logger("JSON param '{$key}'=*hidden*"); return $params[$key]; } public function getDesktopSettings(RevodtApiRequest $request) { $ret = $this->getTemplateObject(); $user = \Auth::user(); $ip = $request->ip; $host = $request->host; $ret->clustid = ConfHelper::scvconf('SCV_CLUSTID'); $ret->auth = ConfHelper::getAuthMode($ip); $ret->scvuserid = $user->id; $scvgroup = $user->scvgroup; $v_profs = $scvgroup->visionprofile_list; $v_profs = explode(',', $v_profs); $dtnames = []; foreach ($v_profs as $prof_name) { $prof = Visionprofile::where('name', $prof_name)->first(); $s_prof_id = $prof->shareprofile_id; $proxySettingId = $prof->proxy_setting_id; $wallpaper_urls = $this->getWallpaperUrls($prof->wallpaper_id); $vpn_settings = $prof->vpnSettings; $vpn_settings = $vpn_settings->map(function ($item, $key) { return $item->only([ 'name', 'global_address', 'local_address', 'interface_name', 'dns_servers', 'allowed_hosts' ]); })->toArray(); if($prof){ $prof = $prof->only(['name', 'volume_mb']); } $dts = Revodesktop::where('pcname', $host) ->where('dtname', $prof['name']) ->where('uid', $user->id) ->first(); $s_prof = \App\Shareprofile::find($s_prof_id); if($s_prof!=null){ $s_prof = $s_prof->only([ 'sharename1', 'sharedom1', 'read_only1', 'use_scvuser1', 'shareusr1', 'sharepwd1', 'sharename2', 'sharedom2', 'read_only2', 'use_scvuser2', 'shareusr2', 'sharepwd2', ]); } else { $s_prof = null; } $proxySetting = ProxySetting::find($proxySettingId, ['name', 'proxy_host', 'proxy_port', 'proxy_exceptions']); $prof['dtstatus'] = $dts ? $dts->dtstatus : ""; $prof += $wallpaper_urls; $share['share'] = $s_prof; $proxy['proxy_setting'] = $proxySetting; $vpn['vpn_settings'] = $vpn_settings; $dtnames[] = $prof + $share + $proxy + $vpn; } $ret->dtnames = $dtnames; return $this->apiResponse($ret, $this->API_SUCCESS); } public function updateDesktopStatus(Request $request) { $user = \Auth::user(); $uid = $user->id; $org = $user->organization; $name = $user->name; $pcname = $request->pcname; $dtname = $request->dtname; $stat = $request->stat; $cmd = "revodtstat -upd $org/$name $pcname $uid $dtname $stat"; exec($cmd, $out); $ret = $this->getTemplateObject(); $ret->message = isset($out[0]) ? $out[0] : ""; return $this->apiResponse($ret, $this->API_SUCCESS); } private function getWallpaperUrls(int $wallpaperId): array { $wallpaperFileUrl = null; $wallpaperJsonUrl = null; if (!is_null($wallpaperId)) { $model = Wallpaper::find($wallpaperId); if (!is_null($model)) { $wallpaperFileUrl = $model->apiFileUrl; $wallpaperJsonUrl = $model->apiJsonUrl; } } return [ 'wallpaper_file_url' => $wallpaperFileUrl, 'wallpaper_json_url' => $wallpaperJsonUrl, ]; } private function getCreateShortcuts($allowed_apps, $shortcuts) { Utils::extract_in_array( $allowed_apps, $shortcuts, $create_shortcuts, $dummy ); return $create_shortcuts; } } 