<?php
namespace App\Http\Controllers\scvapi; use Illuminate\Http\Request; use App\Http\Requests; use App\Http\Controllers\Controller; use App\Libs\ConfHelper; use App\Libs\ClusterHelper; use App\Libs\GAuthManager; use App\Scvuser; use PDO; class GAuthController extends Controller { use \App\Traits\ApiHelper; public function login(Request $req) { $params = get_json_post(); $org = isset($params['organization']) ? $params['organization'] : null; $user = isset($params['user']) ? $params['user'] : null; $totp = isset($params['password']) ? $params['password'] : null; if ($org === null || $user === null || $totp === null) return $this->api_response(false, '組織名、ユーザ名、パスワードは必須項目です', ['otpwd' => '']); $scvuser = Scvuser::with_org($org, $user); if ($scvuser === null) return $this->api_response(false, 'ユーザが存在しません', ['otpwd' => '']); if (!preg_match('/^[0-9]{3} ?[0-9]{3}$/u', $totp)) return $this->api_response(false, 'パスワードは6桁の数字で入力してください', ['otpwd' => '']); $gm = new GAuthManager($scvuser); if ($gm->get_secretkey() === '') return $this->api_response(false, '認証用の秘密鍵が見つかりませんでした', ['otpwd' => '']); if (!$gm->verify_password($totp)) return $this->api_response(false, 'ワンタイム認証に失敗しました', ['otpwd' => '']); $otpwd = $this->register_otpwd($scvuser->id); return $this->api_response(true, 'ワンタイム認証に成功しました', ['otpwd' => $otpwd]); } private function register_otpwd($id) { $otpwd = str_random(64); $scvuser = Scvuser::find($id); $scvuser->otpwd = $otpwd; $scvuser->gauth_used = 1; $dbret = $scvuser->save(); if (ClusterHelper::isSlave() && ClusterHelper::isMasterActive() && ClusterHelper::isMasterAlive()) { $this->sync_gauth_info($scvuser); } else { $slave_dbret = 0; if (ClusterHelper::needsToSyncSlave()) $slave_dbret = ClusterHelper::updateScvuserToSlaveDB($scvuser); ClusterHelper::update_clusters_if_necessary($dbret, $slave_dbret); } return $otpwd; } private function sync_gauth_info($scvuser) { $timemill = ClusterHelper::getTimemill(); $master = ConfHelper::scvconf('SCV_CLUSTMASTER'); $slave = ConfHelper::scvconf('SCV_CLUSTSLAVE'); $id = $scvuser->id; $otpwd = $scvuser->otpwd; $gauth_key = $scvuser->gauth_key; $gauth_used = $scvuser->gauth_used; if (ClusterHelper::isMasterActive()) $this->update_gauth_info($master, $id, $otpwd, $gauth_key, $gauth_used, $timemill); if (ClusterHelper::isSlaveActive()) $this->update_gauth_info($slave, $id, $otpwd, $gauth_key, $gauth_used, $timemill); } private function update_gauth_info($dbhost, $id, $otpwd, $gauth_key, $gauth_used, $timemill) { $user = config('database.connections.master_database.username'); $pwd = config('database.connections.master_database.password'); $charset = config('database.connections.master_database.charset'); $dsn = "mysql:dbname=scv;host={$dbhost};charset={$charset}"; $pdo = new PDO($dsn, $user, $pwd); $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); $pdo->exec("update scvusers set otpwd = '{$otpwd}', gauth_key = '{$gauth_key}', gauth_used = {$gauth_used} where id = {$id};"); $pdo->exec("update clusters set last_writemill = {$timemill} where role = 'MASTER' or role = 'SLAVE';"); } public function user_gauth_setup(Request $req, $org, $user, $otpwd) { $scvuser = Scvuser::with_org($org, $user); if ($scvuser === null) { logger('GAuth-setup: ユーザが存在しません'); exit(); } if ($otpwd !== $scvuser->otpwd) { logger('GAuth-setup: otpwdが一致しません'); exit(); } $gm = new GAuthManager($scvuser); if ($gm->get_secretkey() === '') { $gm->renew_secretkey(); $this->sync_gauth_info($scvuser); } $gm->output_qr(); } public function qr_base64(Request $req) { $params = get_json_post(); $org = isset($params['organization']) ? $params['organization'] : null; $user = isset($params['user']) ? $params['user'] : null; $otpwd = isset($params['otpwd']) ? $params['otpwd'] : null; $json = ['qr_base64' => '']; if ($org === null || $user === null || $otpwd === null) return $this->api_response(false, '組織名、ユーザ名、otpwdは必須項目です', $json); $scvuser = Scvuser::with_org($org, $user); if ($scvuser === null) return $this->api_response(false, 'ユーザが存在しません', $json); if ($otpwd !== $scvuser->otpwd) { logger('GAuth-setup: otpwdが一致しません（Base64-QR取得時）'); return $this->api_response(false, 'ユーザの照合に失敗しました', $json); } $gm = new GAuthManager($scvuser); if ($gm->get_secretkey() === '') $gm->renew_secretkey(); try { $url = $gm->get_qr_url(); $png = file_get_contents($url); $enc = base64_encode($png); } catch (\Exception $e) { return $this->api_response(false, $e->getMessage(), $json); } $json['qr_base64'] = $enc; return $this->api_response(true, 'QRコードのBase64データの取得に成功しました', $json); } } function get_json_post() { if (!isset($_SERVER['CONTENT_TYPE'])) throw new \Exception('CONTENT_TYPEが存在しません'); $content_type = explode(';', trim(strtolower($_SERVER['CONTENT_TYPE']))); $media_type = $content_type[0]; if ($_SERVER['REQUEST_METHOD'] == 'POST' && $media_type == 'application/json') { $request = json_decode(file_get_contents('php://input'), true); } else { $request = $_REQUEST; foreach ($_REQUEST as $key => $value) { $request[$key] = json_decode($value, true); if ($request[$key] == null) { $request[$key] = $value; } } } return $request; } 