<?php
 namespace App\Http\Controllers\scvflow; use App\Http\Controllers\Controller; use Illuminate\Http\Request; use Illuminate\Support\Facades\Storage; use Illuminate\Support\Facades\Auth; use Validator; use App\Scvuser; use App\Scvflow; use App\Division; use App\FlowAuthorizer; use App\Jobs\SendReminderEmail; use App\Libs\ConfHelper; class ApiController extends Controller { use \App\Traits\ApiHelper; public function login(Request $req) { $org = $req->input('organization'); $user = $req->input('user'); $password = $req->input('password'); $using_joking_password = $req->input('using_joking_password'); if ($using_joking_password) { $scvuser = $this->attempt_joking_sso_login($org, $user, $password); } else { $scvuser = $this->attempt_local_login($org, $user, $password); } if ($scvuser) { $token = auth('api')->login($scvuser); return $this->api_response(true, 'アクセストークンの発行に成功しました。', [ 'access_token' => $token, 'expires_in' => auth('api')->factory()->getTTL() * 60 ]); } else { return $this->api_response(false, 'アクセストークンの発行に失敗しました。', [ 'access_token' => '', 'expires_in' => 0 ]); } } private function attempt_local_login($org, $user, $password) { return Scvuser::attemptScvLogin("{$org}/{$user}", $password); } private function attempt_joking_sso_login($org, $user, $password) { $password2 = $this->assemble_joking_password($org, $user); if ($password === $password2) return Scvuser::with_org($org, $user); else return null; } private function assemble_joking_password($organization, $user) { $key = sprintf( '%s%s%s%s', 'scvx', date('Ym'), $organization, $user ); return hash('sha512', $key); } public function login_for_curl(Request $req) { if (!env('APP_DEBUG')) return; return $this->login($req)->original['access_token']; } public function get_master_address(Request $req) { $master = ConfHelper::getMasterAddress(); if ($master) return $this->api_response(true, 'マスタサーバアドレスの取得に成功しました。', ['addr' => $master]); else return $this->api_response(false, 'マスタサーバアドレスの取得に失敗しました。', ['addr' => '']); } public function get_scvconf(Request $req) { $key = $req->input('key'); if ($key === null) { return $this->api_response(false, "scvconfの取得に失敗しました。\nキーが指定されていません。", ['value' => '']); } $value = (string)ConfHelper::scvconf($key); return $this->api_response(true, 'scvconfの取得に成功しました。', ['value' => $value]); } public function prior_info(Request $req, $organization, $user) { $scvuser = Scvuser::with_org($organization, $user); if ($scvuser === null) return $this->api_response(false, "申請者情報の取得に失敗しました。\nDBに接続できていない可能性があります。"); $applicant = [ 'name' => $scvuser->name, 'jpname' => $scvuser->jpname, 'department' => $scvuser->department, 'post' => $scvuser->post, 'employee_id' => $scvuser->employee_id, 'custom_data1' => $scvuser->custom_data1, 'custom_data2' => $scvuser->custom_data2, 'custom_data3' => $scvuser->custom_data3 ]; $query = Scvuser::join('scvgroups', 'scvusers.groupid', 'scvgroups.id') ->join('organizations', 'scvgroups.organization_id', 'organizations.id') ->where('organizations.name', $organization) ->where('scvusers.privilege', 1) ->where('scvusers.name', '!=', $user); if ($scvuser->flow_group) { $query->where(function($query) use($scvuser) { $query->where('scvusers.flow_group', $scvuser->flow_group) ->orWhere('scvusers.flow_group', ''); }); } $server_version = env('SCV_VERSION'); $accept_version = "4.0.110"; $multiple = version_compare($server_version, $accept_version, ">="); $scvusers = $query->select( 'scvusers.name', 'scvusers.jpname', 'scvusers.department', 'scvusers.post', 'scvusers.employee_id', 'scvusers.custom_data1', 'scvusers.custom_data2', 'scvusers.custom_data3' ) ->get(); if (!count($scvusers)) return $this->api_response(false, "承認者になれるユーザが存在しません。\nまたは、DBに接続できていない可能性があります。"); $authorizers = []; foreach ($scvusers as $scvuser) { $authorizers[] = [ 'name' => $scvuser->name, 'jpname' => $scvuser->jpname, 'department' => $scvuser->department, 'post' => $scvuser->post, 'employee_id' => $scvuser->employee_id, 'custom_data1' => $scvuser->custom_data1, 'custom_data2' => $scvuser->custom_data2, 'custom_data3' => $scvuser->custom_data3 ]; } return $this->api_response(true, '申請者、承認者一覧の取得に成功しました。', [ 'applicant' => $applicant, 'authorizers' => $authorizers, 'multiple' => $multiple ]); } public function user2department(Request $req, $organization, $user) { $scvuser = $this->get_user_with_org($organization, $user); if (!$scvuser) return $this->api_response(false, "ユーザの部署名の取得に失敗しました。\nユーザが存在しないか、DBに接続できません。", ['department' => '']); return $this->api_response(true, 'ユーザの部署名の取得に成功しました。', ['department' => $scvuser->department]); } public function normal_upload(Request $req) { return $this->upload_to_server($req, "upload"); } public function debug_normal_upload(Request $req) { if (!env('APP_DEBUG')) return; return $this->upload_to_server($req); } public function download_request(Request $req) { return $this->upload_to_server($req, "download"); } private function upload_to_server($req, $action_type) { $nomail = $req->input('nomail'); $organization = $req->input('organization'); $applicant_name = $req->input('applicant'); $authorizer_names_fmt = $req->input('authorizers'); $date = date('Y-m-d H:i:s'); $applicant = $this->get_user_with_org($organization, $applicant_name); if (!$applicant) return $this->api_response(false, "該当する申請者は存在しません。\nまたは、DBに接続できていない可能性があります。"); $authorizer_names = explode(',', $authorizer_names_fmt); foreach ($authorizer_names as $authorizer_name) { $authorizer = $this->get_user_with_org($organization, $authorizer_name); if ($authorizer === null) { return $this->api_response(false, "該当する承認者は存在しません。\nまたは、DBに接続できていない可能性があります。"); } if ($authorizer->privilege == 0) { return $this->api_response(false, '指定されたユーザ(' . $authorizer_name . ')に承認権限がありません。'); } $authorizers_id[] = $authorizer->user_id; } $file = $req->file('file'); if ($file === null || !$file->isValid()) return $this->api_response(false, 'ファイルの送信に失敗しました。'); if ($file->getClientOriginalName() === 'failfailfail.txt') { return $this->api_response(false, 'アップロードに失敗しました。（デバッグ用）'); } switch ($action_type) { case 'upload': $max_bytes = Scvflow::umax_bytes(); if ($max_bytes > 0) { $max_kb = $max_bytes / 1024; $validator = Validator::make($req->all(), ['file' => 'required|max:' . $max_kb]); if ($validator->fails()) return $this->api_response(false, 'ファイルサイズが制限を超過しています。'); } break; case 'download': $max_bytes = ConfHelper::getFlowDMAX(); if ($max_bytes > 0) { $max_kb = $max_bytes * 1024; $validator = Validator::make($req->all(), ['file' => 'required|max:' . $max_kb]); if ($validator->fails()) return $this->api_response(false, 'ファイルサイズが制限を超過しています。'); } break; } $owner = $this->get_save_dir_owner(); if ($owner === '') return $this->api_response(false, '保存先ディレクトリの所有者の取得に失敗しました。'); else if ($owner !== 'www-data') return $this->api_response(false, '保存先ディレクトリの所有者がwww-data以外になっています。'); $save_dir = Scvflow::get_save_dir(); $filename = $file->getClientOriginalName(); $dl_key = Scvflow::generate_dl_key(); if (!$file->move($save_dir, $dl_key)) return $this->api_response(false, 'サーバ内でのファイルの移動に失敗しました。'); $comment = $req->input('comment'); if ($comment === null) $comment = ''; $flow_data = new Scvflow; $flow_data->fill([ 'dl_key' => $dl_key, 'action_type' => $action_type, 'filename' => $filename, 'filesize' => $file->getClientSize(), 'comment' => $comment, 'applicant_id' => $applicant->user_id, 'authorizer_id' => $authorizer->user_id, 'status' => 'waiting', 'requested_at' => $date ]); $result_data = $flow_data->save(); if ($result_data != null) { foreach ($authorizers_id as $authorizer_id) { $flowauthorizer = new FlowAuthorizer; $flowauthorizer->fill([ 'flow_id' => $flow_data->id, 'authorizer_id' => $authorizer_id ]); $flowauthorizer->save(); } } $applicant_ip = $req->input('applicant_ip'); Scvflow::write_log($dl_key, $applicant_ip, $action_type); $host_url = url('/'); dispatch(new SendReminderEmail('requested', $action_type, $dl_key, $host_url, null)); return $this->api_response(true, 'ファイルのアップロードに成功しました。'); } public function get_user_with_org($org_name, $user_name) { return Scvuser::join('scvgroups', 'scvusers.groupid', '=', 'scvgroups.id') ->join('organizations', 'scvgroups.organization_id', '=', 'organizations.id') ->where('organizations.name', $org_name) ->where('scvusers.name', $user_name) ->select('scvusers.*', 'scvusers.id as user_id') ->first(); } public function get_save_dir_owner() { try { $save_dir = Scvflow::get_save_dir(); $owner = posix_getpwuid(fileowner($save_dir))['name']; return $owner; } catch (Exception $e) { return ''; } } public static function get_downloadable_file_all($applicant_id) { return Scvflow::getDownloadableFileListAll($applicant_id); } public static function get_downloadable_file($applicant_id, $action_type) { return Scvflow::getDownloadableFileList($applicant_id, $action_type); } public static function get_downloadable_file_with_org($org_name, $username, $action_type) { return Scvflow::getDownloadableFileListWithOrg($org_name, $username, $action_type); } public static function file_download($id) { return Scvflow::getDownloadFile($id); } }