<?php
namespace App\Http\Controllers\scvflow; use Illuminate\Http\Request; use App\Http\Requests; use App\Http\Controllers\Controller; use App\Scvflow; use App\Scvuser; use App\Libs\ConfHelper; class AuthRequestController extends Controller { use \App\Traits\ScvFlowCtrl; public function index(Request $req, $dl_key) { if (!$this->is_authorizer()) return $this->home_redirect('あなたにはアクセス権限がありません。', false); $request = Scvflow::get_request($dl_key); if ($request === null) return $this->home_redirect('申請データが見つかりませんでした。', false); $dl_url = Scvflow::get_dl_url($dl_key); $next_url = Scvflow::next_url($dl_key); $prev_url = Scvflow::prev_url($dl_key); $preview_html = $this->make_preview_html($request); $rewrite_on = ConfHelper::scvconf('SCV_FLOW_REWRITE'); return view('scvflow.auth.index', compact( 'request', 'dl_url', 'next_url', 'prev_url', 'preview_html', 'rewrite_on' )); } public function store(Request $req, $dl_key) { try { $action = $req->input('action'); $reason = $req->input('reason'); $login_user = $this->login_user(); $request = Scvflow::get_request($dl_key); $replace_file = $req->file('replace_file'); if ($request === null) throw new \Exception('申請データが見つかりませんでした'); if (!Scvuser::where('id', $request->applicant_id)->count()) throw new \Exception('該当する申請者が見つかりませんでした'); if ($action !== '承認' && $action !== '否認') throw new \Exception('リクエストパラメータが不正です'); if ($action === '承認') $success = Scvflow::permit_request($login_user, $dl_key, $reason, $replace_file, $msg); else $success = Scvflow::deny_request($login_user, $dl_key, $reason, $msg); return $this->same_redirect($msg, $success); } catch (\Exception $e) { return $this->same_redirect($e->getMessage(), false); } } private function make_preview_html($request) { if ($request->status === 'denied') { return '<div class="text-center">削除済みのファイルです。</div>'; } $dl_url = Scvflow::get_dl_url($request->dl_key); $preview_url = Scvflow::get_preview_url($request->dl_key); $file_type = $this->get_preview_file_type($request->filename); switch ($file_type) { case 'text': $filepath = Scvflow::original_filepath($request->dl_key); $text = file_get_contents($filepath, false, null, 0, 1024 * 512); $enc_from = mb_detect_encoding($text, ['UTF-8', 'SHIFT_JIS', 'EUC-JP']); if($enc_from == false) { $html = '<div style="white-space: pre-wrap">このファイルのエンコード形式には対応していません</div>'; break; } $text = mb_convert_encoding($text, 'UTF-8', $enc_from); $html = '<div style="white-space: pre-wrap">' . htmlentities($text) . '</div>'; break; case 'image': $html = '<div class="text-center"><img src="' . $preview_url . '" style="max-width: 95%; max-height: 95%"></div>'; try { $filepath = Scvflow::original_filepath($request->dl_key); $exif = exif_read_data($filepath, 'IFD0'); if (!$exif) throw new \Exception('Not JPEG'); $html .= '<br><div class="text-center bg-warning">Exif情報が見つかりました。</div>'; $html .= '<table class="table table-striped">'; foreach ($exif as $key => $section) { if (is_array($section)) $section = json_encode($section, JSON_PRETTY_PRINT); $section = mb_convert_encoding($section, 'UTF-8'); $html .= '<tr>'; $html .= '	<td>' . $key . '</td>'; $html .= '	<td style="white-space: pre-wrap">' . $section . '</td>'; $html .= '</tr>'; } $html .= '</table>'; } catch (\Exception $e) { $html .= '<br><div class="text-center bg-info">Exif情報は見つかりませんでした。</div>'; } break; case 'video': $html = '<div class="text-center" style="width: 95%; height: 95%">'; $html .= '	<video controls style="width: 100%; height: 100%"><source src="' . $preview_url . '">'; $html .= '		<a href="' . $preview_url . '">動画を再生</a>'; $html .= '	</video>'; $html .= '</div>'; break; default: $html = '<div class="text-center">この種類のファイルはプレビューに対応していません。</div>'; } return $html; } private function get_preview_file_type($filename) { if (preg_match('/\.(txt|csv|tsv|log|co?nf|ini|s?html?|css|js|php|pl|rb|go|lua|bat|vbs|cs|c|h|cpp|hpp)$/i', $filename)) return 'text'; else if (preg_match('/\.(jpe?g|png|gif|bmp|ico)$/i', $filename)) return 'image'; else if (preg_match('/\.(mp4|mwv|wma|flv|avi)$/i', $filename)) return 'video'; else return ''; } } 