<?php
 namespace App\Http\Controllers\scvflow; use Illuminate\Http\Request; use App\Http\Requests; use App\Http\Controllers\Controller; use Illuminate\Support\Facades\Auth; use App\Scvflow; class DownloadController extends Controller { use \App\Traits\ScvFlowCtrl; public function index(Request $req, $dl_key) { if (!Scvflow::exists($dl_key)) return $this->home_redirect('申請データが見つかりませんでした', false); $request = Scvflow::get_request($dl_key); switch ($request->status) { case 'waiting': if (!$this->is_authorizer()) return $this->home_redirect('承認待ちのファイルは承認権限を持つユーザのみDLできます', false); break; case 'denied': return $this->home_redirect('既に否認されたファイルです', false); } Scvflow::confirm_request($dl_key); return Scvflow::dl_response($dl_key); } public function preview(Request $req, $dl_key) { if (!Scvflow::exists($dl_key)) return abort(404); $status = Scvflow::get_request($dl_key)->status; if ($status === 'waiting' && !$this->is_authorizer() || $status === 'denied') return abort(403); $mime = $this->get_mime($dl_key); return Scvflow::dl_response($dl_key, $mime); } private function get_mime($dl_key) { $mime_map = [ 'bmp' => 'image/bmp', 'jpg' => 'image/jpeg', 'jpeg' => 'image/jpeg', 'gif' => 'image/gif', 'png' => 'image/png', 'ico' => 'image/x-icon', 'mp4' => 'video/mp4', 'wmv' => 'video/x-ms-wmv', 'wma' => 'audio/x-ms-wma', 'flv' => 'video/x-flv', 'avi' => 'video/x-msvideo' ]; $filename = Scvflow::get_request($dl_key)->filename; $ext = pathinfo($filename, PATHINFO_EXTENSION); $ext = mb_strtolower($ext); if ($mime_map[$ext]) return $mime_map[$ext]; else return 'application/octet-stream'; } } 