<?php
 namespace App\Http\Controllers\scvflow; use Illuminate\Http\Request; use App\Http\Requests\flow\DownloadRequest; use App\Http\Controllers\Controller; use App\Libs\ConfHelper; use App\Scvuser; use App\Scvflow; use App\FlowAuthorizer; use App\Jobs\SendReminderEmail; use Validator; class FlowDownloadRequestController extends Controller { public function create(Request $request) { if(!Scvflow::isDownloadableByGroupId(\Auth::user()->groupid)) { return redirect('scvflow')->withErrors('グループポリシーでFlowダウンロード機能が無効化されているため、ダウンロード申請を行うことができません。'); } if(ConfHelper::scvconf('SCV_FLOW') == 0) { return redirect('scvflow')->withErrors('サーバ全体でFlowダウンロード機能が無効化されているため、ダウンロード申請を行うことができません。'); } $scvuser = \Auth::user(); $authorizers = Scvuser::getFlowAuthorizers($scvuser); return view('scvflow.downloads.create', compact('authorizers', 'scvuser')); } public function store(DownloadRequest $request) { $date = date('Y-m-d H:i:s'); $action_type = 'download'; $authorizers_id = $request->authorizer_id; $authorizer_id = 0; $files = $request->file('request_file'); foreach ($authorizers_id as $authorizer_id) { $authorizer = Scvuser::find($authorizer_id); if ($authorizer === null) { return redirect()->back()->withErrors("該当する承認者は存在しません。\nまたは、DBに接続できていない可能性があります。"); } if ($authorizer->privilege == 0) { return redirect()->back()->withErrors('指定されたユーザ(' . $authorizer->name . ')に承認権限がありません。'); } } foreach ($files as $file) { if ($file === null || !$file->isValid()) { return redirect()->back()->withErrors("ファイルの送信に失敗しました。"); } $max_bytes = Scvflow::umax_bytes(); if ($max_bytes > 0) { $max_kb = $max_bytes / 1024; $validator = Validator::make($request->all(), ['request_file' => 'required|max:' . $max_kb]); if ($validator->fails()) { return redirect()->back()->withErrors($file->getClientOriginalName()."がファイルサイズ制限を超過しています。"); } } } $owner = $this->get_save_dir_owner(); if ($owner === '') { return redirect()->back()->withErrors("保存先ディレクトリの所有者の取得に失敗しました。"); } else if ($owner !== 'www-data') { return redirect()->back()->withErrors("保存先ディレクトリの所有者がwww-data以外になっています。"); } foreach ($files as $file) { $save_dir = Scvflow::get_save_dir(); $filename = $file->getClientOriginalName(); $dl_key = Scvflow::generate_dl_key(); if (!$file->move($save_dir, $dl_key)) { return redirect()->back()->withErrors("サーバ内でのファイルの移動に失敗しました。"); } $comment = $request->input('comment'); if ($comment === null) $comment = ''; $flow_data = new Scvflow; $flow_data->fill([ 'dl_key' => $dl_key, 'action_type' => $action_type, 'filename' => $filename, 'filesize' => $file->getClientSize(), 'comment' => $comment, 'applicant_id' => \Auth::user()->id, 'authorizer_id' => $authorizer_id, 'status' => 'waiting', 'requested_at' => $date ]); $result_data = $flow_data->save(); if ($result_data != null) { foreach ($authorizers_id as $authorizer_id) { $flowauthorizer = new FlowAuthorizer; $flowauthorizer->fill([ 'flow_id' => $flow_data->id, 'authorizer_id' => $authorizer_id ]); $flowauthorizer->save(); } } $applicant_ip = $request->ip(); Scvflow::write_log($dl_key, $applicant_ip, $action_type); $host_url = url('/'); dispatch(new SendReminderEmail('requested', $action_type, $dl_key, $host_url, null)); } return redirect('/scvflow')->with('okmsg', 'ダウンロード申請が完了しました。'); } public function get_save_dir_owner() { try { $save_dir = Scvflow::get_save_dir(); $owner = posix_getpwuid(fileowner($save_dir))['name']; return $owner; } catch (Exception $e) { return ''; } } } 