<?php
 namespace App\Http\Controllers\scvflow; use Illuminate\Http\Request; use App\Http\Controllers\Controller; use Illuminate\Foundation\Auth\AuthenticatesUsers; use Illuminate\Support\Facades\Auth; use Aacotroneo\Saml2\Facades\Saml2Auth; use App\Libs\ClusterHelper; use App\Libs\ConfHelper; use App\Http\Requests\flow\LoginRequest; use App\Services\Auth\AuthFailedException; use App\Services\Auth\ScvAuthType; use App\Services\Auth\ScvUserAuthService; class LoginController extends Controller { use AuthenticatesUsers; use \App\Traits\ScvFlowCtrl; protected $redirectTo = '/scvflow'; private $scvUserAuthService; public function __construct(ScvUserAuthService $scvUserAuthService) { $this->scvUserAuthService = $scvUserAuthService; } public function showLoginForm() { $cluster_err = false; $showing_form = true; if (ClusterHelper::isCluster() && !ClusterHelper::isMaster()) { $cluster_err = true; $showing_form = false; return view('scvflow.login', compact('showing_form', 'cluster_err')); } $auth = ConfHelper::active_auth(); if ($auth === ScvAuthType::SCVXSAML) { if (Auth::guard('scvuser') === null) return Saml2Auth::login(); return $this->home_redirect(); } $validAuthTypes = [ ScvAuthType::SCVXLOCAL, ScvAuthType::SCVXLOCAL_GA, ScvAuthType::SCVXKERBEROS ]; if (!in_array($auth, $validAuthTypes)) { $showing_form = false; return view('scvflow.login', compact('showing_form', 'cluster_err')) ->withErrors('現在の認証方式ではSCV Flowをご利用いただけません'); } return view('scvflow.login', compact('showing_form', 'cluster_err')); } protected function guard() { return Auth::guard('scvuser'); } public function logout(Request $request) { Auth::guard('scvuser')->logout(); return redirect('/scvflow/login'); } public function authenticate(LoginRequest $req) { $currentAuthType = ConfHelper::active_auth(); switch ($currentAuthType) { case ScvAuthType::SCVXLOCAL: case ScvAuthType::SCVXLOCAL_GA: $authType = ScvAuthType::SCVXLOCAL; break; case ScvAuthType::SCVXKERBEROS: $authType = ScvAuthType::SCVXKERBEROS; break; default: return $this->back_redirect('現在の認証方式ではSCV Flowをご利用いただけません', false)->withInput(); } $username = $req->input('username'); $password = $req->input('password'); try { $scvuser = $this->scvUserAuthService->authOrgUser($authType, $username, $password); } catch (AuthFailedException $e) { $message = $e->getMessage(); switch ($e->getCode()) { case AuthFailedException::USER_IS_LOCKED: $message = 'このユーザはロックされています、システム管理者へお問い合わせください。'; break; case AuthFailedException::PASSWORD_EXPIRED: if (in_array($currentAuthType, [ ScvAuthType::SCVXLOCAL, ScvAuthType::SCVXLOCAL_GA ])) { $message = 'パスワードの有効期限が切れています。RevoWorksクライアントからパスワードの変更を行ってください。'; } break; } return $this->back_redirect($message, false)->withInput(); } $path = $req->input('intended'); Auth::logout(); Auth::guard('scvuser')->loginUsingId($scvuser->id); return redirect($path); } } 