<?php
 namespace App\Http\Controllers\scvflow; use App\Http\Controllers\Controller; use Illuminate\Http\Request; use Illuminate\Support\Facades\Auth; use App\Scvflow; use App\FlowAuthorizer; use Carbon\Carbon; class RequestsCommonController extends Controller { use \App\Traits\ScvFlowCtrl; use \App\Traits\DateManager; private $limit = 20; public function index(Request $req) { $req->session()->reflash(); if ($this->is_authorizer()) return redirect('scvflow/authorizer'); else return redirect('scvflow/applicant'); } public function applicant_index(Request $req) { return $this->common_index($req, false); } public function authorizer_index(Request $req) { if (!$this->is_authorizer()) return redirect('/scvflow/applicant'); return $this->common_index($req, true); } public function applicant_store(Request $req) { $dl_keys = $req->input('dl_keys'); $action = $req->input('action'); if ($action === '取消') { Scvflow::bulk_cancel_requests($dl_keys, $okmsg, $errmsgs); return $this->same_redirect($okmsg, $errmsgs); } else { return $this->common_index($req, false); } } public function authorizer_store(Request $req) { $authorizer = $this->login_user(); $dl_keys = $req->input('dl_keys'); $action = $req->input('action'); $reason = $req->input('reason'); if ($action === '承認') { Scvflow::bulk_permit_requests($authorizer, $dl_keys, $reason, $okmsg, $errmsgs, true); return $this->same_redirect($okmsg, $errmsgs); } else if ($action === '否認') { Scvflow::bulk_deny_requests($authorizer, $dl_keys, $reason, $okmsg, $errmsgs, true); return $this->same_redirect($okmsg, $errmsgs); } else { return $this->common_index($req, true); } } private function common_index($req, $authorizer_page) { $this->init_date($start_date, $end_date, 'flow_requests'); $status = $this->init_status($req->input('status')); $keyword = $req->input('keyword'); $sort = $this->init_sort($req->input('sort')); $login_user = $this->login_user(); $end_date_arg = $end_date . ':59'; $jpname = $login_user->jpname ? $login_user->jpname : '(氏名未設定)'; if ($authorizer_page) { $title = $jpname . ' さん宛の申請一覧'; $requests = Scvflow::get_requests_to_authorizer( $this->limit, $login_user->id, $start_date, $end_date_arg, $status, $keyword, $sort ); } else { $title = $jpname . ' さんの申請一覧'; $requests = Scvflow::get_requests_from_applicant( $this->limit, $login_user->id, $start_date, $end_date_arg, $status, $keyword, $sort ); } $cnt = count($requests); return view('scvflow.requests_common', compact( 'authorizer_page', 'login_user', 'title', 'cnt', 'status', 'start_date', 'end_date', 'keyword', 'sort', 'requests' )); } private function init_status($status) { if ($status === '' || $status === 'waiting' || $status === 'permitted' || $status === 'denied') return $status; else return 'waiting'; } private function init_sort($sort) { if ($sort === 'asc' || $sort === 'desc') return $sort; else return 'asc'; } public function download_log(Request $req) { $start_ymd = $req->input('start_ymd'); $end_ymd = $req->input('end_ymd'); $start_date = Carbon::parse($start_ymd); $end_date = Carbon::parse($end_ymd); $end_date->addSecond(59); $scvflow_logs = ScvflowLog::search($start_date, $end_date, $req->input('q')); $csv = '結果,ファイル名,コメント,申請者,申請日時,承認者,承認／否認日時,否認理由' . PHP_EOL; foreach ($scvflow_logs as $scvflow_log) { $csv .= sprintf( '%s,%s,%s,%s,%s,%s,%s,%s' . PHP_EOL, $scvflow_log->status === 'permitted' ? '承認' : '否認', $scvflow_log->filename, $scvflow_log->comment, $scvflow_log->applicant, $scvflow_log->requested_at, $scvflow_log->authorizer, $scvflow_log->authorized_at, $scvflow_log->why_denied ); } $csv = mb_convert_encoding($csv, 'sjis'); $csv = rtrim($csv); $filename = 'Scvflows_' . date('Ymd') . '.csv'; return \Response::make($csv, 200, [ 'Content-Type' => 'text/csv', 'Content-Disposition' => 'attachment; filename="' . $filename . '"' ]); } } 