<?php
 namespace App\Http\Middleware; use Closure; use Exception; use Illuminate\Database\Connection; use Illuminate\Support\Facades\DB; class DbAlive { private $factory; public function __construct(DbAliveCheckerFactory $factory = null) { if ($factory !== null) { $this->factory = $factory; } else { $this->factory = new DbAliveCheckerFactoryImpl(); } } public function handle($request, Closure $next) { try { $conn = DB::connection(); $conf = new DbConfig($conn); $dbChecker = $this->factory->create($conf); $timeout = (int) config('scv.db_alive_timeout'); $dbChecker->isAlive($timeout); } catch (Exception $e) { logger('[DbAlive] ' . $e->getMessage()); abort(500); } return $next($request); } } class DbConfig { public $driver; public $host; public $port; public $database; public $username; public $password; public function __construct(Connection $conn) { $this->driver = $conn->getConfig('driver'); $this->host = $conn->getConfig('host'); $this->port = $conn->getConfig('port'); $this->database = $conn->getConfig('database'); $this->username = $conn->getConfig('username'); $this->password = $conn->getConfig('password'); } } interface DbAliveChecker { public function isAlive(int $timeout); } class PostgresqlDbAliveChecker implements DbAliveChecker { private $conf; public function __construct(DbConfig $conf) { $this->conf = $conf; } public function isAlive(int $timeout) { $connStr = 'host=' . $this->conf->host . ' dbname=' . $this->conf->database . ' user=' . $this->conf->username . ' password=' . $this->conf->password . ' connect_timeout=' . $timeout . (($this->conf->port == null) ? '' : ' port=' . $this->conf->port); $conn = pg_connect($connStr); if (!$conn) { throw new Exception('[pgsql] Failed to connect - host: ' . $this->conf->host . ', port: ' . $this->conf->port . ', dbname: ' . $this->conf->database ); } try { $result = pg_query($conn, 'SELECT 1'); if ($result === false) { throw new Exception('[pgsql] Failed to connect - host: ' . $this->conf->host . ', port: ' . $this->conf->port . ', dbname: ' . $this->conf->database ); } } finally { @pg_close($conn); } } } class MysqlDbAliveChecker implements DbAliveChecker { private $conf; public function __construct(DbConfig $conf) { $this->conf = $conf; } public function isAlive(int $timeout) { $mysqli = mysqli_init(); if (!$mysqli) { throw new Exception('[mysql] Failed to init'); } try { $mysqli->options(MYSQLI_OPT_CONNECT_TIMEOUT, $timeout); if ($this->canUseMysqliOptReadTimeout()) { $mysqli->options(MYSQLI_OPT_READ_TIMEOUT, $timeout); } $connected = $mysqli->real_connect( $this->conf->host, $this->conf->username, $this->conf->password, $this->conf->database, $this->conf->port ); if (!$connected or mysqli_connect_errno() !== 0) { throw new Exception('[mysql] Failed to connect - err: ' . mysqli_connect_error() . ', hostname: ' . $this->conf->host . ', port: ' . $this->conf->port . ', database: ' . $this->conf->database ); } $mysqli->query('SELECT 1'); if (mysqli_errno($mysqli) !== 0) { throw new Exception('[mysql] Failed to query - err: ' . mysqli_error($mysqli)); } } finally { @$mysqli->close(); } } private function canUseMysqliOptReadTimeout(): bool { return version_compare(phpversion(), '7.2.0', '>='); } } class NullDbAliveChecker implements DbAliveChecker { public function isAlive(int $timeout) { logger('[DbAlive] [null] Unknown database. return OK'); } } interface DbAliveCheckerFactory { public function create($config): DbAliveChecker; } class DbAliveCheckerFactoryImpl implements DbAliveCheckerFactory { public function create($config): DbAliveChecker { switch ($config->driver) { case 'pgsql': return new PostgresqlDbAliveChecker($config); case 'mysql': return new MysqlDbAliveChecker($config); default: return new NullDbAliveChecker($config); } } } 