<?php
 namespace App\Http\Requests; use App\Http\Requests\Request; use App\Organization; class AdminPolicyRequest extends Request { public function authorize() { return true; } public function rules() { $method = $this->method(); $rule = [ 'pwd_length' => ['integer', 'max:32', 'min:1', 'required'], 'pwd_generation_limit' => ['integer', 'max:24'], 'lock_limit' => ['required'] ]; if ($method === 'POST') $rule['name'][] = 'unique:organizations'; if ($method === 'POST' || $method === 'PUT') return $rule; return []; } public function messages() { return [ 'pwd_length.required' => 'パスワードの最低文字数が入力されていません。', 'pwd_length.max' => 'パスワードの最低文字数は最大32文字以内で設定してください。', 'pwd_length.min' => 'パスワードの最低文字数は最低1文字以上で設定してください。', 'pwd_generation_limit.max' => '重複チェックを行う世代数は最大24世代以内で設定してください。', 'lock_limit.required' => 'アカウントロックまでの試行回数が入力されていません。' ]; } public function withValidator($validator) { $validator->after(function ($validator) { $max_term = Request::input('pwd_max_term'); $min_term = Request::input('pwd_min_term'); if ($max_term > 0 && $min_term >= $max_term) { $msg = "パスワード変更の最低間隔は有効期限（{$max_term}日）未満で設定してください。"; $validator->errors()->add('pwd_min_term', $msg); } }); } }