<?php
 namespace App\Http\Requests; use Illuminate\Foundation\Http\FormRequest; use Illuminate\Validation\Rule; class BrSettingRequest extends FormRequest { public function authorize() { return true; } public function rules() { $method = $this->method(); if ($method == "POST" || $method == "PUT") { $rule = [ 'name' => [ 'required', 'between:6,35', 'regex:/^[A-Za-z0-9]+[A-Za-z0-9_\.\-]+$/' ], 'browsers' => [ 'required' ] ]; if($method == "POST"){ $rule['name'][] = Rule::unique('br_settings'); } else if ($method == "PUT") { $rule['name'][] = Rule::unique('br_settings')->ignore($this->route('br_setting')); } return $rule; } else if($method == "DELETE") { return [ 'id' => ['using_br_setting'] ]; } else { return []; } } public function messages() { return [ 'name.required' => '設定名を入力してください', 'name.unique' => 'すでに登録された設定名です', 'name.between' => '設定名は3文字から32文字で入力してください', 'name.regex' => '設定名に使用できない文字が含まれています', 'browsers.required' => '使用するブラウザを選択してください', 'id.using_br_setting' => '利用中の設定のため削除できません' ]; } protected function validationData() { if($this->method() == "DELETE"){ $data = $this->all(); if (isset($this->id)) { $data['id'] = $this->id; } return $data; }else{ return $this->all(); } } protected function prepareForValidation() { $this->merge([ 'name' => 'BR_'.strtoupper($this->input('name')) ]); } public function formatParameters($param) { $vpn_settings = array(); if (!isset($param['vpn_settings'])) { $param['vpn_settings'] = null; } else { foreach ($param['vpn_settings'] as $key => $value) { $vpn_settings[$key] = [ 'order' => $value]; } } $param['vpn_settings'] = $vpn_settings; $param['available_browser'] = isset($param['browsers']) ? implode(',', $param['browsers']) : ''; return $param; } } 