<?php
 namespace App\Http\Requests; use Illuminate\Foundation\Http\FormRequest; use Illuminate\Validation\Rule; use App\Firefoxprofile; use App\Organization; class FirefoxProfRequest extends FormRequest { public function authorize() { return true; } public function rules() { $method = $this->method(); if($method == "POST" || $method == "PUT"){ $rule = [ 'name' => ['required', 'regex:/^[A-Za-z0-9]+[A-Za-z0-9_\.\-]+$/', 'between:8,37'], 'homepage' => ['max:255'], 'downloaddir' => ['regex:/^[^ ]+$/'], 'bookmarks' => ['max_bookmarks'], 'organization_id' => ['same_organization'], 'pauth' => ['required_if:pauth_account,1'], 'pauth_user' => ['max:255','required_if:pauth_account,1'], 'pauth_pass' => ['max:96','required_if:pauth_account,1'], 'no_proxy_host' => ['max:512'], 'allowed_popups' => ['max:65535'] ]; if ($method == "POST") { $rule['name'][] = Rule::unique('firefoxprofiles')->where(function($query){ $query->where('organization_id', $this->input('organization_id')); }); } else if ($method == "PUT") { $rule['name'][] = Rule::unique('firefoxprofiles')->ignore($this->id)->where(function($query){ $query->where('organization_id', $this->input('organization_id')); }); $rule['id'] = ['using_prof_other_org']; } return $rule; } else if($method == "DELETE"){ return [ 'id' => [ 'using_prof'], 'organization_id' => ['same_organization'] ]; }else{ return []; } } public function messages() { return [ 'id.using_prof' => '使用中のプロファイルです。', 'id.using_prof_other_org' => '使用中のプロファイルのため、組織の変更ができません。', 'name.required' => 'Firefox設定名は必須項目です。', 'name.unique' => '既に登録されたプロファイル名です。', 'name.regex' => 'Firefox設定名に使用できない文字が含まれています。', 'name.between' => 'Firefox設定名は3文字から32文字で入力してください。', 'homepage.max' => 'ホームページは255文字以内で入力してください', 'downloaddir.regex' => 'ダウンロードフォルダ名に使用できない文字が含まれています。', 'bookmarks.max_bookmarks' => 'ブックマークは100件まで登録可能です。', 'same_organization' => '指定された組織にFirefox設定を操作する権限がありません。', 'pauth.required_if' => 'Proxy-Authorizationを有効化してください。', 'pauth_user.max' => 'Proxy-Authorizationのユーザ名は255文字以内で入力してください。', 'pauth_pass.max' => 'Proxy-Authorizationのパスワードは255文字以内で入力してください。', 'pauth_user.required_if' => 'Proxy-Authorizationのユーザ名を入力してください。', 'pauth_pass.required_if' => 'Proxy-Authorizationのパスワードを入力してください。', 'no_proxy_host.max' => 'プロキシ無しで接続は512文字以内で入力してください。', 'allowed_popups.max' => 'ポップアップ許可サイトは65535文字以内で入力してください。', ]; } protected function prepareForValidation() { $xff_flag = $this->input('xff_flag'); if($xff_flag === null || $xff_flag === 'empty') { $xff_flag = 0; }else if($xff_flag === 'ip'){ $xff_flag = 1; }else if($xff_flag === 'user'){ $xff_flag = 2; } $no_proxy_host = $this->input('no_proxy_host'); if($this->input('proxy_type') != "1") { $no_proxy_host = ""; } $this->merge([ 'name' => 'PROF_'.strtoupper($this->input('name')), 'disable_js' => $this->input('disable_js') != null ? true : false, 'startup_page' => $this->input('startup_page') ?: 0, 'downloaddir' => $this->input('file_path').":".$this->input('downloaddir'), 'http_proxy_host' => $this->input('http_proxy_host') ?: 0, 'http_proxy_port' => $this->input('http_proxy_port') ?: 0, 'ssl_proxy_host' => $this->input('ssl_proxy_host') ?: 0, 'ssl_proxy_port' => $this->input('ssl_proxy_port') ?: 0, 'proxy_url' => $this->input('proxy_url') ?: "", 'proxy_auth' => $this->input('auth_flag') != null ? true : false, 'same_proxy' => $this->input('same_proxy') != null ? true : false, 'no_proxy_host' => $no_proxy_host, 'import_enterprise_roots' => $this->input('import_enterprise_roots') != null ? true : false, 'contents_process' => $this->input('contents_process') ?: 0, 'save_history' => $this->input('save_history') != null ? true : false, 'save_password' => $this->input('save_password') != null ? true : false, 'save_cookie' => $this->input('save_cookie') != null ? true : false, 'enable_open_chrome' => $this->input('open_chrome') != null ? true : false, 'captive_portal' => $this->input('captive_portal') != null ? true : false, 'disable_config' => $this->input('about_config') != null ? true : false, 'disable_accounts' => $this->input('about_accounts') != null ? true : false, 'disable_addons' => $this->input('about_addons') != null ? true : false, 'disable_home' => $this->input('about_home') != null ? true : false, 'disable_preferences' => $this->input('about_preferences') != null ? true : false, 'disable_support' => $this->input('about_support') != null ? true : false, 'disable_profiles' => $this->input('about_profiles') != null ? true : false, 'disable_all' => $this->input('about_all') != null ? true : false, 'pauth_flag' => $this->input('pauth') != null ? 1 : 0, 'pauth_account' => $this->input('pauth_account') != null ? 1 : 0, 'pauth_user' => $this->input('pauth_account') != null ? $this->input('pauth_user') : "", 'pauth_pass' => $this->input('pauth_account') != null ? $this->input('pauth_pass') : "", 'disable_pocket' => $this->input('disable_pocket') != null ? 1 : 0, 'disable_formfill' => $this->input('disable_formfill') != null ? 1 : 0, 'history_max_age' => $this->input('history_max_age') ?: 0, 'xff_flag' => $xff_flag, 'scvtimemill' => floor(microtime(true) * 1000), ]); } } 